/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AISymbolsRequest;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.AIUtilsCommon;
import ro.amiq.dvt.ai.contributor.AILangContributorManager;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.EditorRange;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.DVTSymbolCollector;
import ro.amiq.dvt.symbolcollector.DVTSymbolKind;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorRequest;
import ro.amiq.dvt.symbolcollector.SymbolQueryKey;
import ro.amiq.dvt.symbolcollector.SymbolQueryUtils;
import ro.amiq.dvt.symbolcollector.SymbolQueryWrapper;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;

public enum AISymbolSolver {
    INSTANCE;


    public List<String> getSymbolsForAutocomplete(String query, IProject iProject, BooleanSupplier isCanceled) {
        AISymbolsRequest symbolsRequest;
        List symbolsPrerequisites;
        String queryKey = SymbolQueryUtils.getQueryKey((String)query);
        if (SymbolQueryKey.EXTENDS.isEqualTo(queryKey)) {
            query = SymbolQueryKey.CLASS.toQuery(SymbolQueryUtils.getQueryPattern((String)query));
        }
        if ((symbolsPrerequisites = DVTSymbolCollector.INSTANCE.collectSymbolsPrerequisites((ISymbolCollectorRequest)(symbolsRequest = new AISymbolsRequest(query, iProject, isCanceled)))) == null || symbolsPrerequisites.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ISymbolCollectorPrerequisite prerequisite : symbolsPrerequisites) {
            IDVTElementWrapper elementWrapper;
            IAILangContributor aiContributor;
            DVTSymbolKind symbolKind = DVTSymbolKind.of((ISymbolCollectorPrerequisite)prerequisite);
            if (symbolKind == null) continue;
            DVTLabelProviderProxy labelProvider = symbolKind.getLabelProvider();
            if (prerequisite instanceof IMacroInfo) {
                result.add(labelProvider.getText((Object)prerequisite));
                continue;
            }
            if (!(prerequisite instanceof IDVTElementWrapper) || (aiContributor = AILangContributorManager.INSTANCE.getContributor((elementWrapper = (IDVTElementWrapper)prerequisite).getLanguageKind())) == null || aiContributor.isSymbolFiltered(elementWrapper) || !this.isElementWrapperExpandable(elementWrapper)) continue;
            result.add(labelProvider.getText((Object)elementWrapper));
        }
        return result;
    }

    public List<CodeSnippet> solveSymbol(String query, int maxNumber, IProject project, BooleanSupplier isCanceled) {
        SymbolQueryWrapper queryWrapper = SymbolQueryUtils.processQuery((String)query);
        String queryKey = queryWrapper.getQueryKey();
        if (SymbolQueryKey.FILE.isEqualTo(queryKey)) {
            return this.solveFileSymbol(query, maxNumber, project, isCanceled);
        }
        String queryPattern = queryWrapper.getQueryPattern();
        if (!SymbolQueryUtils.hasSpecialCharacters((String)queryPattern)) {
            query = SymbolQueryUtils.assembleQuery((String)queryKey, (String)SymbolQueryUtils.makeExactPattern((String)queryPattern));
        }
        AISymbolsRequest symbolsRequest = new AISymbolsRequest(query, maxNumber, project, isCanceled);
        List symbolsPrerequisites = DVTSymbolCollector.INSTANCE.collectSymbolsPrerequisites((ISymbolCollectorRequest)symbolsRequest);
        AIUtils.getInstance().checkSymbolSolvingCancellation(isCanceled, query);
        if (symbolsPrerequisites == null || symbolsPrerequisites.isEmpty()) {
            symbolsRequest.handleProtectedSymbols();
            return Collections.emptyList();
        }
        ArrayList<CodeSnippet> results = new ArrayList<CodeSnippet>();
        int currentNumberOfResults = 0;
        for (ISymbolCollectorPrerequisite prerequisite : symbolsPrerequisites) {
            List<CodeSnippet> expansions;
            IAILangContributor aiContributor;
            IRfNamedElement namedElement;
            AIUtils.getInstance().checkSymbolSolvingCancellation(isCanceled, query);
            if (prerequisite instanceof IMacroInfo) {
                IAILangContributor vlogContributor = AILangContributorManager.INSTANCE.getContributor(LanguageKind.VLOG);
                CodeSnippet expansion = vlogContributor.expandMacro((IMacroInfo)prerequisite);
                if (expansion == null) continue;
                results.add(expansion);
                if (++currentNumberOfResults < maxNumber) continue;
                return results;
            }
            if (!(prerequisite instanceof IDVTElementWrapper) || (namedElement = (IRfNamedElement)((IDVTElementWrapper)prerequisite).getRfElement(IRfNamedElement.class)) == null || (aiContributor = AILangContributorManager.INSTANCE.getContributor(namedElement.getLanguageKind())) == null || (expansions = aiContributor.expandNamedElement(namedElement)) == null || expansions.isEmpty()) continue;
            results.addAll(expansions);
            if (++currentNumberOfResults < maxNumber) continue;
            return results;
        }
        return results;
    }

    public List<String> getValidSymbols(List<String> symbolNames, IProject iProject, BooleanSupplier isCanceled) {
        return symbolNames.stream().filter(query -> this.isSymbolValid((String)query, iProject, isCanceled)).collect(Collectors.toList());
    }

    private boolean isSymbolValid(String query, IProject iProject, BooleanSupplier isCanceled) {
        SymbolQueryWrapper queryWrapper = SymbolQueryUtils.processQuery((String)query);
        String queryKey = SymbolQueryUtils.getQueryKey((String)query);
        String queryPattern = queryWrapper.getQueryPattern();
        if (SymbolQueryKey.FILE.isEqualTo(queryKey)) {
            return true;
        }
        if (SymbolQueryKey.EXTENDS.isEqualTo(queryKey)) {
            query = SymbolQueryKey.CLASS.toQuery(SymbolQueryUtils.getQueryPattern((String)query));
        }
        if (!SymbolQueryUtils.hasSpecialCharacters((String)queryPattern)) {
            query = SymbolQueryUtils.assembleQuery((String)queryKey, (String)SymbolQueryUtils.makeExactPattern((String)queryPattern));
        }
        boolean isValid = true;
        AISymbolsRequest symbolsRequest = new AISymbolsRequest(query, 1, iProject, isCanceled);
        List symbolsPrerequisites = DVTSymbolCollector.INSTANCE.collectSymbolsPrerequisites((ISymbolCollectorRequest)symbolsRequest);
        if (symbolsPrerequisites == null || symbolsPrerequisites.isEmpty()) {
            isValid = false;
        }
        return isValid;
    }

    public List<IRfNamedElement> getNamedElementsByName(String query, IProject iProject, BooleanSupplier isCanceled) {
        SymbolQueryWrapper queryWrapper = SymbolQueryUtils.processQuery((String)query);
        String queryKey = queryWrapper.getQueryKey();
        String queryPattern = queryWrapper.getQueryPattern();
        if (!SymbolQueryUtils.hasSpecialCharacters((String)queryPattern)) {
            query = SymbolQueryUtils.assembleQuery((String)queryKey, (String)SymbolQueryUtils.makeExactPattern((String)queryPattern));
        }
        AISymbolsRequest symbolsRequest = new AISymbolsRequest(query, iProject, isCanceled);
        List symbolsPrerequisites = DVTSymbolCollector.INSTANCE.collectSymbolsPrerequisites((ISymbolCollectorRequest)symbolsRequest);
        AIUtils.getInstance().checkSymbolSolvingCancellation(isCanceled, query);
        if (symbolsPrerequisites == null || symbolsPrerequisites.isEmpty()) {
            symbolsRequest.handleProtectedSymbols();
            return Collections.emptyList();
        }
        ArrayList<IRfNamedElement> results = new ArrayList<IRfNamedElement>();
        for (ISymbolCollectorPrerequisite prerequisite : symbolsPrerequisites) {
            IDVTElementWrapper elementWrapper;
            Object rfElement;
            AIUtils.getInstance().checkSymbolSolvingCancellation(isCanceled, query);
            if (prerequisite instanceof IMacroInfo && prerequisite instanceof IRfNamedElement) {
                results.add((IRfNamedElement)prerequisite);
                continue;
            }
            if (!(prerequisite instanceof IDVTElementWrapper) || !((rfElement = (elementWrapper = (IDVTElementWrapper)prerequisite).getRfElement()) instanceof IRfNamedElement)) continue;
            results.add((IRfNamedElement)rfElement);
        }
        return results;
    }

    protected Map<IRfNamedElement, EditorRange> getNamedElementsMatchingType(SymbolQueryKey queryKey, IProject iProject, BooleanSupplier isCanceled) {
        if (queryKey == null) {
            return Collections.emptyMap();
        }
        String query = queryKey.toQuery();
        AISymbolsRequest symbolsRequest = new AISymbolsRequest(query, iProject, isCanceled);
        List symbolsPrerequisites = DVTSymbolCollector.INSTANCE.collectSymbolsPrerequisites((ISymbolCollectorRequest)symbolsRequest);
        AIUtils.getInstance().checkSymbolSolvingCancellation(isCanceled, query);
        if (symbolsPrerequisites == null || symbolsPrerequisites.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<IRfNamedElement, EditorRange> matches = new HashMap<IRfNamedElement, EditorRange>();
        for (ISymbolCollectorPrerequisite prerequisite : symbolsPrerequisites) {
            IFile file;
            IRfDefElement declaration;
            DVTSymbolKind symbolKind = DVTSymbolKind.of((ISymbolCollectorPrerequisite)prerequisite);
            if (symbolKind != DVTSymbolKind.TYPE || !(prerequisite instanceof IDVTElementWrapper)) continue;
            AIUtils.getInstance().checkSymbolSolvingCancellation(isCanceled, query);
            IDVTElementWrapper elementWrapper = (IDVTElementWrapper)prerequisite;
            Object rfElement = elementWrapper.getRfElement();
            if (!(rfElement instanceof IRfNamedElement)) continue;
            IRfNamedElement namedElement = (IRfNamedElement)rfElement;
            if (queryKey.toString().equals(namedElement.getName()) || (declaration = namedElement.getDeclaration()) == null) continue;
            int startOffset = declaration.getStartOffset();
            int endOffset = declaration.getEndOffset();
            ParserPath parserPath = declaration.getParserPath();
            if (parserPath == null || (file = DVTFileUtils.getInstance().findProjectFile(iProject, parserPath.path)) == null) continue;
            EditorRange editorRange = new EditorRange(file, startOffset, endOffset);
            matches.put(namedElement, editorRange);
        }
        return matches;
    }

    private List<CodeSnippet> solveFileSymbol(String query, int maxNumber, IProject iProject, BooleanSupplier isCanceled) {
        StringBuilder queryBuilder = new StringBuilder(query);
        AIUtilsCommon.LineRange lineRange = AIUtils.getInstance().extractLineRangeFromFileQuery(queryBuilder);
        query = queryBuilder.toString();
        List<String> fullPaths = this.getAbsolutePathsFromFileQuery(query, iProject, isCanceled);
        ArrayList<CodeSnippet> results = new ArrayList<CodeSnippet>();
        for (String fullPath : fullPaths) {
            AIUtils.getInstance().checkSymbolSolvingCancellation(isCanceled, query);
            if (AIUtils.getInstance().isFileBinary(new File(fullPath))) {
                if (fullPaths.size() != 1) continue;
                AIUtils.getInstance().onDidExpandBinaryFile(fullPath);
                continue;
            }
            String fileContent = Utils.readFileContentBetweenLines((String)fullPath, (IProject)iProject, (int)(lineRange == AIUtilsCommon.LineRange.DEFAULT_LINE_RANGE ? 0 : lineRange.getStartLine() - 1), (int)(lineRange.getEndLine() - 1));
            if (fileContent == null || fileContent.isEmpty()) continue;
            int startLine = lineRange == AIUtilsCommon.LineRange.DEFAULT_LINE_RANGE ? -1 : lineRange.getStartLine();
            int endLine = lineRange == AIUtilsCommon.LineRange.DEFAULT_LINE_RANGE ? -1 : lineRange.getEndLine();
            CodeSnippet codeSnippet = new CodeSnippet(fileContent, AIPathUtils.INSTANCE.makePathRelativeToProject(fullPath, iProject), startLine, endLine);
            results.add(codeSnippet);
            if (results.size() < maxNumber) continue;
            return results;
        }
        return results;
    }

    protected List<String> getAbsolutePathsFromFileQuery(String query, final IProject iProject, final BooleanSupplier isCanceled) {
        final ArrayList<String> results = new ArrayList<String>();
        results.addAll(this.getFullPathsFromCompiledFileQuery(query, iProject, isCanceled));
        String filePath = query.substring(SymbolQueryKey.FILE.toString().length() + 1);
        ArrayList<String> invalidEnvVars = new ArrayList<String>();
        filePath = AIPathUtils.INSTANCE.replaceEnvVarsInPath(filePath, invalidEnvVars, iProject);
        if (filePath == null) {
            return AIPathUtils.INSTANCE.sortPathsAndEliminateDuplicates(results);
        }
        if (!invalidEnvVars.isEmpty()) {
            String warningMessage = AIUtils.getInstance().computeInvalidEnvVarsWarningMessage(invalidEnvVars, false);
            AIUtils.getInstance().showInvalidEnvironmentVariablesWarning(warningMessage, -1);
        }
        if ((filePath = AIPathUtils.INSTANCE.normalizeAndMakePathAbsolute(filePath, iProject)) == null) {
            return AIPathUtils.INSTANCE.sortPathsAndEliminateDuplicates(results);
        }
        int globCharacterIndex = AIPathUtils.INSTANCE.getIndexOfFirstGlobPatternCharInPath(filePath);
        if (globCharacterIndex < 0) {
            if (!new File(filePath).isFile()) {
                return AIPathUtils.INSTANCE.sortPathsAndEliminateDuplicates(results);
            }
            int protectLineNumber = AIProtectManager.INSTANCE.getProtectLineNumber(filePath, iProject);
            if (protectLineNumber > 0) {
                AIUtils.getInstance().onDidAccessProtectedFile(filePath, protectLineNumber);
            }
            results.add(filePath);
            return AIPathUtils.INSTANCE.sortPathsAndEliminateDuplicates(results);
        }
        int lastPathSeparatorIndex = AIPathUtils.INSTANCE.getLastPathSeparatorIndexInPath(filePath.substring(0, globCharacterIndex));
        if (lastPathSeparatorIndex < 0) {
            return AIPathUtils.INSTANCE.sortPathsAndEliminateDuplicates(results);
        }
        Path directory = Paths.get(filePath.substring(0, lastPathSeparatorIndex + 1), new String[0]);
        if (directory == null || directory.toFile() == null || !directory.toFile().isDirectory()) {
            return AIPathUtils.INSTANCE.sortPathsAndEliminateDuplicates(results);
        }
        filePath = filePath.replace("**" + File.separator, "**");
        if (DVTFileUtils.getInstance().pathStartsWithADriveLetter(filePath)) {
            filePath = filePath.replace("\\", "\\\\");
        }
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + filePath);
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (isCanceled != null && isCanceled.getAsBoolean()) {
                        return FileVisitResult.TERMINATE;
                    }
                    String pathString = path.toString();
                    if (pathString == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (pathMatcher.matches(path) && !AIProtectManager.INSTANCE.isFileProtected(pathString, iProject)) {
                        results.add(pathString);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (isCanceled != null && isCanceled.getAsBoolean()) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
        return AIPathUtils.INSTANCE.sortPathsAndEliminateDuplicates(results);
    }

    public List<String> getFullPathsFromCompiledFileQuery(String query, IProject iProject, BooleanSupplier isCanceled) {
        AISymbolsRequest symbolsRequest = new AISymbolsRequest(query, iProject, isCanceled);
        List symbolsPrerequisites = DVTSymbolCollector.INSTANCE.collectSymbolsPrerequisites((ISymbolCollectorRequest)symbolsRequest);
        AIUtils.getInstance().checkSymbolSolvingCancellation(isCanceled, query);
        if (symbolsPrerequisites == null || symbolsPrerequisites.isEmpty()) {
            symbolsRequest.handleProtectedSymbols();
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (ISymbolCollectorPrerequisite prerequisite : symbolsPrerequisites) {
            ParserPath parserPath;
            DVTSymbolKind symbolKind = DVTSymbolKind.of((ISymbolCollectorPrerequisite)prerequisite);
            if (symbolKind != DVTSymbolKind.COMPILED_FILE || !(prerequisite instanceof IDVTElementWrapper)) continue;
            AIUtils.getInstance().checkSymbolSolvingCancellation(isCanceled, query);
            IDVTElementWrapper elementWrapper = (IDVTElementWrapper)prerequisite;
            LanguageKind languageKind = elementWrapper.getLanguageKind();
            IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
            if (aiContributor == null || (parserPath = aiContributor.getFileSymbolParserPath(elementWrapper)) == null || parserPath.path == null) continue;
            results.add(parserPath.path);
        }
        return results;
    }

    private boolean isElementWrapperExpandable(IDVTElementWrapper elementWrapper) {
        LanguageKind languageKind = elementWrapper.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return false;
        }
        if (aiContributor.isSymbolFile(elementWrapper)) {
            ParserPath parserPath = aiContributor.getFileSymbolParserPath(elementWrapper);
            return parserPath != null && parserPath.path != null;
        }
        Object rfElement = elementWrapper.getRfElement();
        if (rfElement instanceof IRfNamedElement) {
            return AIUtils.getInstance().getFilePathFromNamedElement((IRfNamedElement)rfElement, false) != null;
        }
        return false;
    }
}

