/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.symbolcollector.DVTSymbolKind;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorRequest;

public class AISymbolsRequest
implements ISymbolCollectorRequest {
    private final String query;
    private final int maxSymbolsPerCategory;
    private final BooleanSupplier isCanceledSupplier;
    private final Set<ISymbolCollectorPrerequisite> protectedSymbols;
    private final IProject project;
    private static final Integer DEFAULT_SYMBOL_LIMIT = 100;
    private static final DVTSymbolKind[] DEFAULT_SYMBOL_KINDS = new DVTSymbolKind[]{DVTSymbolKind.TYPE, DVTSymbolKind.MACRO};

    public AISymbolsRequest(String query, IProject iProject, BooleanSupplier isCanceledSupplier) {
        this(query, DEFAULT_SYMBOL_LIMIT, iProject, isCanceledSupplier);
    }

    protected AISymbolsRequest(String query, int maxSymbolsPerCategory, IProject project, BooleanSupplier isCanceledSupplier) {
        this.project = project;
        this.query = query;
        this.maxSymbolsPerCategory = maxSymbolsPerCategory;
        this.isCanceledSupplier = isCanceledSupplier;
        this.protectedSymbols = new HashSet<ISymbolCollectorPrerequisite>(1);
    }

    public String getQuery() {
        return this.query;
    }

    public IProject getProject() {
        return this.project;
    }

    public DVTSymbolKind[] getDefaultSymbolKinds() {
        return DEFAULT_SYMBOL_KINDS;
    }

    public int getMaxSymbolsPerCategory() {
        return this.maxSymbolsPerCategory;
    }

    public boolean isCanceled() {
        if (this.isCanceledSupplier == null) {
            return false;
        }
        return this.isCanceledSupplier.getAsBoolean();
    }

    public boolean ignoreContentFilters() {
        return true;
    }

    public boolean shouldSkipSymbol(ISymbolCollectorPrerequisite symbol) {
        if (symbol instanceof IMacroInfo && this.shouldSkipMacro((IMacroInfo)symbol)) {
            return true;
        }
        String filePath = AIUtils.getInstance().getFilePathForSymbol(symbol);
        if (AIProtectManager.INSTANCE.isFileProtected(filePath, symbol.getProject())) {
            this.protectedSymbols.add(symbol);
            return true;
        }
        return false;
    }

    private boolean shouldSkipMacro(IMacroInfo macro) {
        if (macro == null) {
            return true;
        }
        IRfNamedElement macroCategory = macro.getCategory();
        if (macroCategory == null) {
            return true;
        }
        if (LanguageKind.E.equals((Object)macroCategory.getLanguageKind())) {
            return true;
        }
        String categoryName = macroCategory.getSignature();
        return "If(n)def Controls".equals(categoryName) || "Ifndef Guards".equals(categoryName);
    }

    protected void handleProtectedSymbols() {
        if (this.protectedSymbols == null || this.protectedSymbols.size() != 1) {
            return;
        }
        ISymbolCollectorPrerequisite symbol = this.protectedSymbols.iterator().next();
        if (symbol == null) {
            return;
        }
        String fullPath = AIUtils.getInstance().getFilePathForSymbol(symbol);
        int protectFileLine = AIProtectManager.INSTANCE.getProtectLineNumber(fullPath, symbol.getProject());
        if (protectFileLine > 0) {
            AIUtils.getInstance().onDidAccessProtectedFile(fullPath, protectFileLine);
        }
    }
}

