/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIConsole;
import ro.amiq.dvt.ai.AIExpansionUtils;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProgressIndicatorManager;
import ro.amiq.dvt.ai.AISnippetSolver;
import ro.amiq.dvt.ai.AIUtilsCommon;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.EditorRange;
import ro.amiq.dvt.ai.model.LangId;
import ro.amiq.dvt.ai.model.LogSeverity;
import ro.amiq.dvt.ai.model.LogTarget;
import ro.amiq.dvt.ai.model.Problem;
import ro.amiq.dvt.ai.model.ProblemInfo;
import ro.amiq.dvt.ai.model.VerissimoFailureInfo;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIRequestCancellationException;
import ro.amiq.dvt.ai.ui.statusbarnotifications.AIInvalidEnvVarsInProtectFileWarningNotification;
import ro.amiq.dvt.ai.ui.statusbarnotifications.AIProtectedFileAccessErrorNotification;
import ro.amiq.dvt.ai.ui.statusbarnotifications.StatusBarErrorNotificationWithActions;
import ro.amiq.dvt.ai.ui.statusbarnotifications.StatusBarInfoNotificationWithActions;
import ro.amiq.dvt.ai.ui.statusbarnotifications.StatusBarWarningNotificationWithActions;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.statusbarnotifications.AbstractStatusBarNotification;
import ro.amiq.dvt.ui.statusbarnotifications.StatusBarNotificationManager;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;

public class AIUtils
extends AIUtilsCommon {
    public static final int NOTIFICATION_TIMEOUT_MS = 10000;
    private static final Object LOCK = new Object();
    private static AIUtils INSTANCE;
    static final Map<String, String> CONTENT_TYPE_ID_TO_LANGUAGE;
    static final Map<String, String> EXTENSION_TO_LANGUAGE;
    private static final String PROMPT_EXPANSION_EDITOR_TITLE_PREFIX = "DVT AI Prompt";
    private static final String MESSAGE_EXPANSION_EDITOR_TITLE_PREFIX = "DVT AI Message";
    private static final String AI_PROTECT_FILE_NOT_FOUND_ERROR_MESSAGE = "AI Assistant protect file was not found!";
    private static final ScheduledExecutorService PROGRESS_INDICATOR_SCHEDULER;
    public static final long PROGRESS_INDICATOR_TRIGGER_TIME_MILLIS = 2500L;

    static {
        CONTENT_TYPE_ID_TO_LANGUAGE = new ImmutableMap.Builder().put((Object)"org.eclipse.core.runtime.xml", (Object)"XML").put((Object)"org.eclipse.wst.xml.core.xmlsource", (Object)"XML").put((Object)"org.eclipse.jdt.core.javaSource", (Object)"Java").put((Object)"org.eclipse.cdt.core.cSource", (Object)"C").put((Object)"org.eclipse.cdt.core.cppSource", (Object)"C++").put((Object)"org.eclipse.cdt.core.cHeader", (Object)"C").put((Object)"org.eclipse.cdt.core.cppHeader", (Object)"C++").put((Object)"org.eclipse.wst.jsdt.core.jsSource", (Object)"JavaScript").put((Object)"org.eclipse.wst.html.core.htmlsource", (Object)"HTML").put((Object)"org.eclipse.wst.json.core.jsonsource", (Object)"JSON").put((Object)"org.python.pydev.core.PythonNature", (Object)"Python").build();
        EXTENSION_TO_LANGUAGE = new ImmutableMap.Builder().put((Object)".c", (Object)"C").put((Object)".cc", (Object)"C++").put((Object)".cpp", (Object)"C++").put((Object)".h", (Object)"C").put((Object)".go", (Object)"Go").put((Object)".html", (Object)"HTML").put((Object)".java", (Object)"Java").put((Object)".js", (Object)"JavaScript").put((Object)".json", (Object)"JSON").put((Object)".ngc", (Object)"Netlist File").put((Object)".pl", (Object)"Perl").put((Object)".py", (Object)"Python").put((Object)".rs", (Object)"Rust").put((Object)".sdc", (Object)"Constraint File").put((Object)".sh", (Object)"Bash Shell Script").put((Object)".csh", (Object)"Bash Shell Script").put((Object)".tcl", (Object)"Tool Command Language").put((Object)".ts", (Object)"TypeScript").put((Object)".ucf", (Object)"Constraint File").put((Object)".xdc", (Object)"Constraint File").put((Object)".xml", (Object)"XML").build();
        PROGRESS_INDICATOR_SCHEDULER = Executors.newSingleThreadScheduledExecutor();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                PROGRESS_INDICATOR_SCHEDULER.shutdown();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AIUtils getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new AIUtils();
            }
        }
        return INSTANCE;
    }

    @Override
    public IDocument getDocumentFromPath(IProject iProject, String fullPath) {
        IFile file;
        FileDocumentProvider provider;
        IDocument document;
        block5: {
            if (fullPath == null) {
                return null;
            }
            if (iProject == null) {
                return null;
            }
            document = null;
            provider = new FileDocumentProvider();
            file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(iProject, fullPath);
            if (file != null) break block5;
            return null;
        }
        try {
            FileEditorInput input = new FileEditorInput(file);
            provider.connect((Object)input);
            document = provider.getDocument((Object)input);
            provider.disconnect((Object)input);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return document;
    }

    @Override
    public IDocument getDocumentFromFile(IFile file) {
        if (file == null) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getOpenDocument(file);
        if (document != null) {
            return document;
        }
        try {
            FileDocumentProvider provider = new FileDocumentProvider();
            FileEditorInput input = new FileEditorInput(file);
            provider.connect((Object)input);
            document = provider.getDocument((Object)input);
            provider.disconnect((Object)input);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IRfNamedElementAndScope getNamedElementAndScopeAtEditorPosition(EditorPosition editorPosition) {
        IRfNamedElementAndScope iRfNamedElementAndScope;
        boolean shouldDisconnect;
        IPath path;
        LocationKind locationKind;
        ITextFileBufferManager bufferManager;
        block28: {
            block27: {
                block26: {
                    bufferManager = null;
                    locationKind = null;
                    path = null;
                    shouldDisconnect = false;
                    try {
                        IFile file = editorPosition.getFile();
                        if (file == null) {
                            return null;
                        }
                        IDocument document = DVTFileUtils.getInstance().getOpenDocument(file);
                        if (document == null) {
                            TextFileBufferInfo textFileBufferInfo;
                            bufferManager = FileBuffers.getTextFileBufferManager();
                            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = textFileBufferInfo.getLocationKind());
                            if (textFileBuffer == null) {
                                shouldDisconnect = true;
                                bufferManager.connect(path, locationKind, null);
                            }
                            textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                            document = textFileBuffer.getDocument();
                        }
                        if (document == null) {
                            if (bufferManager == null) return null;
                            if (!shouldDisconnect) return null;
                            break block26;
                        }
                        if (editorPosition.getOffset() > document.getLength()) {
                            if (bufferManager == null) return null;
                            break block27;
                        }
                        iRfNamedElementAndScope = RfMixedLangManager.getInstance().getRfElement(file, document, editorPosition.getOffset(), false);
                        if (bufferManager == null) return iRfNamedElementAndScope;
                        break block28;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                try {
                    bufferManager.disconnect(path, locationKind, null);
                    return null;
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return null;
            }
            if (!shouldDisconnect) return null;
            try {
                bufferManager.disconnect(path, locationKind, null);
                return null;
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return null;
        }
        if (!shouldDisconnect) return iRfNamedElementAndScope;
        try {
            bufferManager.disconnect(path, locationKind, null);
            return iRfNamedElementAndScope;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return iRfNamedElementAndScope;
        finally {
            if (bufferManager != null && shouldDisconnect) {
                try {
                    bufferManager.disconnect(path, locationKind, null);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
    }

    @Override
    public void writeToAiConsole(LogTarget target, String message, LogSeverity severity, String popup) {
        this.writeToAiConsoleInternal(target, message, severity, popup, null, null);
    }

    public String writeToAiConsoleWithActions(LogTarget target, String message, LogSeverity severity, String popup, List<String> actions) throws InterruptedException, ExecutionException {
        CompletableFuture buttonPressedFuture = new CompletableFuture();
        Executors.newSingleThreadScheduledExecutor().schedule(() -> {
            if (!buttonPressedFuture.isDone()) {
                buttonPressedFuture.complete("None");
            }
        }, 10000L, TimeUnit.MILLISECONDS);
        Consumer<String> notifier = buttonName -> {
            if (!buttonPressedFuture.isDone()) {
                buttonPressedFuture.complete(buttonName);
            }
        };
        this.writeToAiConsoleInternal(target, message, severity, popup, actions, notifier);
        return (String)buttonPressedFuture.get();
    }

    private void writeToAiConsoleInternal(LogTarget target, String message, LogSeverity severity, String popup, List<String> actions, Consumer<String> notifier) {
        if (severity == null || target == null) {
            return;
        }
        AIConsole targetConsole = null;
        switch (target) {
            case AI_CONSOLE: {
                targetConsole = AIConsole.MAIN;
                break;
            }
            case AI_MESSAGES_CONSOLE: {
                targetConsole = AIConsole.MESSAGES;
                break;
            }
        }
        if (targetConsole == null) {
            return;
        }
        Object notification = null;
        switch (severity) {
            case TRACE: {
                targetConsole.logTrace(message);
                if (popup == null || popup.isEmpty()) break;
                notification = new StatusBarInfoNotificationWithActions(popup, 10000, actions, notifier);
                break;
            }
            case DEBUG: {
                targetConsole.logDebug(message);
                if (popup == null || popup.isEmpty()) break;
                notification = new StatusBarInfoNotificationWithActions(popup, 10000, actions, notifier);
                break;
            }
            case INFO: {
                targetConsole.logInfo(message);
                if (popup == null || popup.isEmpty()) break;
                notification = new StatusBarInfoNotificationWithActions(popup, 10000, actions, notifier);
                break;
            }
            case WARNING: {
                targetConsole.logWarning(message);
                if (popup == null || popup.isEmpty()) break;
                notification = new StatusBarWarningNotificationWithActions(popup, 10000, actions, notifier);
                break;
            }
            case ERROR: {
                targetConsole.logError(message);
                if (popup == null || popup.isEmpty()) break;
                notification = new StatusBarErrorNotificationWithActions(popup, 10000, actions, notifier);
            }
        }
        if (notification == null) {
            return;
        }
        StatusBarNotificationManager.INSTANCE.showNotification(notification);
    }

    @Override
    public void writeDebugToAIToolsConsole(String message) {
        AIConsole.AI_TOOLS.logDebug(message);
    }

    @Override
    public void writeErrorToAIToolsConsole(String message, Throwable e) {
        AIConsole.AI_TOOLS.logError(String.valueOf(message) + "\n" + DVTUtilsCommon.INSTANCE.getStackTrace(e));
    }

    public Path resolveFilePath(String path) {
        if (path == null) {
            return null;
        }
        Path filePath = Paths.get(path, new String[0]);
        if (filePath == null) {
            return null;
        }
        if (!filePath.isAbsolute()) {
            Path projectPath = Utils.getActiveProjectPath();
            if (projectPath == null) {
                return null;
            }
            filePath = projectPath.resolve(filePath);
        }
        return filePath;
    }

    @Override
    public IProject getSelectedProject() {
        return DVTFileUtils.getInstance().getSelectedProject();
    }

    @Override
    public HistoryItem getVHTop(IProject iProject) {
        IVHViewContributor viewContributor;
        if (iProject == null) {
            return null;
        }
        LanguageKind languageKind = LanguageKind.E;
        if (RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.VLOG.NATURE_ID, false) != null) {
            languageKind = LanguageKind.VLOG;
        }
        if ((viewContributor = VHViewUtils.getViewContributor((LanguageKind)languageKind)) == null) {
            return null;
        }
        String verificationTopText = BuildConfigManager.getVerificationHierarchyTop((IProject)iProject);
        if (verificationTopText == null) {
            return null;
        }
        return viewContributor.parseHistoryItem(iProject.getName(), verificationTopText);
    }

    public String getMd5Hash(String content) {
        block4: {
            if (content != null) break block4;
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(content.getBytes());
            byte[] digest = md.digest();
            StringBuilder hexString = new StringBuilder();
            byte[] byArray = digest;
            int n = digest.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                hexString.append(String.format("%02x", b));
                ++n2;
            }
            return hexString.toString().substring(hexString.length() - 6);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public void openProtectFile(int line) {
        Path projectPath = Utils.getActiveProjectPath();
        if (projectPath == null) {
            this.writeToAiConsole(LogTarget.AI_CONSOLE, AI_PROTECT_FILE_NOT_FOUND_ERROR_MESSAGE, LogSeverity.ERROR, AI_PROTECT_FILE_NOT_FOUND_ERROR_MESSAGE);
            return;
        }
        Path protectFilePath = Paths.get(projectPath.toString(), AI_PROTECT_FILE_PATH);
        if (protectFilePath == null) {
            this.writeToAiConsole(LogTarget.AI_CONSOLE, AI_PROTECT_FILE_NOT_FOUND_ERROR_MESSAGE, LogSeverity.ERROR, AI_PROTECT_FILE_NOT_FOUND_ERROR_MESSAGE);
            return;
        }
        File protectFile = protectFilePath.toFile();
        if (protectFile == null || !protectFile.isFile()) {
            this.writeToAiConsole(LogTarget.AI_CONSOLE, AI_PROTECT_FILE_NOT_FOUND_ERROR_MESSAGE, LogSeverity.ERROR, AI_PROTECT_FILE_NOT_FOUND_ERROR_MESSAGE);
            return;
        }
        if (line > 0) {
            DVTFileUtils.getInstance().openEditor(protectFile, line);
        } else {
            DVTFileUtils.getInstance().openFile(protectFile);
        }
    }

    @Override
    protected int getTabSizeForFilePath(String filePath) {
        int preferenceValue = DVTPlugin.getDefault().getCombinedPreferenceStore().getInt("tabWidth");
        return preferenceValue > 0 ? preferenceValue : 4;
    }

    @Override
    protected int getTabSizeFromPreferences() {
        return this.getTabSizeForFilePath(null);
    }

    @Override
    protected String getNatureForFilePath(String filePath, IProject iProject) {
        IFile iFile = DVTFileUtils.getInstance().findProjectFile(iProject, filePath);
        if (iFile == null) {
            return null;
        }
        String editorID = DVTFileUtils.getInstance().getEditorIDForFile(iFile);
        if (editorID == null) {
            return null;
        }
        LanguageKind languageKind = LanguageKind.fromEditorID((String)editorID);
        if (languageKind == null) {
            return null;
        }
        return languageKind.NATURE_ID;
    }

    @Override
    public void showInvalidEnvironmentVariablesWarning(String warningMessage, int protectFileLine) {
        if (protectFileLine < 0) {
            this.writeToAiConsole(LogTarget.AI_CONSOLE, warningMessage, LogSeverity.WARNING, warningMessage);
            return;
        }
        AIConsole.MAIN.logWarning(warningMessage);
        AIInvalidEnvVarsInProtectFileWarningNotification notification = new AIInvalidEnvVarsInProtectFileWarningNotification(warningMessage, 10000, protectFileLine);
        StatusBarNotificationManager.INSTANCE.showNotification((AbstractStatusBarNotification)notification);
    }

    public String getSingleLineCommentForLanguageId(LangId langId) {
        return this.getSingleLineCommentForLanguageKind(Enum.valueOf(LanguageKind.class, langId.name()));
    }

    void createFolderRecursively(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder && !parent.exists()) {
            this.createFolderRecursively((IFolder)parent);
        }
        folder.create(true, true, null);
    }

    public String getPromptInsertionFromFilePath(IProject iProject, String fullPath) {
        if (this.isOnlyCompiledFileWithName(iProject, fullPath)) {
            return Paths.get(fullPath, new String[0]).toFile().getName();
        }
        Path activeProjectPath = Utils.getActiveProjectPath();
        if (activeProjectPath == null) {
            return fullPath;
        }
        if (Paths.get(fullPath, new String[0]).startsWith(activeProjectPath)) {
            return fullPath.substring(activeProjectPath.toString().length() + 1);
        }
        return fullPath;
    }

    private boolean isOnlyCompiledFileWithName(IProject iProject, String fullPath) {
        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(iProject, false);
        if (rfMixedLangProject == null) {
            return false;
        }
        Collection singleLangProjects = rfMixedLangProject.getSingleLangProjects();
        if (singleLangProjects == null) {
            return false;
        }
        String fileName = Paths.get(fullPath, new String[0]).toFile().getName();
        if (fileName == null) {
            return false;
        }
        boolean isCompiled = false;
        int numberOfCompiledFilesWithName = 0;
        for (IRfSingleLangProject project : singleLangProjects) {
            Set compiledFilesSet = project.getCompiledFilesSet();
            if (compiledFilesSet == null) continue;
            for (ParserPath pPath : compiledFilesSet) {
                if (!fileName.equals(Paths.get(pPath.path, new String[0]).toFile().getName())) continue;
                ++numberOfCompiledFilesWithName;
                if (!pPath.path.equals(fullPath)) continue;
                isCompiled = true;
            }
        }
        return isCompiled && numberOfCompiledFilesWithName == 1;
    }

    public boolean isPromptExpansionEditor(IEditorPart activeEditor) {
        if (!(activeEditor instanceof ITextEditor)) {
            return false;
        }
        String editorTitle = activeEditor.getTitle();
        return editorTitle != null && (editorTitle.startsWith(PROMPT_EXPANSION_EDITOR_TITLE_PREFIX) || editorTitle.startsWith(MESSAGE_EXPANSION_EDITOR_TITLE_PREFIX));
    }

    public String sanitizeSymbolName(String symbolName) {
        if (!symbolName.contains(" ")) {
            return symbolName;
        }
        return "'" + symbolName.replace("'", "\\'") + "'";
    }

    public ITextSelection getTextSelectionFromActiveEditor(IEditorPart activeEditor) {
        if (activeEditor instanceof ITextEditor) {
            ISelection[] selection = new ISelection[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                iSelectionArray[0] = ((ITextEditor)activeEditor).getSelectionProvider().getSelection();
            });
            return selection[0] instanceof ITextSelection ? (ITextSelection)selection[0] : null;
        }
        ISelection lastSelection = DVTPlugin.getSelectionManager().getLastSelection();
        return lastSelection instanceof ITextSelection ? (ITextSelection)lastSelection : null;
    }

    public String getEditorContentWithCursorPosition(IEditorPart activeEditor, ITextSelection textSelection) {
        if (!(activeEditor instanceof ITextEditor) || textSelection == null) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getDocument((ITextEditor)activeEditor);
        if (document == null) {
            return null;
        }
        String editorContent = document.get();
        if (editorContent == null || editorContent.isEmpty()) {
            return null;
        }
        LanguageKind languageKind = null;
        if (activeEditor instanceof DVTEditor) {
            languageKind = ((DVTEditor)activeEditor).getLanguageKind();
        }
        String comment = String.valueOf(this.getSingleLineCommentForLanguageKind(languageKind)) + " " + "[[CURSOR IS HERE]]";
        String textBefore = "";
        String textAfter = "";
        try {
            int cursorLine = document.getLineOfOffset(textSelection.getOffset());
            if (cursorLine < document.getNumberOfLines() - 1) {
                IRegion cursorLineInfo = document.getLineInformationOfOffset(textSelection.getOffset());
                textBefore = document.get(0, cursorLineInfo.getOffset() + cursorLineInfo.getLength());
                int offsetAfter = document.getLineOffset(cursorLine + 1);
                textAfter = document.get(offsetAfter, document.getLength() - offsetAfter);
            } else {
                textBefore = editorContent;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return String.valueOf(textBefore) + " " + comment + (textAfter.isEmpty() ? "" : "\n" + textAfter);
    }

    public String addCursorIndicatorToSelection(String selection, IEditorPart activeEditor) {
        if (selection == null || selection.isEmpty()) {
            return selection;
        }
        LanguageKind languageKind = null;
        if (activeEditor instanceof DVTEditor) {
            languageKind = ((DVTEditor)activeEditor).getLanguageKind();
        }
        String comment = String.valueOf(this.getSingleLineCommentForLanguageKind(languageKind)) + " " + "[[CURSOR IS HERE]]";
        if (selection.endsWith("\n")) {
            selection = selection.substring(0, selection.length() - 1);
        }
        return String.valueOf(selection) + " " + comment;
    }

    @Override
    public DVTEditor getActiveDVTEditor() {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        return activeEditor instanceof DVTEditor ? (DVTEditor)activeEditor : null;
    }

    @Override
    public void checkSnippetSolvingCancellation(BooleanSupplier isCanceled, String snippetName) {
        if (isCanceled == null) {
            return;
        }
        if (isCanceled.getAsBoolean()) {
            String message = String.format(AIExceptionKind.REQUEST_CANCELED.MESSAGE, "Solve snippet '@" + snippetName + "'");
            AIConsole.MAIN.logInfo(message);
            throw new AIRequestCancellationException(new AIExceptionData(AIExceptionKind.REQUEST_CANCELED.KIND, message, 2));
        }
    }

    @Override
    public void checkSymbolSolvingCancellation(BooleanSupplier isCanceled, String query) {
        if (isCanceled == null) {
            return;
        }
        if (isCanceled.getAsBoolean()) {
            String message = String.format(AIExceptionKind.REQUEST_CANCELED.MESSAGE, "Solve symbol '#" + query + "'");
            AIConsole.MAIN.logInfo(message);
            throw new AIRequestCancellationException(new AIExceptionData(AIExceptionKind.REQUEST_CANCELED.KIND, message, 2));
        }
    }

    @Override
    public List<Problem> getProblemsForFile(String filePath, IProject project, boolean includeWarnings) {
        IDocument document = this.getDocumentFromPath(project, filePath);
        IFile file = DVTFileUtils.getInstance().findProjectFile(project, filePath);
        if (file == null || document == null) {
            return null;
        }
        return AISnippetSolver.getInstance().getProblemsForFileRange(file, filePath, 0, document.getLength(), true, includeWarnings, Integer.MAX_VALUE, document, null);
    }

    public String getActiveEditorFullPath() {
        return this.getActiveEditorPath(false);
    }

    public String getActiveEditorRelativePath() {
        return this.getActiveEditorPath(true);
    }

    private String getActiveEditorPath(boolean relative) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        IEditorInput editorInput = activeEditor.getEditorInput();
        if (!(editorInput instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)editorInput).getFile();
        if (file == null) {
            return null;
        }
        IPath location = relative ? file.getProjectRelativePath() : file.getLocation();
        return location != null ? location.toOSString() : null;
    }

    public ProblemInfo getProblemInfoFromMarker(IMarker marker, String filePath) {
        if (filePath == null) {
            return null;
        }
        if (marker == null) {
            return null;
        }
        IResource resource = marker.getResource();
        if (resource == null) {
            return null;
        }
        IProject iProject = resource.getProject();
        String message = marker.getAttribute("message", null);
        if (message == null) {
            return null;
        }
        ProblemInfo result = new ProblemInfo(message, AIPathUtils.INSTANCE.makePathRelativeToProject(filePath, iProject), -1, -1, null, this.markerSeverityToText(marker));
        IDocument document = this.getDocumentFromPath(iProject, filePath);
        if (document == null) {
            return result;
        }
        int problemStartOffset = marker.getAttribute("charStart", -1);
        int problemEndOffset = marker.getAttribute("charEnd", -1);
        if (problemStartOffset < 0 || problemEndOffset < 0) {
            int line = marker.getAttribute("lineNumber", 1);
            try {
                problemStartOffset = document.getLineOffset(line - 1);
                problemEndOffset = problemStartOffset + document.getLineLength(line - 1);
            }
            catch (BadLocationException badLocationException) {}
        }
        if (problemStartOffset < 0 || problemEndOffset < 0) {
            return result;
        }
        try {
            result.setStartLine(document.getLineOfOffset(problemStartOffset) + 1);
            result.setEndLine(document.getLineOfOffset(Math.max(0, problemEndOffset - 1)) + 1);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return result;
        }
        IFile iFile = DVTFileUtils.getInstance().findProjectFile(iProject, filePath);
        if (iFile == null) {
            return result;
        }
        CodeSnippet codeSnippet = AIExpansionUtils.INSTANCE.increaseEditorRange(new EditorRange(iFile, problemStartOffset, problemEndOffset), 3, false);
        if (codeSnippet != null) {
            result.setSurroundingCode(codeSnippet.getCode());
        }
        return result;
    }

    public OVMComplianceCheckHit getVerissimoCheckHitFromMarker(IMarker marker) {
        OVMComplianceCheckHit hitFromMarker;
        if (marker == null) {
            return null;
        }
        try {
            hitFromMarker = (OVMComplianceCheckHit)marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
            if (hitFromMarker == null) {
                return null;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return hitFromMarker;
    }

    public VerissimoFailureInfo getVerissimoHitInfoFromCheckHit(OVMComplianceCheckHit hit) {
        if (hit == null) {
            return null;
        }
        VerissimoFailureInfo hitInfo = new VerissimoFailureInfo();
        OVMComplianceCheck ovmComplianceCheck = hit.getCheck();
        if (ovmComplianceCheck == null) {
            return null;
        }
        IProject iProject = ovmComplianceCheck.getIProject();
        if (iProject == null) {
            return null;
        }
        String filePath = hit.getParserPath().getCanonicalPath();
        hitInfo.setFilePath(AIPathUtils.INSTANCE.makePathRelativeToProject(filePath, iProject));
        hitInfo.setSeverity(hit.getSeverity().name().toLowerCase());
        hitInfo.setStartLine(hit.getLine() + 1);
        hitInfo.setEndLine(hit.getLine() + 1);
        IFile iFile = DVTFileUtils.getInstance().findProjectFile(iProject, filePath);
        if (iFile == null) {
            return hitInfo;
        }
        IDocument document = AIUtils.getInstance().getDocumentFromFile(iFile);
        if (document == null) {
            return hitInfo;
        }
        try {
            int startOffset = document.getLineOffset(hit.getLine());
            int endOffset = startOffset + document.getLineLength(hitInfo.getEndLine()) - 1;
            CodeSnippet codeSnippet = AIExpansionUtils.INSTANCE.increaseEditorRange(new EditorRange(iFile, startOffset, endOffset), 3, false);
            if (codeSnippet != null) {
                hitInfo.setSurroundingCode(codeSnippet.getCode());
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return hitInfo;
        }
        hitInfo.setMessage(hit.getDetails());
        return hitInfo;
    }

    private String markerSeverityToText(IMarker marker) {
        int severity = 0;
        try {
            severity = (Integer)marker.getAttribute("severity");
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        switch (severity) {
            case 1: {
                return "warning";
            }
            case 2: {
                return "error";
            }
        }
        return "problem";
    }

    public void showProtectedFileAccessNotification(String fileName, int protectFileLine) {
        String errorMessage = String.format(AIExceptionKind.PROTECTED_FILE_ACCESS.MESSAGE, fileName);
        AIConsole.MAIN.logError(errorMessage);
        AIProtectedFileAccessErrorNotification notification = new AIProtectedFileAccessErrorNotification(errorMessage, 10000, protectFileLine);
        StatusBarNotificationManager.INSTANCE.showNotification((AbstractStatusBarNotification)notification);
    }

    public <T> CompletableFuture<T> runTaskWithProgress(Supplier<CompletableFuture<T>> taskSupplier, String message, long progressTriggerTimeMillis) {
        CompletableFuture result = new CompletableFuture();
        boolean[] taskFinished = new boolean[1];
        CompletableFuture task = taskSupplier.get();
        PROGRESS_INDICATOR_SCHEDULER.schedule(() -> {
            if (!taskFinished[0]) {
                AIProgressIndicatorManager.INSTANCE.startProgressIndicator(message);
                if (!task.isDone()) {
                    task.cancel(true);
                }
            }
        }, progressTriggerTimeMillis, TimeUnit.MILLISECONDS);
        try {
            task.whenComplete((taskResult, ex) -> {
                blArray[0] = true;
                AIProgressIndicatorManager.INSTANCE.stopProgressIndicator();
                if (ex != null) {
                    result.completeExceptionally((Throwable)ex);
                } else {
                    result.complete(taskResult);
                }
            });
        }
        catch (Exception ex2) {
            taskFinished[0] = true;
            AIProgressIndicatorManager.INSTANCE.stopProgressIndicator();
            result.completeExceptionally(ex2);
        }
        return result;
    }

    public String getDVTUserDir() {
        String dvtUserDir = System.getenv("DVT_USER_DIR");
        if (dvtUserDir == null) {
            String home = System.getenv("HOME");
            if (home == null) {
                return null;
            }
            dvtUserDir = String.valueOf(home) + File.separator + ".dvt";
        }
        return dvtUserDir;
    }
}

