/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.contributor.AILangContributorManager;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.EditorRange;
import ro.amiq.dvt.ai.model.LogSeverity;
import ro.amiq.dvt.ai.model.LogTarget;
import ro.amiq.dvt.ai.model.Problem;
import ro.amiq.dvt.ai.model.TreeElement;
import ro.amiq.dvt.ai.model.VerissimoCheckInfo;
import ro.amiq.dvt.ai.model.VerissimoFailureAdditionalInformation;
import ro.amiq.dvt.ai.model.VerissimoParameterInfo;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIProtectException;
import ro.amiq.dvt.ai.model.exceptions.AIProtectExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIUnexpectedBinaryFileException;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;

public abstract class AIUtilsCommon {
    private static final String RAND_MODIFIER = "rand ";
    private static final String RANDC_MODIFIER = "randc ";
    private static final String FIELD = "field ";
    private static final String ENUM_KEYWORD = "enum";
    private static final String STRUCT_KEYWORD = "struct";
    private static final String UNION_KEYWORD = "union";
    private static final String PACKED_KEYWORD = "packed";
    private static final String TYPE_KEYWORD = "type";
    private static final int BINARY_FILE_CHECK_SAMPLING_SIZE_BYTES = 10000;
    private static final double BINARY_FILE_NON_TEXT_FILE_CHARACTERS_PERCENTAGE_THRESHOLD = 1.0;
    private static final Pattern MODIFIERS_PATTERN = Pattern.compile("\\[\\D+\\]");
    private static final Pattern FILE_LINE_RANGE_PATTERN = Pattern.compile(":\\d+-\\d+$");
    protected static final int DEFAULT_TAB_SIZE = 4;
    protected static final String CURSOR_POSITION_INDICATOR = "[[CURSOR IS HERE]]";
    public static final String AI_PROTECT_FILE_PATH = Paths.get(".dvt", "ai", "protect").toString();
    public static final String EDIT_PROTECT_FILE_BUTTON_TEXT = "Edit";

    public IRfDefElement getNamedElementContainer(IRfNamedElementAndScope namedElementAndScope, Set<Class<?>> acceptedContainers) {
        IRfDefElement container = this.getNamedElementContainer(namedElementAndScope, acceptedContainers, false);
        if (container == null) {
            return null;
        }
        IRfNamedElement namedElement = container.getNamedElement();
        if (!(namedElement instanceof IRfTypeAliasElement)) {
            return container;
        }
        if ((namedElement = ((IRfTypeAliasElement)namedElement).getTranslatedType()) == null || namedElement.getDeclaration() == null) {
            return container;
        }
        return namedElement.getDeclaration();
    }

    public IRfDefElement getNamedElementContainer(IRfNamedElementAndScope namedElementAndScope, Set<Class<?>> acceptedContainers, boolean considerElementUnderCursor) {
        if (namedElementAndScope == null || acceptedContainers == null || acceptedContainers.isEmpty()) {
            return null;
        }
        IRfDefElement potentialResult = null;
        IRfNamedElement namedElement = namedElementAndScope.getIRfNamedElement();
        if (namedElement instanceof IRfTypeAliasElement) {
            namedElement = ((IRfTypeAliasElement)namedElement).getTranslatedType();
        }
        if (considerElementUnderCursor) {
            potentialResult = this.getImplementationOrDeclaration(namedElement);
            if (this.isAcceptedContainerType(namedElement, acceptedContainers, true)) {
                return potentialResult;
            }
        }
        if (this.isAcceptedContainerType(namedElement, acceptedContainers, false) && acceptedContainers.contains(IRfEnumElement.class) && acceptedContainers.size() == 1) {
            return this.getImplementationOrDeclaration(namedElement);
        }
        IRfScopeElement scope = namedElementAndScope.getScope();
        while (scope != null) {
            if (scope instanceof IRfNamedElement && this.isAcceptedContainerType(scope, acceptedContainers, false)) {
                return this.getImplementationOrDeclaration((IRfNamedElement)scope);
            }
            if (scope instanceof IRfDefElement) {
                if (this.isAcceptedContainerType(scope, acceptedContainers, false)) {
                    return (IRfDefElement)scope;
                }
                if (this.isAcceptedContainerType(((IRfDefElement)scope).getNamedElement(), acceptedContainers, false)) {
                    return this.getImplementationOrDeclaration(((IRfDefElement)scope).getNamedElement());
                }
            }
            scope = scope.getEnclosingScope();
        }
        return potentialResult;
    }

    public String getDefElementKind(IRfDefElement defElement) {
        if (defElement == null) {
            return null;
        }
        LanguageKind languageKind = defElement.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return null;
        }
        IRfKind defElementKind = aiContributor.getDefElementKind(defElement);
        if (defElementKind == null) {
            return null;
        }
        return defElementKind.getName();
    }

    public IRfDefElement getImplementationOrDeclaration(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return null;
        }
        Object implementation = namedElement.getImplementation();
        if (implementation instanceof IRfDefElement) {
            return (IRfDefElement)implementation;
        }
        return namedElement.getDeclaration();
    }

    private boolean isAcceptedContainerType(Object element, Set<Class<?>> acceptedContainerTypes, boolean acceptRfInstances) {
        for (Class<?> clazz : acceptedContainerTypes) {
            if (!clazz.isInstance(element) || element instanceof IRfInstanceElement && !acceptRfInstances) continue;
            return true;
        }
        return false;
    }

    public String getFilePathFromNamedElement(IRfNamedElement namedElement, boolean makeRelativeToProject) {
        if (namedElement == null) {
            return null;
        }
        return this.getFilePathFromDefElement(namedElement.getDeclaration(), makeRelativeToProject);
    }

    public String getFilePathFromDefElement(IRfDefElement defElement, boolean makeRelativeToProject) {
        if (defElement == null) {
            return null;
        }
        ParserPath parserPath = defElement.getParserPath();
        if (parserPath == null) {
            return null;
        }
        IRfSingleLangProject rfProject = defElement.getRfProject();
        if (rfProject == null) {
            return null;
        }
        return makeRelativeToProject ? AIPathUtils.INSTANCE.makePathRelativeToProject(parserPath.path, rfProject.getProject()) : parserPath.path;
    }

    public String getDefElementSignature(IRfDefElement defElement) {
        if (defElement == null) {
            return "";
        }
        IRfNamedElement namedElement = defElement.getNamedElement();
        if (namedElement instanceof IRfActionBlockElement) {
            return null;
        }
        if (namedElement instanceof IRfTypeAliasElement) {
            namedElement = ((IRfTypeAliasElement)namedElement).getTranslatedType();
        }
        if (namedElement instanceof IRfCompositeTypeElement) {
            return this.getCompositeTypeElementSignature(namedElement);
        }
        if (namedElement != null) {
            String signature = namedElement.getSignature();
            if (namedElement instanceof IRfFieldElement && signature != null && signature.startsWith(FIELD) && (namedElement.isRand() || namedElement.isRandc())) {
                String extraModifier = namedElement.isRand() ? RAND_MODIFIER : RANDC_MODIFIER;
                signature = FIELD + extraModifier + signature.substring(FIELD.length());
            }
            if (signature != null) {
                String[] parts = signature.split("\n");
                StringBuilder result = new StringBuilder();
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (!MODIFIERS_PATTERN.matcher(part).matches()) {
                        result.append(part);
                    }
                    ++n2;
                }
                return result.toString();
            }
        }
        return this.getElementName(namedElement);
    }

    private String getCompositeTypeElementSignature(Object element) {
        if (element == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        IRfCompositeTypeElement compositeType = (IRfCompositeTypeElement)element;
        if (compositeType.isStruct() && !(compositeType instanceof IRfVhdlTypeElement)) {
            result.append(STRUCT_KEYWORD).append(' ');
        } else if (compositeType.isUnion()) {
            result.append(UNION_KEYWORD).append(' ');
        } else if (compositeType.isEnum()) {
            result.append(ENUM_KEYWORD).append(' ');
        } else if (element instanceof IRfTypeElement) {
            result.append(TYPE_KEYWORD).append(' ');
        }
        if (compositeType.isPacked()) {
            result.append(PACKED_KEYWORD).append(' ');
        }
        String elementName = ((IRfNamedElement)element).getName();
        String aliasName = ((IRfCompositeTypeElement)element).getAliasName();
        if (aliasName != null) {
            elementName = aliasName;
        }
        result.append(elementName);
        return result.toString();
    }

    public List<String> getSegmentsFromElementPath(ElementPath elementPath) {
        if (elementPath == null) {
            return null;
        }
        String[] segments = elementPath.getSegments();
        if (segments == null || segments.length == 0) {
            return null;
        }
        return Arrays.asList(segments);
    }

    public String computeInvalidEnvVarsWarningMessage(List<String> envVars, boolean inProtectFile) {
        StringBuilder result = new StringBuilder();
        List envVarsInQuotes = envVars.stream().map(envVar -> "'" + envVar + "'").collect(Collectors.toList());
        result.append("Can not resolve environment ");
        result.append(envVars.size() == 1 ? "variable " : "variables ");
        int i = 0;
        while (i < envVars.size() - 1) {
            result.append(String.valueOf((String)envVarsInQuotes.get(i)) + ", ");
            ++i;
        }
        result.append((String)envVarsInQuotes.get(envVars.size() - 1));
        if (inProtectFile) {
            result.append(" in AI Assistant protect file!");
        } else {
            result.append("!");
        }
        return result.toString();
    }

    protected LineRange extractLineRangeFromFileQuery(StringBuilder query) {
        try {
            Matcher matcher = FILE_LINE_RANGE_PATTERN.matcher(query);
            if (!matcher.find()) {
                return LineRange.getDefault();
            }
            String fileRangeString = matcher.group().substring(1);
            String[] lineNumbers = fileRangeString.split("-");
            if (lineNumbers == null || lineNumbers.length != 2) {
                return LineRange.getDefault();
            }
            int startLine = Integer.parseInt(lineNumbers[0]);
            if (startLine <= 0) {
                return LineRange.getDefault();
            }
            int endLine = Integer.parseInt(lineNumbers[1]);
            if (endLine < startLine) {
                return LineRange.getDefault();
            }
            query.replace(query.lastIndexOf(":"), query.length(), "");
            return new LineRange(startLine, endLine);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return LineRange.getDefault();
        }
    }

    public void onDidAccessProtectedFile(String fullPath, int protectFileLine) {
        String fileName = Paths.get(fullPath, new String[0]).getFileName().toString();
        String errorMessage = String.format(AIExceptionKind.PROTECTED_FILE_ACCESS.MESSAGE, fileName);
        throw new AIProtectException(new AIProtectExceptionData(AIExceptionKind.PROTECTED_FILE_ACCESS.KIND, errorMessage, 0, protectFileLine));
    }

    public void onDidExpandBinaryFile(String fullPath) {
        String fileName = Paths.get(fullPath, new String[0]).getFileName().toString();
        String errorMessage = String.format(AIExceptionKind.UNEXPECTED_BINARY_FILE.MESSAGE, fileName);
        throw new AIUnexpectedBinaryFileException(new AIExceptionData(AIExceptionKind.UNEXPECTED_BINARY_FILE.KIND, errorMessage, 0));
    }

    public int getNamedElementDistanceToCursor(IRfNamedElement namedElement, EditorPosition cursorPosition) {
        if (namedElement == null || cursorPosition == null) {
            return Integer.MAX_VALUE;
        }
        IRfDefElement defElement = namedElement.getDeclaration();
        if (defElement == null) {
            return Integer.MAX_VALUE;
        }
        ParserPath parserPath = defElement.getParserPath();
        if (parserPath == null || parserPath.path == null) {
            return Integer.MAX_VALUE;
        }
        String cursorPositionPath = cursorPosition.getFullPath();
        if (!parserPath.path.equals(cursorPositionPath)) {
            return Integer.MAX_VALUE;
        }
        int cursorOffset = cursorPosition.getOffset();
        int elementOffset = defElement.getStartOffset();
        return Math.abs(cursorOffset - elementOffset);
    }

    public void addAssociatedTypeAsDependency(IRfAssociatedTypeElement associatedTypeElement, IRfNamedElement initialElement, Map<IRfDefElement, Integer> dependencyToDistance, int distance) {
        IRfNamedElement associatedType = associatedTypeElement.getAssociatedType();
        if (associatedType instanceof IRfTypeAliasElement) {
            associatedType = ((IRfTypeAliasElement)associatedType).getTranslatedType();
        }
        if (associatedType == null || associatedType.checkEquals((Object)initialElement) || associatedType.isPredefined()) {
            return;
        }
        if (associatedType instanceof IRfListType) {
            this.addAssociatedTypeAsDependency((IRfAssociatedTypeElement)((IRfListType)associatedType), initialElement, dependencyToDistance, distance);
            return;
        }
        IRfDefElement associatedTypeDeclaration = associatedType.getDeclaration();
        if (associatedTypeDeclaration == null) {
            return;
        }
        int prevDistance = dependencyToDistance.getOrDefault(associatedTypeDeclaration, Integer.MAX_VALUE);
        int newDistance = Integer.min(distance, prevDistance);
        dependencyToDistance.put(associatedTypeDeclaration, newDistance);
    }

    public int getCharCountOfTree(TreeElement root) {
        return Math.max(0, this.getCharCountOfTree(root, 0) - 1);
    }

    private int getCharCountOfTree(TreeElement root, int level) {
        String element;
        if (root == null) {
            return 0;
        }
        int charCount = 0;
        List<TreeElement> children = root.getChildren();
        if (children != null) {
            for (TreeElement child : children) {
                charCount += this.getCharCountOfTree(child, level + 1);
            }
        }
        if ((element = root.getElement()) != null) {
            charCount += element.length() + level + 1;
        }
        return charCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFileBinary(File file) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                boolean bl;
                byte[] buf = new byte[10000];
                int numBytesRead = ((InputStream)inputStream).read(buf);
                if (numBytesRead <= 0) {
                    return false;
                }
                if (numBytesRead < buf.length) {
                    buf = Arrays.copyOf(buf, numBytesRead);
                }
                String s = new String(buf);
                int totalChars = s.length();
                int nonTextFileChars = 0;
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        double nonTextFileCharactesPercentage = (double)nonTextFileChars / (double)totalChars * 100.0;
                        if (!(nonTextFileCharactesPercentage > 1.0)) break;
                        bl = true;
                        return bl;
                    }
                    char ch = cArray[n2];
                    if (DVTStringUtil.isNotTextFileCharacter((char)ch)) {
                        ++nonTextFileChars;
                    }
                    ++n2;
                }
                bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getElementName(Object element) {
        String aliasName;
        if (!(element instanceof IRfNamedElement) && !(element instanceof IRfDefElement)) {
            return null;
        }
        IRfNamedElement namedElement = null;
        if (element instanceof IRfNamedElement) {
            namedElement = (IRfNamedElement)element;
        }
        if (element instanceof IRfDefElement) {
            namedElement = ((IRfDefElement)element).getNamedElement();
        }
        if (namedElement == null) {
            return null;
        }
        String elementName = namedElement.getName();
        if (namedElement instanceof IRfCompositeTypeElement && (aliasName = ((IRfCompositeTypeElement)namedElement).getAliasName()) != null) {
            elementName = aliasName;
        }
        return elementName;
    }

    public List<IRfDefElement> getContainersInFile(String fullPath, IProject iProject, boolean allowExternFunctions) {
        String fileNature = this.getNatureForFilePath(fullPath, iProject);
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(LanguageKind.from((String)fileNature));
        if (aiContributor == null) {
            return null;
        }
        List<IRfDefElement> containers = aiContributor.getContainersInFile(fullPath, iProject, allowExternFunctions);
        if (containers == null) {
            return null;
        }
        return containers.stream().sorted((ch1, ch2) -> ch1.getStartOffset() - ch2.getStartOffset()).collect(Collectors.toList());
    }

    public EditorPosition getEditorPositionFromDefElement(IRfDefElement defElement) {
        if (defElement == null) {
            return null;
        }
        ParserPath parserPath = defElement.getParserPath();
        if (parserPath == null || parserPath.path == null) {
            return null;
        }
        IRfSingleLangProject rfProject = defElement.getRfProject();
        if (rfProject == null) {
            return null;
        }
        IFile iFile = DVTFileUtils.getInstance().findProjectFile(rfProject.getProject(), parserPath.path);
        if (iFile == null) {
            return null;
        }
        return new EditorPosition(iFile, defElement.getStartOffset());
    }

    public EditorRange getEditorRangeFromDefElement(IRfDefElement defElement) {
        if (defElement == null) {
            return null;
        }
        ParserPath parserPath = defElement.getParserPath();
        if (parserPath == null || parserPath.path == null) {
            return null;
        }
        IRfSingleLangProject rfProject = defElement.getRfProject();
        if (rfProject == null) {
            return null;
        }
        IFile iFile = DVTFileUtils.getInstance().findProjectFile(rfProject.getProject(), parserPath.path);
        if (iFile == null) {
            return null;
        }
        return new EditorRange(iFile, defElement.getStartOffset(), defElement.getEndOffset());
    }

    protected String getFilePathForSymbol(ISymbolCollectorPrerequisite symbolPrerequisite) {
        if (symbolPrerequisite == null) {
            return null;
        }
        if (symbolPrerequisite instanceof IRfNamedElement && symbolPrerequisite instanceof IMacroInfo) {
            ParserPath parserPath = ((IRfNamedElement)symbolPrerequisite).getMacroParserPath();
            if (parserPath == null) {
                return null;
            }
            return parserPath.toString();
        }
        if (!(symbolPrerequisite instanceof IDVTElementWrapper)) {
            return null;
        }
        Object rfElement = ((IDVTElementWrapper)symbolPrerequisite).getRfElement();
        if (rfElement instanceof IDVTFileInstance || rfElement instanceof IRfFileDef) {
            ParserPath parserPath;
            ParserPath parserPath2 = parserPath = rfElement instanceof IDVTFileInstance ? ((IDVTFileInstance)rfElement).getParserPath() : ((IRfFileDef)rfElement).getParserPath();
            if (parserPath == null) {
                return null;
            }
            return parserPath.toString();
        }
        if (rfElement instanceof IRfNamedElement) {
            return this.getFilePathFromNamedElement((IRfNamedElement)rfElement, false);
        }
        return null;
    }

    public String getSingleLineCommentForLanguageKind(LanguageKind kind) {
        if (kind == null) {
            return "//";
        }
        switch (kind) {
            case E: 
            case PSS: 
            case VLOG: 
            case CPP: 
            case CPP_EXT: 
            case BC: {
                return "//";
            }
            case VHDL: {
                return "--";
            }
            case TCL: 
            case PF: {
                return "#";
            }
        }
        return "//";
    }

    public void addCursorPositionIndicatorToCodeSnippet(CodeSnippet codeSnippet, DVTEditor editor, EditorPosition cursorPosition) {
        String[] lines;
        if (codeSnippet == null || editor == null || cursorPosition == null) {
            return;
        }
        String code = codeSnippet.getCode();
        if (code == null || code.isEmpty() || codeSnippet.getFilePath() == null || codeSnippet.getStartLine() < 0) {
            return;
        }
        IDocument document = editor.getDocument();
        if (document == null) {
            return;
        }
        int cursorLineInFile = -1;
        try {
            cursorLineInFile = document.getLineOfOffset(cursorPosition.getOffset()) + 1;
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        if (cursorLineInFile < codeSnippet.getStartLine() || cursorLineInFile > codeSnippet.getEndLine()) {
            return;
        }
        int cursorLineInCodeSnippet = cursorLineInFile - codeSnippet.getStartLine();
        if (cursorLineInCodeSnippet >= (lines = code.split("\n")).length) {
            return;
        }
        String comment = String.valueOf(this.getSingleLineCommentForLanguageKind(editor.getLanguageKind())) + " " + CURSOR_POSITION_INDICATOR;
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            result.append(i != cursorLineInCodeSnippet ? lines[i] : String.valueOf(lines[i]) + " " + comment).append('\n');
            ++i;
        }
        codeSnippet.setCodeNoCRRemoval(result.toString());
    }

    public List<IRfDefElement> removeDuplicateDefElements(List<IRfDefElement> defElements, boolean uniqueNamedElements) {
        if (defElements == null || defElements.isEmpty()) {
            return defElements;
        }
        LinkedHashMap<IRfDefElement, IRfNamedElement> defElementToNamedElement = new LinkedHashMap<IRfDefElement, IRfNamedElement>();
        ArrayList<IRfDefElement> eLangElements = new ArrayList<IRfDefElement>();
        for (IRfDefElement defElement : defElements) {
            IRfNamedElement namedElement = defElement.getNamedElement();
            if (!uniqueNamedElements) {
                defElementToNamedElement.put(defElement, namedElement);
                continue;
            }
            if (defElement.getLanguageKind() == LanguageKind.E) {
                boolean unique = true;
                IAILangContributor langContributor = AILangContributorManager.INSTANCE.getContributor(LanguageKind.E);
                for (IRfDefElement otherElement : eLangElements) {
                    if (!langContributor.areDefElementsEqual(defElement, otherElement)) continue;
                    unique = false;
                    break;
                }
                if (!unique) continue;
                defElementToNamedElement.put(defElement, namedElement);
                eLangElements.add(defElement);
                continue;
            }
            if (namedElement != null && defElementToNamedElement.containsValue(namedElement)) continue;
            defElementToNamedElement.put(defElement, namedElement);
        }
        defElements = new ArrayList(defElementToNamedElement.keySet());
        HashSet<Integer> skippedIndexes = new HashSet<Integer>();
        ArrayList<IRfDefElement> result = new ArrayList<IRfDefElement>();
        int i = 0;
        while (i < defElements.size()) {
            if (!skippedIndexes.contains(i)) {
                IRfDefElement currentElement = defElements.get(i);
                int j = i + 1;
                while (j < defElements.size()) {
                    if (!skippedIndexes.contains(j) && this.areElementsInsideEachOther(currentElement, defElements.get(j))) {
                        skippedIndexes.add(j);
                    }
                    ++j;
                }
                result.add(currentElement);
            }
            ++i;
        }
        return result;
    }

    private boolean areElementsInsideEachOther(IRfDefElement defElement1, IRfDefElement defElement2) {
        IRfNamedElement namedElement1 = defElement1.getNamedElement();
        IRfNamedElement namedElement2 = defElement2.getNamedElement();
        if (namedElement1 == null || namedElement2 == null) {
            return false;
        }
        IRfScopeElement enclosingScope = namedElement1.getEnclosingScope();
        while (enclosingScope != null) {
            if (namedElement2.equals(enclosingScope)) {
                return true;
            }
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        enclosingScope = namedElement2.getEnclosingScope();
        while (enclosingScope != null) {
            if (namedElement1.equals(enclosingScope)) {
                return true;
            }
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        return false;
    }

    public VerissimoCheckInfo getVerissimoCheckInfoFromHit(OVMComplianceCheckHit hit) {
        OVMComplianceCheck hitCheck = hit.getCheck();
        VerissimoCheckInfo checkInfo = new VerissimoCheckInfo();
        checkInfo.setTitle(hitCheck.getTitle());
        checkInfo.setDescription(hitCheck.getFullDescription());
        ArrayList<VerissimoParameterInfo> parameterInfoList = new ArrayList<VerissimoParameterInfo>();
        for (Map parameter : hitCheck.getParametersToDisplay()) {
            VerissimoParameterInfo parameterInfo = new VerissimoParameterInfo((String)parameter.get("name"), (String)parameter.get("description"), parameter.get("userValue") != null ? (String)parameter.get("userValue") : (String)parameter.get("defaultValue"));
            parameterInfoList.add(parameterInfo);
        }
        checkInfo.setParameters(parameterInfoList.toArray(new VerissimoParameterInfo[0]));
        checkInfo.setAllowedExamples(null);
        checkInfo.setNotAllowedExamples(null);
        return checkInfo;
    }

    public VerissimoFailureAdditionalInformation getVerissimoAdditionalInformationFromCheckHit(OVMComplianceCheckHit checkHit) {
        VerissimoFailureAdditionalInformation additionalInformation = new VerissimoFailureAdditionalInformation();
        if (checkHit == null) {
            return null;
        }
        OVMComplianceCheck ovmComplianceCheck = checkHit.getCheck();
        if (ovmComplianceCheck == null) {
            return null;
        }
        IProject iProject = ovmComplianceCheck.getIProject();
        if (iProject == null) {
            return null;
        }
        IFile iFile = DVTFileUtils.getInstance().findProjectFile(iProject, checkHit.getParserPath().getCanonicalPath());
        additionalInformation.setFileContent(DVTFileUtils.getInstance().readFileContent(iFile));
        return additionalInformation;
    }

    public abstract IProject getSelectedProject();

    public abstract HistoryItem getVHTop(IProject var1);

    public abstract DVTEditor getActiveDVTEditor();

    public abstract IDocument getDocumentFromPath(IProject var1, String var2);

    public abstract IDocument getDocumentFromFile(IFile var1);

    public abstract IRfNamedElementAndScope getNamedElementAndScopeAtEditorPosition(EditorPosition var1);

    public abstract void writeToAiConsole(LogTarget var1, String var2, LogSeverity var3, String var4);

    protected abstract int getTabSizeFromPreferences();

    protected abstract int getTabSizeForFilePath(String var1);

    protected abstract String getNatureForFilePath(String var1, IProject var2);

    public abstract void showInvalidEnvironmentVariablesWarning(String var1, int var2);

    public abstract void checkSnippetSolvingCancellation(BooleanSupplier var1, String var2);

    public abstract void checkSymbolSolvingCancellation(BooleanSupplier var1, String var2);

    public abstract List<Problem> getProblemsForFile(String var1, IProject var2, boolean var3);

    public abstract void writeDebugToAIToolsConsole(String var1);

    public abstract void writeErrorToAIToolsConsole(String var1, Throwable var2);

    protected static class LineRange {
        public static final LineRange DEFAULT_LINE_RANGE = new LineRange(0, Integer.MAX_VALUE);
        private final int startLine;
        private final int endLine;

        private LineRange(int startLine, int endLine) {
            this.startLine = startLine;
            this.endLine = endLine;
        }

        protected int getStartLine() {
            return this.startLine;
        }

        protected int getEndLine() {
            return this.endLine;
        }

        private static LineRange getDefault() {
            return DEFAULT_LINE_RANGE;
        }
    }
}

