/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.ai.ContextChangeListener;
import ro.amiq.dvt.ai.ContextClause;

public enum BooleanContextClauses implements ContextClause<Boolean>
{
    IS_CONVERSATION_DISPLAYED(true),
    IS_AI_ENABLED(false);

    private Boolean value;
    private Set<ContextChangeListener<Boolean>> contextChangeListeners = new HashSet<ContextChangeListener<Boolean>>(1);

    private BooleanContextClauses(Boolean defaultValue) {
        this.value = defaultValue;
    }

    @Override
    public void addContextChangeListener(ContextChangeListener<Boolean> contextChangedListener) {
        this.contextChangeListeners.add(contextChangedListener);
    }

    @Override
    public void removeContextChangeListener(ContextChangeListener<Boolean> contextChangeListener) {
        if (contextChangeListener == null) {
            return;
        }
        this.contextChangeListeners.remove(contextChangeListener);
    }

    @Override
    public void updateValue(Boolean value) {
        for (ContextChangeListener<Boolean> contextChangeListener : this.contextChangeListeners) {
            contextChangeListener.contextChanged(this.value, value);
        }
        this.value = value;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }
}

