/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.concurrent.CompletableFuture;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.BooleanContextClauses;
import ro.amiq.dvt.ai.model.params.SaveSessionAsBlueprintParams;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public enum ChatManager {
    INSTANCE;


    public void focusChat() {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            try {
                DVTUiUtils.getActivePage().showView("ro.amiq.dvt.ai.eclipse.AIChat");
            }
            catch (PartInitException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public void closeChatView() {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            IViewPart viewID = DVTUiUtils.getActivePage().findView("ro.amiq.dvt.ai.eclipse.AIChat");
            DVTUiUtils.getActivePage().hideView(viewID);
        });
    }

    public void focusInput() {
        ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().focusInput())).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }

    public void showHistory() {
        INSTANCE.focusChat();
        ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> {
            aiManager.getHost().getCore().browseSessionHistory();
            BooleanContextClauses.IS_CONVERSATION_DISPLAYED.updateValue(false);
        })).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }

    public void showConversation() {
        ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> {
            aiManager.getHost().getCore().showLastChatSession();
            BooleanContextClauses.IS_CONVERSATION_DISPLAYED.updateValue(true);
        })).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }

    public void openNewSession() {
        INSTANCE.focusChat();
        ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().startUninitializedSession())).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }

    public void saveCurrentSessionAsBlueprint() {
        AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().saveSessionAsBlueprint(new SaveSessionAsBlueprintParams()));
    }
}

