/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.concurrent.CompletableFuture;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.LogSeverity;
import ro.amiq.dvt.ai.model.LogTarget;
import ro.amiq.dvt.ai.model.params.ExecuteCodeActionHostParams;
import ro.amiq.dvt.ai.model.params.LogParams;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.compare.CompareInput;
import ro.amiq.dvt.ui.compare.FileCompareInputPart;
import ro.amiq.dvt.ui.compare.ICompareInputPart;
import ro.amiq.dvt.ui.compare.TextCompareInputPart;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.newfile.AIOperationType;
import ro.amiq.dvt.wizards.newfile.FormatNewFileContentPatternType;
import ro.amiq.dvt.wizards.newfile.IOperationType;
import ro.amiq.dvt.wizards.newfile.NewFileWithCustomContentWizard;

public enum CodeActionExecutor {
    INSTANCE;


    void executeCodeAction(ExecuteCodeActionHostParams params) {
        switch (params.actionType) {
            case "insert-at-cursor": {
                this.replaceSelection(params);
                break;
            }
            case "insert-at-cursor-and-compare": {
                this.replaceSelection(params, true);
                break;
            }
            case "copy-to-clipboard": {
                Display.getDefault().syncExec(() -> Utils.copyToClipboard((String)executeCodeActionHostParams.content, (int)3));
                break;
            }
            case "insert-in-new-file": {
                this.insertInNewFile(params.content);
            }
        }
    }

    void replaceSelection(ExecuteCodeActionHostParams params) {
        this.replaceSelection(params, false);
    }

    void replaceSelection(ExecuteCodeActionHostParams params, boolean showDiff) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof ITextEditor)) {
            ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().log(new LogParams(LogTarget.AI_CONSOLE, "Active editor could not be found!", LogSeverity.ERROR, "Active editor could not be found!")))).exceptionally(ex -> {
                DVTLogger.INSTANCE.logError(ex);
                return null;
            });
            return;
        }
        ITextEditor activeTextEditor = (ITextEditor)activeEditor;
        IDocument activeEditorDocument = DVTFileUtils.getInstance().getDocument(activeTextEditor);
        if (activeEditorDocument == null) {
            return;
        }
        String initialContent = activeEditorDocument.get();
        ISelectionProvider selectionProvider = activeTextEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            try {
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof ITextSelection)) {
                    return;
                }
                ITextSelection textSelection = (ITextSelection)selection;
                activeEditorDocument.replace(textSelection.getOffset(), textSelection.getLength(), executeCodeActionHostParams.content);
                if (!showDiff) {
                    return;
                }
                FileCompareInputPart left = new FileCompareInputPart(DVTFileUtils.getInstance().getEditorFile(activeEditor));
                TextCompareInputPart right = new TextCompareInputPart(left.getType(), initialContent);
                CompareInput input = new CompareInput((ICompareInputPart)left, (ICompareInputPart)right);
                CompareUI.openCompareEditor((CompareEditorInput)input);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    private void insertInNewFile(String content) {
        IPath cwd = this.getCWD();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(() -> {
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            NewFileWithCustomContentWizard wizard = new NewFileWithCustomContentWizard(content, cwd, FormatNewFileContentPatternType.NO_PATTERN, (IOperationType)AIOperationType.COPY_CODE_TO_NEW_FILE, "new_file");
            wizard.init(workbench, null);
            WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
            dialog.open();
        });
    }

    private IPath getCWD() {
        IProject project = AIUtils.getInstance().getSelectedProject();
        String editorPath = AIUtils.getInstance().getActiveEditorRelativePath();
        Object projectPath = editorPath == null || !editorPath.contains("/") ? project.getFullPath() : new Path(String.valueOf(project.getName()) + "/" + editorPath.substring(0, editorPath.lastIndexOf("/")));
        return projectPath;
    }
}

