/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.ai.AIHostExecutor;
import ro.amiq.dvt.ai.AIHostLS;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.ChatManager;
import ro.amiq.dvt.ai.EditorSession;
import ro.amiq.dvt.ai.model.SessionBlueprint;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIFileEditException;
import ro.amiq.dvt.ai.model.params.AssistantMessageParams;
import ro.amiq.dvt.ai.model.params.AssistantMessageStartParams;
import ro.amiq.dvt.ai.model.params.AssistantMessageStreamParams;
import ro.amiq.dvt.ai.model.params.GetSessionBlueprintsParams;
import ro.amiq.dvt.ai.model.params.ShowHostSessionParams;
import ro.amiq.dvt.ai.model.params.StartNewSessionParams;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.compare.CompareInput;
import ro.amiq.dvt.ui.compare.FileCompareInputPart;
import ro.amiq.dvt.ui.compare.ICompareInputPart;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.utils.DVTFileUtils;

public enum EditorManager {
    INSTANCE;

    private List<EditorSession> activeEditorSessions = new ArrayList<EditorSession>();

    public void startNewSession() {
        ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> {
            AIHostLS host = aiManager.getHost();
            host.getCore().getSessionBlueprints(new GetSessionBlueprintsParams(Arrays.asList("chat", "editor"))).thenAcceptAsync(sessionBlueprintsResponse -> {
                try {
                    if (sessionBlueprintsResponse == null) {
                        return;
                    }
                    if (sessionBlueprintsResponse.blueprints == null || sessionBlueprintsResponse.blueprints.isEmpty()) {
                        return;
                    }
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(DVTUiUtils.getActiveWorkbenchShell(), (ILabelProvider)new LabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SessionBlueprint) {
                                SessionBlueprint sessionBlueprint = (SessionBlueprint)element;
                                if (sessionBlueprint.target == null) {
                                    sessionBlueprint.target = "chat";
                                }
                                return String.valueOf(sessionBlueprint.name) + " (" + sessionBlueprint.target + ") ";
                            }
                            return super.getText(element);
                        }
                    });
                    dialog.setElements(sessionBlueprintsResponse.blueprints.toArray());
                    dialog.setMultipleSelection(false);
                    dialog.setTitle("Select Blueprint");
                    PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                        int n = dialog.open();
                    });
                    Object[] result = dialog.getResult();
                    if (result == null || result.length == 0) {
                        return;
                    }
                    if (result[0] == null || !(result[0] instanceof SessionBlueprint)) {
                        return;
                    }
                    SessionBlueprint selectedBlueprint = (SessionBlueprint)result[0];
                    this.startNewSessionFromBlueprint(selectedBlueprint.name, selectedBlueprint.target);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }, (Executor)AIHostExecutor.INSTANCE.getExecutorService());
        })).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }

    public void writeCommentsForSelectedElement() {
        this.startNewSessionFromBlueprint("Add comment to the selected code", "editor");
    }

    public void describeSelectedCode() {
        this.startNewSessionFromBlueprint("Explain the selected code", "chat");
    }

    public void improveSelectedCode() {
        this.startNewSessionFromBlueprint("Improve the selected code", "editor");
    }

    public void analyzeAndFixSelectedCode() {
        this.startNewSessionFromBlueprint("Analyze and fix the selected code", "editor");
    }

    public void generateCoverage() {
        this.startNewSessionFromBlueprint("Generate coverage for the current class", "editor");
    }

    public void generateConvert2string() {
        this.startNewSessionFromBlueprint("Generate convert2string for the current class", "editor");
    }

    public void addLogging() {
        this.startNewSessionFromBlueprint("Add logging to the selected code", "editor");
    }

    private void startNewSessionFromBlueprint(String name, String target) {
        if ("chat".equals(target)) {
            ChatManager.INSTANCE.focusChat();
        }
        ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> AIUtils.getInstance().runTaskWithProgress(() -> aiManager.getHost().getCore().startNewSession(new StartNewSessionParams("blueprint", name)), "Starting new " + target + " session...", 2500L))).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }

    boolean startEditorSession(ShowHostSessionParams params) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof ITextEditor)) {
            return false;
        }
        EditorSession createEditorSession = this.createEditorSession(params.sessionId, (ITextEditor)activeEditor, params.type);
        if (createEditorSession == null) {
            return false;
        }
        this.activeEditorSessions.add(createEditorSession);
        return true;
    }

    private EditorSession createEditorSession(long sessionId, ITextEditor activeEditor, String type) {
        IDocument activeEditorDocument = DVTFileUtils.getInstance().getDocument(activeEditor);
        if (activeEditorDocument == null) {
            return null;
        }
        ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor((IEditorPart)activeEditor);
        if (textSelection == null) {
            return null;
        }
        IFile file = DVTFileUtils.getInstance().getEditorFile((IEditorPart)activeEditor);
        if (file != null) {
            try {
                DVTFileModificationValidator.validateEdit((IFile)file);
            }
            catch (CoreException coreException) {
                String errorMessage = String.format(AIExceptionKind.FAILED_FILE_EDIT.MESSAGE, file.getName());
                throw new AIFileEditException(new AIExceptionData(AIExceptionKind.FAILED_FILE_EDIT.KIND, errorMessage, 0));
            }
        }
        Region region = new Region(textSelection.getOffset(), textSelection.getLength());
        AtomicInteger cursorOffset = new AtomicInteger(-1);
        if (activeEditor instanceof DVTEditor) {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> cursorOffset.set(((DVTEditor)activeEditor).getCursor()));
        }
        try {
            return new EditorSession(sessionId, activeEditor, activeEditorDocument.get(), (IRegion)region, cursorOffset.get(), type);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    void assistantMessageStart(AssistantMessageStartParams params) {
        EditorSession editorSession = this.getEditorSession(params.sessionId);
        if (editorSession == null) {
            return;
        }
        editorSession.messageStart(params);
    }

    void assistantMessageStop(AssistantMessageParams params) {
        EditorSession editorSession = this.getEditorSession(params.sessionId);
        if (editorSession == null) {
            return;
        }
        editorSession.messageStop(params);
    }

    void assistantMessageStream(AssistantMessageStreamParams params) {
        EditorSession editorSession = this.getEditorSession(params.sessionId);
        if (editorSession == null) {
            return;
        }
        editorSession.messageStream(params);
    }

    EditorSession getEditorSession(long sessionId) {
        Optional<EditorSession> optionalSession = this.activeEditorSessions.stream().filter(editorSession -> editorSession.getSessionId() == sessionId).findFirst();
        if (!optionalSession.isPresent()) {
            return null;
        }
        return optionalSession.get();
    }

    public void stopCurrentEditorGeneration() {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        EditorSession editorSession = null;
        if (activeEditor instanceof CompareEditor) {
            CompareEditor compareEditor = (CompareEditor)activeEditor;
            IEditorInput editorInput = compareEditor.getEditorInput();
            if (!(editorInput instanceof CompareInput)) {
                return;
            }
            CompareInput compareInput = (CompareInput)editorInput;
            FileCompareInputPart fileCompareInputPart = null;
            ICompareInputPart leftCompareInputPart = compareInput.getLeftCompareInputPart();
            if (leftCompareInputPart instanceof FileCompareInputPart) {
                fileCompareInputPart = (FileCompareInputPart)leftCompareInputPart;
            } else {
                ICompareInputPart rightCompareInputPart = compareInput.getRightCompareInputPart();
                if (rightCompareInputPart instanceof FileCompareInputPart) {
                    fileCompareInputPart = (FileCompareInputPart)rightCompareInputPart;
                }
            }
            if (fileCompareInputPart == null) {
                return;
            }
            IFile file = fileCompareInputPart.getFile();
            if (file == null) {
                return;
            }
            IPath location = file.getLocation();
            if (location == null) {
                return;
            }
            editorSession = this.getEditorSession(location.toOSString());
        } else {
            editorSession = this.getEditorSession(activeEditor);
        }
        this.stopEditorGeneration(editorSession);
    }

    private EditorSession getEditorSession(String editorFileLocationOSString) {
        if (editorFileLocationOSString == null) {
            return null;
        }
        Optional<EditorSession> optionalSession = this.activeEditorSessions.stream().filter(editorSession -> {
            IEditorPart editor = editorSession.getActiveEditor();
            IFile editorFile = DVTFileUtils.getInstance().getEditorFile(editor);
            if (editorFile == null) {
                return false;
            }
            IPath editorFileLocation = editorFile.getLocation();
            return editorFileLocationOSString.equals(editorFileLocation.toOSString());
        }).findFirst();
        if (!optionalSession.isPresent()) {
            return null;
        }
        return optionalSession.get();
    }

    private void stopEditorGeneration(EditorSession editorSession) {
        if (editorSession == null) {
            return;
        }
        editorSession.stopGeneration();
        this.removeEditorSession(editorSession);
    }

    private EditorSession getEditorSession(IEditorPart activeEditor) {
        if (activeEditor == null) {
            return null;
        }
        Optional<EditorSession> optionalSession = this.activeEditorSessions.stream().filter(editorSession -> editorSession.getActiveEditor().equals(activeEditor)).findFirst();
        if (!optionalSession.isPresent()) {
            return null;
        }
        return optionalSession.get();
    }

    void removeEditorSession(EditorSession editorSession) {
        int indexOf = this.activeEditorSessions.indexOf(editorSession);
        if (indexOf == -1) {
            return;
        }
        this.activeEditorSessions.remove(indexOf);
    }

    public List<EditorSession> getEditorSessions() {
        return this.activeEditorSessions;
    }
}

