/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.concurrent.CompletableFuture;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.EditorManager;
import ro.amiq.dvt.ai.model.LogSeverity;
import ro.amiq.dvt.ai.model.LogTarget;
import ro.amiq.dvt.ai.model.params.AssistantMessageParams;
import ro.amiq.dvt.ai.model.params.AssistantMessageStartParams;
import ro.amiq.dvt.ai.model.params.AssistantMessageStreamParams;
import ro.amiq.dvt.ai.model.params.LogParams;
import ro.amiq.dvt.ai.model.responses.GetActiveEditorInfoResponse;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.compare.CompareInput;
import ro.amiq.dvt.ui.compare.FileCompareInputPart;
import ro.amiq.dvt.ui.compare.ICompareInputPart;
import ro.amiq.dvt.ui.compare.TextCompareInputPart;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class EditorSession {
    private IRegion currentRangeToEdit;
    private boolean isDiffDisplayed;
    private long editNumber;
    private long slotId;
    private long sessionId;
    private ITextEditor activeEditor;
    private String initialContent;
    private String actionType;
    private CompareInput compareInput;
    private IRewriteTarget rewriteTarget;
    private IRegion activeSelection;

    public EditorSession(long sessionId, ITextEditor activeEditor, String initialContent, IRegion activeSelection, int cursorOffset, String actionType) throws BadLocationException {
        this.sessionId = sessionId;
        this.activeEditor = activeEditor;
        this.initialContent = initialContent;
        this.actionType = actionType;
        this.activeSelection = activeSelection;
        switch (actionType) {
            case "insert": {
                this.currentRangeToEdit = new Region(cursorOffset >= 0 ? cursorOffset : activeSelection.getOffset(), 0);
                break;
            }
            case "replace": {
                this.currentRangeToEdit = activeSelection;
                break;
            }
            case "insert-before-selection": {
                IDocument document = activeEditor.getDocumentProvider().getDocument((Object)activeEditor.getEditorInput());
                int startLineOffset = document.getLineInformationOfOffset(activeSelection.getOffset()).getOffset();
                this.currentRangeToEdit = new Region(startLineOffset + DVTDocumentUtils.getIndent((int)activeSelection.getOffset(), (IDocument)document).length(), 0);
                break;
            }
            case "insert-after-selection": {
                IDocument document = activeEditor.getDocumentProvider().getDocument((Object)activeEditor.getEditorInput());
                IRegion endLineInformation = document.getLineInformationOfOffset(activeSelection.getOffset() + activeSelection.getLength());
                int endLine = document.getLineOfOffset(activeSelection.getOffset() + activeSelection.getLength());
                int endLineOffset = endLine + 1 > document.getNumberOfLines() - 1 ? endLineInformation.getOffset() + endLineInformation.getLength() : document.getLineOffset(endLine + 1) + DVTDocumentUtils.getIndent((int)document.getLineOffset(endLine + 1), (IDocument)document).length();
                this.currentRangeToEdit = new Region(endLineOffset, 0);
                break;
            }
        }
        if (activeEditor == null) {
            return;
        }
        this.rewriteTarget = (IRewriteTarget)activeEditor.getAdapter(IRewriteTarget.class);
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public IEditorPart getActiveEditor() {
        return this.activeEditor;
    }

    private void showDiffEditor() {
        Display.getDefault().syncExec(() -> {
            FileCompareInputPart left = new FileCompareInputPart(DVTFileUtils.getInstance().getEditorFile((IEditorPart)this.activeEditor));
            TextCompareInputPart right = new TextCompareInputPart(left.getType(), this.initialContent);
            this.compareInput = new CompareInput((ICompareInputPart)left, (ICompareInputPart)right);
            CompareUI.openCompareEditor((CompareEditorInput)this.compareInput);
        });
    }

    void messageStop(AssistantMessageParams params) {
        if (this.compareInput != null) {
            this.compareInput.reuseEditor();
            this.compareInput = null;
        }
        if (this.rewriteTarget != null) {
            this.rewriteTarget.endCompoundChange();
        }
        EditorManager.INSTANCE.removeEditorSession(this);
    }

    void messageStream(AssistantMessageStreamParams params) {
        this.addEdit(params.content);
        if (!this.isDiffDisplayed) {
            this.showDiffEditor();
            this.isDiffDisplayed = true;
        }
        if (this.editNumber > 2L) {
            return;
        }
        if (this.compareInput == null) {
            return;
        }
        this.compareInput.reuseEditor();
    }

    void messageStart(AssistantMessageStartParams params) {
        this.slotId = params.slot.id;
        if (this.rewriteTarget != null) {
            this.rewriteTarget.beginCompoundChange();
        }
    }

    void stopGeneration() {
        ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().assistantMessageStreamCancel(new AssistantMessageParams(this.slotId, this.sessionId)))).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }

    /*
     * Exception decompiling
     */
    private void addEdit(String content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[9] lbl62 : CaseStatement: default:\u000a, @NONE, blocks:[9] lbl62 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    GetActiveEditorInfoResponse getActiveEditorInfo() {
        IDocument activeEditorDocument = this.rewriteTarget.getDocument();
        if (activeEditorDocument == null || !(this.activeEditor instanceof DVTEditor)) {
            return new GetActiveEditorInfoResponse("", "");
        }
        return new GetActiveEditorInfoResponse(AIUtils.getInstance().getSingleLineCommentForLanguageKind(((DVTEditor)this.activeEditor).getLanguageKind()), DVTDocumentUtils.getIndent((int)this.activeSelection.getOffset(), (IDocument)activeEditorDocument));
    }

    private void updateCurrentRangeToEdit(String content) {
        this.currentRangeToEdit = new Region(this.currentRangeToEdit.getOffset() + content.length(), 0);
    }

    private /* synthetic */ void lambda$3(IDocument iDocument, String string) {
        try {
            iDocument.replace(this.currentRangeToEdit.getOffset(), 0, string);
            ++this.editNumber;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private /* synthetic */ void lambda$4(String string, AIManager aiManager) {
        aiManager.getHost().log(new LogParams(LogTarget.AI_CONSOLE, "Failed to insert content " + string + " in file " + this.activeEditor, LogSeverity.ERROR, ""));
    }

    private static /* synthetic */ Void lambda$5(Throwable ex) {
        DVTLogger.INSTANCE.logError(ex);
        return null;
    }

    private /* synthetic */ void lambda$6(IDocument iDocument, String string) {
        try {
            iDocument.replace(this.currentRangeToEdit.getOffset(), this.currentRangeToEdit.getLength(), string);
            ++this.editNumber;
            this.updateCurrentRangeToEdit(string);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private /* synthetic */ void lambda$7(String string, AIManager hostManger) {
        hostManger.getHost().log(new LogParams(LogTarget.AI_CONSOLE, "Failed to replace content " + string + " in file " + this.activeEditor, LogSeverity.ERROR, ""));
    }
}

