/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ai.AIGitUtils;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.ChatManager;
import ro.amiq.dvt.ai.model.params.StartNewSessionParams;
import ro.amiq.dvt.ai.model.responses.InsertCommitMessageResponse;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum GitManager {
    INSTANCE;

    private static final String GENERATE_COMMIT_CHAT_BP_NAME = "Generate commit message";
    private static final String SUMMARIZE_REMOTE_BP_NAME = "Summarize remote changes ahead of current commit";
    private static final String CODE_REVIEW_BP_NAME = "Review uncommitted changes";

    public InsertCommitMessageResponse insertCommitMessage(BooleanSupplier isCanceled, String commitMessage) {
        AtomicBoolean canceled = new AtomicBoolean(false);
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            IViewPart stagingView = AIGitUtils.INSTANCE.getStagingView();
            if (stagingView == null) {
                return;
            }
            try {
                StyledText textBox = AIGitUtils.INSTANCE.getTextBox(stagingView);
                if (textBox == null) {
                    return;
                }
                if (isCanceled.getAsBoolean()) {
                    canceled.set(true);
                    return;
                }
                String currentText = textBox.getText();
                if (currentText == null || currentText.isBlank()) {
                    textBox.setText(commitMessage);
                } else {
                    textBox.setText(String.valueOf(currentText) + System.lineSeparator() + commitMessage);
                }
                textBox.setFocus();
            }
            catch (Exception exception) {
                return;
            }
        });
        return new InsertCommitMessageResponse(canceled.get());
    }

    public void generateCommitMessageChat() {
        this.startNewSessionFromBlueprint(GENERATE_COMMIT_CHAT_BP_NAME);
    }

    public void summarizeRemoteChanges() {
        this.startNewSessionFromBlueprint(SUMMARIZE_REMOTE_BP_NAME);
    }

    public void codeReview() {
        this.startNewSessionFromBlueprint(CODE_REVIEW_BP_NAME);
    }

    private void startNewSessionFromBlueprint(String name) {
        ChatManager.INSTANCE.focusChat();
        ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> AIUtils.getInstance().runTaskWithProgress(() -> aiManager.getHost().getCore().startNewSession(new StartNewSessionParams("blueprint", name)), "Starting new chat session...", 2500L))).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }
}

