/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.contributor.AILangContributorManager;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.SnippetSelectionType;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;

public abstract class HotspotManagerCommon {
    private static final int MAX_NUMBER_OF_HOTSPOTS = 200;
    private static final int MAX_NUMBER_OF_RECENT_FILES = 50;
    private LinkedList<String> recentFiles = new LinkedList();
    private LinkedList<IRfDefElement> recentHotpots = new LinkedList();

    public void addRecentHotspotFromEditorPosition(EditorPosition editorPosition) {
        if (editorPosition == null) {
            return;
        }
        IRfNamedElementAndScope rfNamedElementAndScope = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(editorPosition);
        if (rfNamedElementAndScope == null) {
            return;
        }
        LanguageKind languageKind = rfNamedElementAndScope.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return;
        }
        IRfDefElement elementContainer = AIUtils.getInstance().getNamedElementContainer(rfNamedElementAndScope, aiContributor.getAcceptedContainers(SnippetSelectionType.CONTAINER));
        if (elementContainer == null) {
            return;
        }
        String containerPath = AIUtils.getInstance().getFilePathFromDefElement(elementContainer, false);
        IRfSingleLangProject containerRfProject = elementContainer.getRfProject();
        if (containerRfProject == null) {
            return;
        }
        IFile file = editorPosition.getFile();
        if (file == null) {
            return;
        }
        if (containerPath != null && !AIPathUtils.INSTANCE.pathsAreEqual(containerPath, containerRfProject.getProject(), editorPosition.getFullPath(), file.getProject())) {
            return;
        }
        this.addRecentHotspot(elementContainer);
    }

    public void addRecentFile(String filePath) {
        if (filePath == null) {
            return;
        }
        String normalizedFile = AIPathUtils.INSTANCE.normalizePath(filePath);
        this.recentFiles.remove(normalizedFile);
        this.recentFiles.addFirst(normalizedFile);
        if (this.recentFiles.size() > 50) {
            this.recentFiles.removeLast();
        }
    }

    public boolean isFileRecent(String filePath) {
        for (String recentFile : this.recentFiles) {
            if (!recentFile.equals(filePath)) continue;
            return true;
        }
        return false;
    }

    private void addRecentHotspot(IRfDefElement defElement) {
        if (defElement == null || defElement.getParserPath() == null) {
            return;
        }
        this.recentHotpots.remove(defElement);
        this.recentHotpots.addFirst(defElement);
        if (this.recentHotpots.size() > 200) {
            this.recentHotpots.removeLast();
        }
    }

    public List<IRfDefElement> getRecentHotspots() {
        ArrayList<IRfDefElement> result = new ArrayList<IRfDefElement>();
        for (IRfDefElement hotspot : this.recentHotpots) {
            IRfSingleLangProject rfProject;
            ParserPath parserPath = hotspot.getParserPath();
            if (parserPath == null || parserPath.path == null || !this.isFileRecent(AIPathUtils.INSTANCE.normalizePath(parserPath.path)) || (rfProject = hotspot.getRfProject()) == null || AIProtectManager.INSTANCE.isFileProtected(parserPath.path, rfProject.getProject())) continue;
            result.add(hotspot);
        }
        return this.removeDuplicateHotspots(result);
    }

    public List<IRfDefElement> getRecentHotspotsFromOpenEditors() {
        ArrayList<IRfDefElement> result = new ArrayList<IRfDefElement>();
        for (IRfDefElement hotspot : this.recentHotpots) {
            IRfSingleLangProject rfProject;
            ParserPath parserPath = hotspot.getParserPath();
            if (parserPath == null || parserPath.path == null || (rfProject = hotspot.getRfProject()) == null || AIProtectManager.INSTANCE.isFileProtected(parserPath.path, rfProject.getProject()) || !this.getOpenEditorsNormalizedPaths().contains(AIPathUtils.INSTANCE.normalizePath(parserPath.path))) continue;
            result.add(hotspot);
        }
        return this.removeDuplicateHotspots(result);
    }

    private List<IRfDefElement> removeDuplicateHotspots(List<IRfDefElement> hotspots) {
        return AIUtils.getInstance().removeDuplicateDefElements(hotspots, true);
    }

    protected abstract Set<String> getOpenEditorsNormalizedPaths();
}

