/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import com.google.gson.Gson;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.ai.AIHostAPI;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.ChatManager;
import ro.amiq.dvt.ai.model.LogSeverity;
import ro.amiq.dvt.ai.model.LogTarget;
import ro.amiq.dvt.ai.model.ModelInfo;
import ro.amiq.dvt.ai.model.params.FindFilesParams;
import ro.amiq.dvt.ai.model.params.OpenFileParams;
import ro.amiq.dvt.ai.model.params.SetCurrentLanguageModelParams;
import ro.amiq.dvt.ai.model.params.WriteFileParams;
import ro.amiq.dvt.ai.model.responses.FindFilesResponse;
import ro.amiq.dvt.ai.model.responses.GetAvailableLanguageModelsResponse;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;

public enum ModelsManager {
    INSTANCE;

    public static final String TOOLBAR_ID = "ro.amiq.dvt.toolbar.AI";
    public static final Gson GSON;
    private static final String CRT_MODEL_DISABLED_TEXT = "Disabled";
    private static final String CRT_MODEL_NOT_FOUND_TEXT = "Configure";
    private Set<IWorkbenchWindow> windows = new HashSet<IWorkbenchWindow>();
    private boolean isModelAvailable;
    private Action setCurrentModelAction;
    private Action noModelAction;
    private Action disabledModeAction;
    List<ModelInfo> availableModels;

    static {
        GSON = new Gson();
    }

    public void showDisableMsg() {
        String text = CRT_MODEL_DISABLED_TEXT;
        String tooltip = "AI Assistant is disabled";
        if (this.disabledModeAction == null) {
            this.disabledModeAction = new DisabledModeAction();
        }
        this.populateToolbar(this.disabledModeAction);
        this.disabledModeAction.setText(text);
        this.disabledModeAction.setToolTipText(tooltip);
        DVTUiUtils.redrawToolbarInCoolbar((String)TOOLBAR_ID);
    }

    public void selectModel(ModelInfo modelInfo) {
        if (modelInfo == null) {
            this.showNoModelInfo();
            return;
        }
        boolean bl = this.isModelAvailable = modelInfo.modelRef != null && modelInfo.modelRef.model != null && !modelInfo.modelRef.model.isEmpty();
        if (!this.isModelAvailable) {
            this.showNoModelInfo();
            return;
        }
        String text = String.valueOf(modelInfo.modelRef.model) + " (" + (modelInfo.providerDisplayName != null ? modelInfo.providerDisplayName : modelInfo.modelRef.provider) + ")";
        String tooltip = "Current Language Model:\n" + modelInfo.details;
        if (this.setCurrentModelAction == null) {
            this.setCurrentModelAction = new SetModelAction();
        }
        this.populateToolbar(this.setCurrentModelAction);
        this.setCurrentModelAction.setMenuCreator((IMenuCreator)new DefaultModelMenuCreator());
        this.setCurrentModelAction.setText(text);
        this.setCurrentModelAction.setToolTipText(tooltip);
        DVTUiUtils.redrawToolbarInCoolbar((String)TOOLBAR_ID);
    }

    public void showNoModelInfo() {
        String text = CRT_MODEL_NOT_FOUND_TEXT;
        String tooltip = "No Language Models Found. Open models.json...";
        this.isModelAvailable = false;
        if (this.noModelAction == null) {
            this.noModelAction = new NoModelAction();
        }
        this.populateToolbar(this.noModelAction);
        this.noModelAction.setText(text);
        this.noModelAction.setToolTipText(tooltip);
        DVTUiUtils.redrawToolbarInCoolbar((String)TOOLBAR_ID);
    }

    private synchronized void populateToolbar(Action action) {
        IWorkbenchWindow window = DVTUiUtils.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IToolBarManager toolbarManager = DVTUiUtils.getToolbarManager((IWorkbenchWindow)window, (String)TOOLBAR_ID);
        if (toolbarManager == null) {
            return;
        }
        if (this.setCurrentModelAction == null) {
            this.setCurrentModelAction = new SetModelAction();
        }
        if (this.noModelAction == null) {
            this.noModelAction = new NoModelAction();
        }
        if (this.disabledModeAction == null) {
            this.disabledModeAction = new DisabledModeAction();
        }
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)action);
        actionContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        if (!toolbarManager.isEmpty()) {
            toolbarManager.removeAll();
        }
        toolbarManager.add((IContributionItem)actionContributionItem);
    }

    public void testModeSetLanguageModel(String modelName, String providerName) throws InterruptedException, ExecutionException, TimeoutException {
        if (!TestHelper.isTestMode()) {
            return;
        }
        AIManager aiManager = AIManager.getInstance().get(20L, TimeUnit.SECONDS);
        GetAvailableLanguageModelsResponse getAvailableLanguageModelsResponse = aiManager.getHost().getCore().getAvailableLanguageModels().get(20L, TimeUnit.SECONDS);
        if (getAvailableLanguageModelsResponse == null) {
            throw new RuntimeException("No available models found!");
        }
        this.availableModels = getAvailableLanguageModelsResponse.modelInfos;
        if (this.availableModels == null || this.availableModels.isEmpty()) {
            throw new RuntimeException("No available models found!");
        }
        for (ModelInfo modelInfo : this.availableModels) {
            if (!modelInfo.getModelRef().getModel().equals(modelName) || !modelInfo.getModelRef().getProvider().equals(providerName)) continue;
            aiManager.getHost().getCore().setCurrentLanguageModel(new SetCurrentLanguageModelParams(modelInfo.getModelRef()));
        }
    }

    public boolean isModelsAvailable() {
        return this.isModelAvailable;
    }

    private final class DefaultModelMenuCreator
    implements IMenuCreator {
        private static final String NO_VALID_LLM_MESSAGE = "Unable to find a valid language model configuration!";
        private Menu menu;

        private DefaultModelMenuCreator() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            this.menu = new Menu(parent);
            this.menu.setVisible(true);
            AIManager.getInstance().thenAccept(aiManager -> ((CompletableFuture)aiManager.getHost().getCore().getAvailableLanguageModels().thenAccept(getAvailableLanguageModelsResponse -> {
                if (getAvailableLanguageModelsResponse == null) {
                    return;
                }
                ModelsManager.this.availableModels = getAvailableLanguageModelsResponse.modelInfos;
            })).thenRun(() -> {
                if (ModelsManager.this.availableModels == null || ModelsManager.this.availableModels.isEmpty()) {
                    AIUtils.getInstance().writeToAiConsole(LogTarget.AI_CONSOLE, NO_VALID_LLM_MESSAGE, LogSeverity.ERROR, NO_VALID_LLM_MESSAGE);
                    return;
                }
                parent.getDisplay().asyncExec(() -> {
                    for (ModelInfo availableModel : ModelsManager.this.availableModels) {
                        if (availableModel == null) continue;
                        MenuItem menuItem = new MenuItem(this.menu, 16);
                        menuItem.setText(String.valueOf(availableModel.modelRef.model) + " (" + (availableModel.providerDisplayName != null ? availableModel.providerDisplayName : availableModel.modelRef.provider) + ")");
                        menuItem.setSelection(availableModel.isCurrent);
                        menuItem.addSelectionListener(new SelectionListener((AIManager)aiManager, availableModel){
                            private final /* synthetic */ AIManager val$aiManager;
                            private final /* synthetic */ ModelInfo val$availableModel;
                            {
                                this.val$aiManager = aIManager;
                                this.val$availableModel = modelInfo;
                            }

                            public void widgetSelected(SelectionEvent e) {
                                if (!(e.widget instanceof MenuItem)) {
                                    return;
                                }
                                if (!((MenuItem)e.widget).getSelection()) {
                                    return;
                                }
                                this.val$aiManager.getHost().getCore().setCurrentLanguageModel(new SetCurrentLanguageModelParams(this.val$availableModel.modelRef));
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                                this.widgetSelected(e);
                            }
                        });
                    }
                    this.menu.setVisible(true);
                    this.menu.getParent().layout();
                });
            }));
            return this.menu;
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }
    }

    private final class DisabledModeAction
    extends Action {
        public DisabledModeAction() {
            this.setImageDescriptor(DVTImages.AI_ASSISTANT);
            this.setEnabled(true);
        }

        public boolean isHandled() {
            return true;
        }

        public void run() {
            ChatManager.INSTANCE.focusChat();
        }
    }

    private final class NoModelAction
    extends Action {
        public NoModelAction() {
            this.setImageDescriptor(DVTImages.AI_ASSISTANT);
            this.setEnabled(true);
        }

        public boolean isHandled() {
            return true;
        }

        public void run() {
            this.openMockModelConfigurationFile();
            try {
                AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().getAvailableLanguageModels().thenAccept(getAvailableLanguageModelsResponse -> {
                    if (getAvailableLanguageModelsResponse == null) {
                        return;
                    }
                    ModelsManager.this.availableModels = getAvailableLanguageModelsResponse.modelInfos;
                }));
            }
            catch (Exception exception) {}
        }

        private void openMockModelConfigurationFile() {
            String path = AIUtils.getInstance().getDVTUserDir().concat("/ai/models.jsonc");
            FindFilesParams params = new FindFilesParams();
            params.cwd = "rootDir";
            params.glob = path;
            params.kind = "file";
            FindFilesResponse response = AIHostAPI.INSTANCE.findFiles(null, params);
            if (response.files.isEmpty()) {
                String content = "//\n// See the Advanced LLM Configuration docs for more information:\n// https://eda.amiq.com/documentation/eclipse/sv/toc/ai-assistant/advanced-llm-configuration.html\n//\n// Configuration example for OpenAI gpt-4o:\n//\n// {\n// \t\"version\": 6,\n// \t\"configs\": [\n// \t\t{\n// \t\t\t\"provider\": \"openai\",\n// \t\t\t\"models\": \"gpt-4o\",\n// \t\t\t\"providerOptions\": {\n// \t\t\t\t\"apiKey\": \"...\"\n// \t\t\t}\n// \t\t}\n// \t]\n// }\n";
                WriteFileParams writeParams = new WriteFileParams();
                writeParams.content = content;
                writeParams.fileNameOrPath = path;
                AIHostAPI.INSTANCE.writeFile(null, writeParams);
            }
            OpenFileParams openParams = new OpenFileParams();
            openParams.filePath = path;
            AIHostAPI.INSTANCE.openFile(null, openParams);
        }
    }

    private final class SetModelAction
    extends Action {
        public SetModelAction() {
            this.setMenuCreator(new DefaultModelMenuCreator());
            this.setImageDescriptor(DVTImages.AI_ASSISTANT);
            this.setEnabled(true);
        }

        public boolean isHandled() {
            return true;
        }

        public void run() {
            Menu menu = this.getMenuCreator().getMenu((Control)DVTUiUtils.getActiveWorkbenchWindow().getShell());
            if (menu == null) {
                return;
            }
            menu.setVisible(true);
        }
    }
}

