/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.ChatManager;
import ro.amiq.dvt.ai.model.LogSeverity;
import ro.amiq.dvt.ai.model.LogTarget;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.params.InsertTextInPromptParams;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public class SendSelectedLinesToPromptAsAnchorHandler
extends AbstractHandler {
    public static final String ID = "ro.amiq.dvt.ai.sendSelectedLinesToPromptAsAnchor";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof ITextEditor) || !(activeEditor.getEditorInput() instanceof FileEditorInput)) {
            AIUtils.getInstance().writeToAiConsole(LogTarget.AI_CONSOLE, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, LogSeverity.ERROR, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE);
            return null;
        }
        IFile file = ((FileEditorInput)activeEditor.getEditorInput()).getFile();
        if (file == null || file.getLocation() == null) {
            AIUtils.getInstance().writeToAiConsole(LogTarget.AI_CONSOLE, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, LogSeverity.ERROR, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE);
            return null;
        }
        ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor(activeEditor);
        if (textSelection == null) {
            AIUtils.getInstance().writeToAiConsole(LogTarget.AI_CONSOLE, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, LogSeverity.ERROR, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE);
            return null;
        }
        int startLine = textSelection.getStartLine() + 1;
        int endLine = textSelection.getEndLine() + 1;
        if (startLine <= 0 || endLine <= 0) {
            AIUtils.getInstance().writeToAiConsole(LogTarget.AI_CONSOLE, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, LogSeverity.ERROR, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE);
            return null;
        }
        String fileNameOrPath = AIUtils.getInstance().getPromptInsertionFromFilePath(file.getProject(), file.getLocation().toOSString());
        String fileAndRange = String.valueOf(fileNameOrPath) + ":" + startLine + "-" + endLine;
        String textToInsert = "#file:" + AIUtils.getInstance().sanitizeSymbolName(fileAndRange);
        AIManager.getInstance().thenAccept(aiManager -> {
            ChatManager.INSTANCE.focusChat();
            aiManager.getHost().getCore().insertTextInPrompt(new InsertTextInPromptParams(textToInsert));
        });
        return null;
    }
}

