/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.contributor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIConsole;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.ChatSendKeyPref;
import ro.amiq.dvt.ai.HotspotManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.ai.ICompletionProcessorAndListener;
import ro.amiq.dvt.ai.ModelsManager;
import ro.amiq.dvt.ai.SpecadorLivePreviewArgs;
import ro.amiq.dvt.ai.inlineCompletion.AICodeCompletionProcessorAndListener;
import ro.amiq.dvt.ai.mcp.McpEndpointLogger;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.FileEdit;
import ro.amiq.dvt.ai.model.LogSeverity;
import ro.amiq.dvt.ai.model.LogTarget;
import ro.amiq.dvt.ai.model.ProblemAutocorrectArgs;
import ro.amiq.dvt.ai.model.ProblemExplainArgs;
import ro.amiq.dvt.ai.model.ProblemInfo;
import ro.amiq.dvt.ai.model.VerissimoCheckInfo;
import ro.amiq.dvt.ai.model.VerissimoFailureAdditionalInformation;
import ro.amiq.dvt.ai.model.VerissimoFailureExplainArgs;
import ro.amiq.dvt.ai.model.VerissimoFailureInfo;
import ro.amiq.dvt.ai.model.params.ApplyFileEditsParams;
import ro.amiq.dvt.ai.model.params.AssistantMessageParams;
import ro.amiq.dvt.ai.model.params.AutoContextChangeParams;
import ro.amiq.dvt.ai.model.params.AutocorrectVerissimoFailureParams;
import ro.amiq.dvt.ai.model.params.GetBlueprintsForProblemParams;
import ro.amiq.dvt.ai.model.params.GetVerissimoBlueprintsForHitParams;
import ro.amiq.dvt.ai.model.params.ProblemAutocorrectParams;
import ro.amiq.dvt.ai.model.params.ProblemExplainParams;
import ro.amiq.dvt.ai.model.params.SendKeyPreferenceChangeParams;
import ro.amiq.dvt.ai.model.params.VerissimoFailureAutocorrectArgs;
import ro.amiq.dvt.ai.model.params.VerissimoFailureExplainParams;
import ro.amiq.dvt.ai.model.responses.AutocorrectVerissimoFailureResponse;
import ro.amiq.dvt.ai.model.responses.GetBlueprintsForProblemResponse;
import ro.amiq.dvt.ai.model.responses.GetVerissimoBlueprintsForHitResponse;
import ro.amiq.dvt.ai.tools.AIToolsRegistryCommon;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManagerCommon;

public class AIHostContributor
implements IAIHostContributor {
    private static final Pattern NEW_LINE = Pattern.compile("\n(?! )|\n ");
    private static final Pattern PARENTHESIS = Pattern.compile("\\((?!\\n)");
    private static final Pattern COMMA_OR_SEMICOLON = Pattern.compile("([,;])(?! *\\/\\/|--)");

    public void addEditorHotspot(IFile fCurrentFile, int fCursorOffset) {
        HotspotManager.getInstance().addRecentHotspotFromEditorPosition(new EditorPosition(fCurrentFile, fCursorOffset));
    }

    public void addRecentFile(String osString) {
        HotspotManager.getInstance().addRecentFile(osString);
    }

    public boolean isFileProtected(String filePath, IProject iProject) {
        return AIProtectManager.INSTANCE.isFileProtected(filePath, iProject);
    }

    public String getChatViewId() {
        return "ro.amiq.dvt.ai.eclipse.AIChat";
    }

    public String getNodeRuntimeId() {
        return "AINodeRuntime";
    }

    public String getMainConsoleContent() {
        return AIConsole.MAIN.getContent();
    }

    public String getAIToolsConsoleContent() {
        return AIConsole.AI_TOOLS.getContent();
    }

    public boolean isAICodeCompletionProcessorAndListener(IContentAssistProcessor processor) {
        return processor instanceof AICodeCompletionProcessorAndListener;
    }

    public ICompletionProposal[] computeCompletionProposalsForAIAssistantPage(IContentAssistProcessor processor, ITextViewer viewer, int offset) {
        return ((AICodeCompletionProcessorAndListener)processor).computeCompletionProposalsForAIAssistantPage(viewer, offset);
    }

    public ICompletionProcessorAndListener getCodeCompletionProcessorAndListener() {
        return AICodeCompletionProcessorAndListener.INSTANCE;
    }

    public void sendKeyPreferenceChange(ChatSendKeyPref newValue) {
        SendKeyPreferenceChangeParams params = new SendKeyPreferenceChangeParams(newValue);
        AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().sendKeyPreferenceChange(params));
    }

    public void autoContextPreferenceChange(boolean newValue) {
        AutoContextChangeParams params = new AutoContextChangeParams(newValue);
        AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().autoContextChange(params));
    }

    public boolean isAIModelsAvailable() {
        return ModelsManager.INSTANCE.isModelsAvailable();
    }

    public List<String> getBlueprintsForProblem(String problemMessage) {
        CompletableFuture blueprintNames = new CompletableFuture();
        AIManager.getInstance().thenAccept(aiManager -> {
            CompletableFuture<GetBlueprintsForProblemResponse> getBlueprintsFuture = aiManager.getHost().getCore().getBlueprintsForProblem(new GetBlueprintsForProblemParams(problemMessage));
            getBlueprintsFuture.thenAccept(result -> {
                if (result == null) {
                    blueprintNames.complete(Collections.emptyList());
                } else {
                    blueprintNames.complete(result.blueprintNames);
                }
            });
        });
        try {
            return (List)blueprintNames.get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            AIUtils.getInstance().writeToAiConsole(LogTarget.AI_CONSOLE, "Problem Auto-correct Error: No blueprint was found!", LogSeverity.ERROR, "Problem Auto-correct Error: No blueprint was found!");
            return Collections.emptyList();
        }
        catch (InterruptedException | ExecutionException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> getVerissimoBlueprintsForHit(String ruleName) {
        CompletableFuture blueprintNames = new CompletableFuture();
        AIManager.getInstance().thenAccept(aiManager -> {
            CompletableFuture<GetVerissimoBlueprintsForHitResponse> getBlueprintsFuture = aiManager.getHost().getCore().getVerissimoBlueprintsForHit(new GetVerissimoBlueprintsForHitParams(ruleName));
            getBlueprintsFuture.thenAccept(result -> {
                if (result == null) {
                    blueprintNames.complete(Collections.emptyList());
                } else {
                    blueprintNames.complete(result.blueprintNames);
                }
            });
        });
        try {
            return (List)blueprintNames.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    public void autocorrectProblem(IMarker marker, String filePath, String blueprintName) {
        ProblemInfo problemInfo = AIUtils.getInstance().getProblemInfoFromMarker(marker, filePath);
        if (problemInfo == null) {
            return;
        }
        AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().autocorrectProblem(new ProblemAutocorrectParams(blueprintName, new ProblemAutocorrectArgs(problemInfo, null))));
    }

    public Object autocorrectVerissimoHit(List<?> verissimoHitsInfo, BooleanSupplier isCanceled, String blueprintName) {
        if (verissimoHitsInfo == null || verissimoHitsInfo.isEmpty()) {
            return null;
        }
        List listOfHits = verissimoHitsInfo.stream().map(OVMComplianceCheckHit.class::cast).collect(Collectors.toList());
        ArrayList<VerissimoFailureInfo> hitsInfo = new ArrayList<VerissimoFailureInfo>();
        for (OVMComplianceCheckHit hit : listOfHits) {
            VerissimoFailureInfo hitInfo = AIUtils.getInstance().getVerissimoHitInfoFromCheckHit(hit);
            if (hitInfo == null) continue;
            hitsInfo.add(hitInfo);
        }
        VerissimoCheckInfo checkInfo = AIUtils.getInstance().getVerissimoCheckInfoFromHit((OVMComplianceCheckHit)listOfHits.get(0));
        if (checkInfo == null) {
            return null;
        }
        VerissimoFailureAdditionalInformation additionalInformation = AIUtils.getInstance().getVerissimoAdditionalInformationFromCheckHit((OVMComplianceCheckHit)listOfHits.get(0));
        if (additionalInformation == null) {
            return null;
        }
        CompletableFuture autocorrectVerissimoHitResponseFuture = new CompletableFuture();
        AIManager.getInstance().thenAccept(aiManager -> {
            CompletableFuture<AutocorrectVerissimoFailureResponse> autocorrectVerissimoHitFuture = aiManager.getHost().getCore().autocorrectVerissimoHit(new AutocorrectVerissimoFailureParams(blueprintName, new VerissimoFailureAutocorrectArgs(hitsInfo, checkInfo, additionalInformation)));
            while (true) {
                if (isCanceled.getAsBoolean()) {
                    autocorrectVerissimoHitFuture.cancel(true);
                    break;
                }
                if (autocorrectVerissimoHitFuture.isDone()) {
                    try {
                        autocorrectVerissimoHitResponseFuture.complete(autocorrectVerissimoHitFuture.get());
                        break;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
        try {
            AutocorrectVerissimoFailureResponse autocorrectVerissimoHitResponse = (AutocorrectVerissimoFailureResponse)autocorrectVerissimoHitResponseFuture.get(100L, TimeUnit.MILLISECONDS);
            return autocorrectVerissimoHitResponse.getFileEdits().stream().map(edit -> new VerissimoAutofixManagerCommon.AIAutofixEdit(edit.getStartLine(), edit.getEndLine(), edit.getCode(), edit.getFilePath())).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            return null;
        }
    }

    public void explainProblem(IMarker marker, String filePath) {
        ProblemInfo problemInfo = AIUtils.getInstance().getProblemInfoFromMarker(marker, filePath);
        if (problemInfo == null) {
            return;
        }
        AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().explainProblem(new ProblemExplainParams(new ProblemExplainArgs(problemInfo))));
    }

    public void explainVerissimoHit(Object verissimoInfo) {
        if (!(verissimoInfo instanceof OVMComplianceCheckHit)) {
            return;
        }
        OVMComplianceCheckHit verissimoHitInfo = (OVMComplianceCheckHit)verissimoInfo;
        VerissimoFailureInfo verissimoHitInfoFromCheckHit = AIUtils.getInstance().getVerissimoHitInfoFromCheckHit(verissimoHitInfo);
        if (verissimoHitInfoFromCheckHit == null) {
            return;
        }
        VerissimoFailureAdditionalInformation additionalInformation = AIUtils.getInstance().getVerissimoAdditionalInformationFromCheckHit(verissimoHitInfo);
        if (additionalInformation == null) {
            return;
        }
        VerissimoCheckInfo checkInfo = AIUtils.getInstance().getVerissimoCheckInfoFromHit(verissimoHitInfo);
        if (checkInfo == null) {
            return;
        }
        AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().explainVerissimoHit(new VerissimoFailureExplainParams(new VerissimoFailureExplainArgs(verissimoHitInfoFromCheckHit, checkInfo, additionalInformation))));
    }

    public void generateSpecadorLivePreviewDescription(IRfNamedElement namedElement, String message) {
        if (namedElement == null) {
            return;
        }
        String[] parts = message.split(" ", 2);
        String kind = parts.length > 0 ? parts[0] : "";
        String name = parts.length > 1 ? parts[1] : namedElement.getName();
        AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().generateSpecadorDescription(new SpecadorLivePreviewArgs(kind, name, namedElement.getDeclaration().getFileAdapter().getName())));
    }

    public void improveSpecadorLivePreviewDescription(IRfNamedElement namedElement, String userPrompt, String userDescription) {
        if (namedElement == null) {
            return;
        }
        AIManager.getInstance().thenAccept(aiManager -> {
            SpecadorLivePreviewArgs args = new SpecadorLivePreviewArgs();
            args.elementKind = namedElement.getKindName();
            args.elementName = namedElement.getName();
            args.filename = namedElement.getDeclaration().getFileAdapter().getName();
            args.userDescription = userDescription;
            args.userPrompt = userPrompt;
            aiManager.getHost().getCore().generateSpecadorDescription(args);
        });
    }

    public void stopSpecadorLivePreviewDescription(long sessionId, long messageId) {
        ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().assistantMessageStreamCancel(new AssistantMessageParams(messageId, sessionId)))).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }

    public File getMcpLogsDir() {
        return McpEndpointLogger.INSTANCE.getLogsDir();
    }

    public File getMcpRegistryDir() {
        return McpEndpointLogger.INSTANCE.getRegistryDir();
    }

    public void invalidateAIToolsRegistryCache() {
        AIToolsRegistryCommon.invalidateToolsCache();
    }

    private DVTPair<Integer, Integer> processLines(Object[] message) {
        int endLine;
        int startLine = Integer.parseInt((String)message[1]);
        try {
            endLine = Integer.parseInt((String)message[2]);
        }
        catch (NumberFormatException numberFormatException) {
            endLine = startLine;
        }
        return new DVTPair((Object)startLine, (Object)endLine);
    }

    private String getFinalComment(String newComment, String commentMarker, String original, int existingCommentIndex, boolean insertAbove) {
        if (newComment.isBlank()) {
            return "";
        }
        newComment = NEW_LINE.matcher(newComment).replaceAll("\n" + commentMarker + " ");
        String finalComment = String.valueOf(commentMarker) + (newComment.charAt(0) == ' ' ? "" : " ") + newComment;
        if (existingCommentIndex == -1 && !newComment.contains("\n") && original.length() > 0 && original.charAt(original.length() - 1) != ' ') {
            finalComment = " " + finalComment;
        }
        if (insertAbove) {
            finalComment = "\n" + finalComment;
        }
        return finalComment;
    }

    private String getOriginalText(IDocument document, int startLine, int endLine) throws BadLocationException {
        if (document == null) {
            return "";
        }
        int totalLength = 0;
        int line = startLine;
        while (line <= endLine) {
            totalLength += document.getLineLength(line - 1);
            ++line;
        }
        return document.get(document.getLineOffset(startLine - 1), totalLength - 1);
    }

    public void saveSpecadorLivePreviewDescriptions(IRfNamedElement element, Object[] messages, SpecadorModel model) {
        ArrayList<FileEdit> edits = new ArrayList<FileEdit>();
        if (element == null) {
            return;
        }
        IFreeMarkerWrapper wrapper = LanguageContributor.get((LanguageKind)element.getLanguageKind()).getWrapper(element);
        if (wrapper == null || messages.length == 0) {
            return;
        }
        IRfDefElement declaration = element.getDeclaration();
        if (declaration == null) {
            return;
        }
        IDocument document = declaration.getDefFile().getDocument();
        if (document == null) {
            return;
        }
        String commentMarker = declaration.getLanguageKind().equals((Object)LanguageKind.VLOG) ? "//" : "--";
        try {
            Object[] objectArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                block13: {
                    Optional<FileEdit> editSameLine;
                    int existingCommentIndex;
                    String original;
                    boolean insertAbove;
                    int endLine;
                    int startLine;
                    String newComment;
                    block15: {
                        block14: {
                            Object messageObject = objectArray[n2];
                            Object[] message = (Object[])messageObject;
                            newComment = (String)message[0];
                            if (message[1] == null) break block13;
                            DVTPair<Integer, Integer> lines = this.processLines(message);
                            startLine = (Integer)lines.getKey();
                            endLine = (Integer)lines.getValue();
                            insertAbove = Boolean.parseBoolean((String)message[3]);
                            original = this.getOriginalText(document, startLine, endLine);
                            existingCommentIndex = original.indexOf(commentMarker);
                            if (existingCommentIndex <= -1) break block14;
                            original = original.substring(0, existingCommentIndex);
                            break block15;
                        }
                        if (existingCommentIndex == -1 && newComment.isBlank()) break block13;
                    }
                    if (!insertAbove && startLine == declaration.getStartLine()) {
                        original = PARENTHESIS.matcher(original).replaceFirst("\\(\n  ");
                    }
                    if ((editSameLine = edits.stream().filter(edit -> edit.getStartLine() == startLine).findFirst()).isPresent()) {
                        FileEdit existingEdit = editSameLine.get();
                        String editCode = existingEdit.getCode();
                        int previousCommentIndex = editCode.lastIndexOf(commentMarker);
                        String previousComment = editCode.substring(previousCommentIndex);
                        editCode = editCode.substring(0, previousCommentIndex);
                        editCode = COMMA_OR_SEMICOLON.matcher(editCode).replaceFirst("$1 " + previousComment + "\n");
                        editCode = String.valueOf(editCode) + this.getFinalComment(newComment, commentMarker, editCode, existingCommentIndex, insertAbove);
                        existingEdit.setCode(editCode);
                    } else {
                        FileEdit fileEdit = new FileEdit(declaration.getParserPath().toString(), startLine, endLine, String.valueOf(original) + this.getFinalComment(newComment, commentMarker, original, existingCommentIndex, insertAbove));
                        edits.add(fileEdit);
                    }
                }
                ++n2;
            }
            ApplyFileEditsParams params = new ApplyFileEditsParams(edits, true);
            ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().applyFileEdits(params))).exceptionally(ex -> {
                DVTLogger.INSTANCE.logError(ex);
                return null;
            });
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

