/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.contributor;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.contributor.EAIContributor;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.contributor.MSDLAIContributor;
import ro.amiq.dvt.ai.contributor.PSSAIContributor;
import ro.amiq.dvt.ai.contributor.SLNAIContributor;
import ro.amiq.dvt.ai.contributor.VhdlAIContributor;
import ro.amiq.dvt.ai.contributor.VlogAIContributor;

public enum AILangContributorManager {
    INSTANCE;

    private final List<IAILangContributor> contributors = new ArrayList<IAILangContributor>();

    public List<IAILangContributor> getContributors() {
        if (!this.contributors.isEmpty()) {
            return this.contributors;
        }
        this.contributors.add(new VlogAIContributor());
        this.contributors.add(new VhdlAIContributor());
        this.contributors.add(new EAIContributor());
        this.contributors.add(new SLNAIContributor());
        this.contributors.add(new MSDLAIContributor());
        this.contributors.add(new PSSAIContributor());
        return this.contributors;
    }

    public IAILangContributor getContributor(LanguageKind language) {
        if (language == null) {
            return null;
        }
        for (IAILangContributor contributor : this.getContributors()) {
            if (!language.equals((Object)contributor.getLanguage())) continue;
            return contributor;
        }
        return null;
    }
}

