/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.contributor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIExpansionUtils;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.DependencySource;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.EditorRange;
import ro.amiq.dvt.ai.model.SnippetSelectionType;
import ro.amiq.dvt.ai.model.TreeElement;
import ro.amiq.dvt.ai.search.constraints.ConstraintsSearchQuery;
import ro.amiq.dvt.ai.tools.GetFieldConstraintsAITool;
import ro.amiq.dvt.model.reflection.IRfDefContainer;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTCompileOrderGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfArgLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.RfVarLayer;
import ro.amiq.edt.base.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkspaceActionCommon;
import ro.amiq.edt.base.ui.editor.lazy.outline.EOutlineUtil;
import ro.amiq.edt.base.ui.search.ReferenceSearchQuery;
import ro.amiq.edt.base.ui.search.text.FileSearchResult;
import ro.amiq.edt.core.EPluginConfig;

public abstract class EAIContributorCommon
implements IAILangContributor {
    private static final Set<Class<?>> E_CONTAINER_TYPES = new HashSet<Class>(Arrays.asList(RfStructLayer.class, RfModule.class, RfMethodLayer.class, RfStruct.class));
    private static final Set<Class<?>> E_CONTAINER_TYPES_WITHOUT_METHODS = new HashSet<Class>(Arrays.asList(RfStructLayer.class, RfModule.class, RfStruct.class));

    @Override
    public IDVTElementWrapper getOutlineWrapper(IRfDefContainer rootDef) {
        RfTreeElementWrapper root = new RfTreeElementWrapper((Object)rootDef, true);
        Collection children = rootDef.getChildren();
        this.addElements((IDVTElementWrapper)root, children);
        return root;
    }

    private void addElements(IDVTElementWrapper root, Collection<RfDefElement> childrenDef) {
        if (childrenDef == null) {
            return;
        }
        for (RfDefElement elementDef : childrenDef) {
            if (elementDef.getChildren() == childrenDef || !EOutlineUtil.INSTANCE.isOutlineElement((IRfDefElement)elementDef)) continue;
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper((Object)elementDef, true);
            root.addChild((IDVTElementWrapper)wrapper);
            if (!EOutlineUtil.INSTANCE.isPossibleOutlineParent((IRfDefElement)elementDef)) continue;
            this.addElements((IDVTElementWrapper)wrapper, elementDef.getChildren());
        }
    }

    @Override
    public LanguageKind getLanguage() {
        return LanguageKind.E;
    }

    @Override
    public boolean isSymbolFiltered(IDVTElementWrapper elementWrapper) {
        return RfStruct.isPackageElement((Object)elementWrapper.getRfElement(), (boolean)false);
    }

    @Override
    public List<CodeSnippet> expandNamedElement(IRfNamedElement element) {
        RfNamedElement namedElement = (RfNamedElement)element;
        ArrayList<CodeSnippet> results = new ArrayList<CodeSnippet>();
        HashSet<DefinitionLocation> expandedDefinitionLocations = new HashSet<DefinitionLocation>();
        IRfSingleLangProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return results;
        }
        for (RfDefElement layer : namedElement.getLayers()) {
            CodeSnippet layerExpansion;
            DefinitionLocation defLocation;
            int startOffset = layer.getStartOffset();
            int endOffset = layer.getEndOffset();
            ParserPath parserPath = layer.getParserPath();
            if (parserPath == null || parserPath.path == null || AIProtectManager.INSTANCE.isFileProtected(parserPath.path, rfProject.getProject()) || !expandedDefinitionLocations.add(defLocation = new DefinitionLocation(startOffset, endOffset, parserPath)) || (layerExpansion = AIExpansionUtils.INSTANCE.expandDefElement((IRfDefElement)layer, null, false, true)) == null) continue;
            results.add(layerExpansion);
        }
        return results;
    }

    @Override
    public Set<Class<?>> getAcceptedContainers(SnippetSelectionType selectionType) {
        if (selectionType == null) {
            return null;
        }
        switch (selectionType) {
            case CONTAINER: {
                return E_CONTAINER_TYPES;
            }
            case ACTION_BLOCK: {
                return new HashSet(Arrays.asList(RfActionBlockLayer.class));
            }
            case METHOD: {
                return new HashSet(Arrays.asList(RfMethodLayer.class));
            }
            case ELEMENT: {
                return new HashSet(Arrays.asList(RfDefElement.class));
            }
            case CLASS: 
            case INTERFACE: 
            case UNIT: 
            case STRUCT: {
                return new HashSet(Arrays.asList(RfStructLayer.class, RfStruct.class));
            }
        }
        return null;
    }

    @Override
    public Set<Class<?>> getAllContainersExceptMethods() {
        return E_CONTAINER_TYPES_WITHOUT_METHODS;
    }

    @Override
    public List<GetFieldConstraintsAITool.ConstraintLocation> computeConstraints(IRfNamedElement iNamedElement) {
        RfNamedElement namedElement = this.findNamedElement(iNamedElement);
        if (namedElement == null) {
            return null;
        }
        ConstraintsSearchQuery query = new ConstraintsSearchQuery(namedElement);
        return query.run();
    }

    private RfNamedElement findNamedElement(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return null;
        }
        if (namedElement instanceof RfDefElement) {
            namedElement = ((RfDefElement)namedElement).getNamedElement();
        }
        if (!(namedElement instanceof RfField)) {
            return null;
        }
        return (RfNamedElement)namedElement;
    }

    @Override
    public void computeReferences(Set<EditorRange> usages, IRfNamedElement namedElement, IProject project) {
        if (project == null) {
            return;
        }
        if (!(namedElement instanceof RfNamedElement)) {
            return;
        }
        try {
            Object[] elements;
            RfNamedElement rfNamedElement = (RfNamedElement)namedElement;
            String[] fileExtensions = BaseReferencesInWorkspaceAction.getFileExtensions((IProject)project);
            String kindName = rfNamedElement.getKindName();
            if (kindName == null) {
                return;
            }
            String searchType = String.valueOf(kindName.substring(0, 1).toUpperCase()) + kindName.substring(1);
            EPluginConfig pluginConfig = EPluginConfig.getInstance();
            String fullNameLabel = rfNamedElement.getFullNameLabel();
            FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
            int searchTypeConstant = ReferencesInWorkspaceActionCommon.getSearchTypeConstant((RfNamedElement)rfNamedElement);
            ReferenceSearchQuery searchQuery = new ReferenceSearchQuery((IEPluginConfig)pluginConfig, project, searchType, (IRfNamedElement)rfNamedElement, fullNameLabel, false, true, true, searchScope, 1, false, searchTypeConstant);
            searchQuery.run((IProgressMonitor)new NullProgressMonitor());
            ISearchResult searchResult = searchQuery.getSearchResult();
            if (!(searchResult instanceof FileSearchResult)) {
                return;
            }
            FileSearchResult fileSearchResult = (FileSearchResult)searchResult;
            Object[] objectArray = elements = fileSearchResult.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IFile) {
                    Match[] matches;
                    IFile file = (IFile)element;
                    Match[] matchArray = matches = fileSearchResult.getMatches((Object)file);
                    int n3 = matches.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Match match = matchArray[n4];
                        usages.add(new EditorRange(file, match.getOffset(), match.getOffset() + match.getLength()));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public List<IRfDefElement> getContainersInFile(String fullPath, IProject iProject, boolean allowExternFunctions) {
        if (iProject == null) {
            return null;
        }
        IRfSingleLangProject iRfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.E.NATURE_ID, false);
        if (!(iRfProject instanceof RfProject)) {
            return null;
        }
        RfModule module = ((RfProject)iRfProject).getModule(new ParserPath(fullPath));
        if (module == null) {
            return null;
        }
        return new ArrayList<IRfDefElement>(module.getChildren());
    }

    @Override
    public List<DependencySource> getContainerDependencySources(IRfDefElement container, EditorPosition cursorPosition, BooleanSupplier isCanceled) {
        if (!(container instanceof RfStructLayer)) {
            return null;
        }
        RfStructLayer structLayer = (RfStructLayer)container;
        HashMap<IRfDefElement, Integer> dependencyToDistance = new HashMap<IRfDefElement, Integer>();
        for (RfDefElement memberLayer : structLayer.getChildren()) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            RfNamedElement member = memberLayer.getNamedElement();
            if (member == null) continue;
            if (member instanceof RfStructMember) {
                this.addRfTypeAsDependency(((RfStructMember)member).getAssociatedType(), dependencyToDistance, AIUtils.getInstance().getNamedElementDistanceToCursor((IRfNamedElement)member, cursorPosition));
            }
            if (!(memberLayer instanceof RfMethodLayer)) continue;
            RfMethodLayer methodLayer = (RfMethodLayer)memberLayer;
            List arguments = methodLayer.getArgs();
            for (RfArgLayer argLayer : arguments) {
                AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
                RfArg argument = argLayer.getArgument();
                if (argument == null) continue;
                this.addRfTypeAsDependency(argument.getAssociatedType(), dependencyToDistance, AIUtils.getInstance().getNamedElementDistanceToCursor((IRfNamedElement)argument, cursorPosition));
            }
            List methodChildren = methodLayer.getChildren();
            for (RfDefElement methodChild : methodChildren) {
                AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
                if (methodChild instanceof RfVarLayer) {
                    RfVar localVar = ((RfVarLayer)methodChild).getVariable();
                    this.addRfTypeAsDependency(localVar.getAssociatedType(), dependencyToDistance, AIUtils.getInstance().getNamedElementDistanceToCursor((IRfNamedElement)localVar, cursorPosition));
                }
                if (!(methodChild instanceof RfActionBlockLayer)) continue;
                for (RfDefElement actionBlockChild : methodChild.getChildren()) {
                    if (!(actionBlockChild instanceof RfVarLayer)) continue;
                    RfVar localVar = ((RfVarLayer)actionBlockChild).getVariable();
                    this.addRfTypeAsDependency(localVar.getAssociatedType(), dependencyToDistance, AIUtils.getInstance().getNamedElementDistanceToCursor((IRfNamedElement)localVar, cursorPosition));
                }
            }
        }
        ArrayList<DependencySource> results = new ArrayList<DependencySource>();
        for (Map.Entry entry : dependencyToDistance.entrySet()) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            IRfDefElement defElement = (IRfDefElement)entry.getKey();
            results.add(new DependencySource(false, false, null, defElement, (Integer)entry.getValue()));
        }
        this.sortDependencySources(results);
        return results;
    }

    private void addRfTypeAsDependency(RfType rfType, Map<IRfDefElement, Integer> dependencyToDistance, int distance) {
        if (rfType == null) {
            return;
        }
        if (rfType instanceof RfListType) {
            rfType = ((RfListType)rfType).get_element_type();
        }
        if (rfType == null || rfType.isPredefined()) {
            return;
        }
        RfDefElement declaration = rfType.getDeclaration();
        if (declaration == null) {
            return;
        }
        int prevDistance = dependencyToDistance.getOrDefault(declaration, Integer.MAX_VALUE);
        int newDistance = Integer.min(distance, prevDistance);
        dependencyToDistance.put((IRfDefElement)declaration, newDistance);
    }

    @Override
    public boolean isSymbolFile(IDVTElementWrapper elementWrapper) {
        if (elementWrapper == null) {
            return false;
        }
        return elementWrapper.getRfElement() instanceof RfModule;
    }

    @Override
    public ParserPath getFileSymbolParserPath(IDVTElementWrapper elementWrapper) {
        if (elementWrapper == null) {
            return null;
        }
        RfModule rfModule = (RfModule)elementWrapper.getRfElement(RfModule.class);
        if (rfModule == null) {
            return null;
        }
        return rfModule.getParserPath();
    }

    @Override
    public boolean areDefElementsEqual(IRfDefElement defElement1, IRfDefElement defElement2) {
        if (!(defElement1 instanceof RfStructLayer) || !(defElement2 instanceof RfStructLayer)) {
            return IAILangContributor.super.areDefElementsEqual(defElement1, defElement2);
        }
        RfStructLayer layer1 = (RfStructLayer)defElement1;
        RfStructLayer layer2 = (RfStructLayer)defElement2;
        return layer1.getInfo().equals(layer2.getInfo()) && layer1.isLike() == layer2.isLike() && layer1.isExtend() == layer2.isExtend() && layer1.isUnit() == layer2.isUnit() && layer1.isWhen() == layer2.isWhen() && layer1.isIs() == layer2.isIs();
    }

    @Override
    public List<TreeElement> getCompiledFilesTree(IProject iProject) {
        if (iProject == null) {
            return null;
        }
        IRfSingleLangProject iRfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.E.NATURE_ID, false);
        if (!(iRfProject instanceof RfProject)) {
            return null;
        }
        RfProject rfProject = (RfProject)iRfProject;
        List<RfModule> files = Arrays.asList(rfProject.getImportedModules());
        if (files.isEmpty()) {
            return null;
        }
        ArrayList<TreeElement> result = new ArrayList<TreeElement>();
        for (RfModule file : files) {
            DVTGUIFilterMatcher.GUIFilterResult filterElement;
            ParserPath parserPath = file.getParserPath();
            if (parserPath == null || parserPath.path == null || (filterElement = DVTCompileOrderGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COMPILE_ORDER, (IProject)iProject, (IRfFileDef)file, null)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
            result.add(new TreeElement(parserPath.path, null));
        }
        return result;
    }

    @Override
    public IRfKind getDefElementKind(IRfDefElement element) {
        RfKind of = RfKind.of((IRfNamedElement)element.getNamedElement());
        if (of == null || of.equals((Object)RfKind.UNKNOWN)) {
            return null;
        }
        return of;
    }

    private static class DefinitionLocation {
        public int startOffset;
        public int endOffset;
        public ParserPath parserPath;

        DefinitionLocation(int startOffset, int endOffset, ParserPath parserPath) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.parserPath = parserPath;
        }

        public int hashCode() {
            return Objects.hash(this.startOffset, this.endOffset, this.parserPath);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefinitionLocation other = (DefinitionLocation)obj;
            return this.startOffset == other.startOffset && this.endOffset == other.endOffset && Objects.equals(this.parserPath, other.parserPath);
        }
    }
}

