/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.contributor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIExpansionUtils;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.DependencySource;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.EditorRange;
import ro.amiq.dvt.ai.model.SnippetSelectionType;
import ro.amiq.dvt.ai.model.TreeElement;
import ro.amiq.dvt.ai.tools.GetFieldConstraintsAITool;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefContainer;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfInterface;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTSearchGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public interface IAILangContributor {
    public static final Set<Class<?>> CONTAINER_TYPES = new HashSet<Class>(Arrays.asList(IRfDesignElement.class, IRfEntityComplement.class, IRfClassElement.class, IRfPackageElement.class, IRfMethodElement.class, IRfTypeAliasElement.class, IRfCompositeTypeElement.class, IRfEnumElement.class));
    public static final Set<Class<?>> CONTAINER_TYPES_WITHOUT_METHODS = new HashSet<Class>(Arrays.asList(IRfDesignElement.class, IRfEntityComplement.class, IRfClassElement.class, IRfTypeAliasElement.class, IRfPackageElement.class, IRfCompositeTypeElement.class, IRfEnumElement.class));
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$ai$model$SnippetSelectionType;

    static {
        $SWITCH_TABLE$ro$amiq$dvt$ai$model$SnippetSelectionType = IAILangContributor.$SWITCH_TABLE$ro$amiq$dvt$ai$model$SnippetSelectionType();
    }

    public IDVTElementWrapper getOutlineWrapper(IRfDefContainer var1);

    public LanguageKind getLanguage();

    default public boolean isSymbolFiltered(IDVTElementWrapper elementWrapper) {
        return false;
    }

    default public CodeSnippet expandMacro(IMacroInfo macroInfo) {
        return null;
    }

    default public List<IRfDefElement> getContainersInFile(String fullPath, IProject iProject, boolean allowExternFunctions) {
        return null;
    }

    default public List<CodeSnippet> getAdditionalExpansionsForDefElement(IRfDefElement defElement, DVTEditor editor, boolean formatCode) {
        return null;
    }

    default public List<DependencySource> getContainerDependencySources(IRfDefElement container, EditorPosition cursorPosition, BooleanSupplier isCanceled) {
        return null;
    }

    default public boolean isSymbolFile(IDVTElementWrapper elementWrapper) {
        if (elementWrapper == null) {
            return false;
        }
        return elementWrapper.getRfElement() instanceof IDVTFileInstance;
    }

    default public ParserPath getFileSymbolParserPath(IDVTElementWrapper elementWrapper) {
        if (elementWrapper == null) {
            return null;
        }
        IDVTFileInstance fileInstance = (IDVTFileInstance)elementWrapper.getRfElement(IDVTFileInstance.class);
        if (fileInstance == null) {
            return null;
        }
        return fileInstance.getParserPath();
    }

    default public ILabelProvider getVhElementLabelProvider(DVTEditor editor) {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return element.toString();
            }
        };
    }

    default public IRfKind getDefElementKind(IRfDefElement element) {
        return null;
    }

    default public List<TreeElement> getAdditionalOutlinesForDefElement(IRfDefElement defElement) {
        return null;
    }

    default public Set<Class<?>> getAllContainersExceptMethods() {
        return CONTAINER_TYPES_WITHOUT_METHODS;
    }

    default public List<TreeElement> getCompiledFilesTree(IProject iProject) {
        return null;
    }

    default public List<CodeSnippet> expandNamedElement(IRfNamedElement element) {
        CodeSnippet result;
        if (element instanceof IRfAssociatedTypeElement && !(element instanceof IRfEntityComplement)) {
            IRfNamedElement associatedType = ((IRfAssociatedTypeElement)element).getAssociatedType();
            if (associatedType instanceof IRfListType) {
                CodeSnippet result2 = AIExpansionUtils.INSTANCE.expandArrayTypedef((IRfAssociatedTypeElement)element);
                if (result2 == null) {
                    return null;
                }
                return new ArrayList<CodeSnippet>(Arrays.asList(result2));
            }
            if (associatedType != null) {
                return this.expandNamedElement(associatedType);
            }
        }
        if ((result = AIExpansionUtils.INSTANCE.getImplementationOrDeclarationExpandedForElement(element.getDeclaration(), null, false, true)) == null) {
            return null;
        }
        return new ArrayList<CodeSnippet>(Arrays.asList(result));
    }

    default public Set<Class<?>> getAcceptedContainers(SnippetSelectionType selectionType) {
        if (selectionType == null) {
            return null;
        }
        switch (selectionType) {
            case CONTAINER: {
                return CONTAINER_TYPES;
            }
            case STRUCT: {
                return new HashSet(Arrays.asList(IRfEnumElement.class));
            }
            case CLASS: {
                return new HashSet(Arrays.asList(IRfClassElement.class));
            }
            case MODULE: 
            case ENTITY: {
                return new HashSet(Arrays.asList(IRfDesignElement.class));
            }
            case ACTION_BLOCK: {
                return new HashSet(Arrays.asList(IRfActionBlockElement.class));
            }
            case METHOD: {
                return new HashSet(Arrays.asList(IRfMethodElement.class));
            }
            case INTERFACE: {
                return new HashSet(Arrays.asList(IRfInterface.class));
            }
            case PACKAGE: {
                return new HashSet(Arrays.asList(IRfPackageElement.class));
            }
            case ARCHITECTURE: {
                return new HashSet(Arrays.asList(IRfEntityComplement.class));
            }
            case CONFIGURATION: {
                return new HashSet(Arrays.asList(IRfEntityComplement.class, IRfConfiguration.class));
            }
            case ELEMENT: {
                return new HashSet(Arrays.asList(IRfNamedElement.class));
            }
        }
        return null;
    }

    default public List<GetFieldConstraintsAITool.ConstraintLocation> computeConstraints(IRfNamedElement namedElement) {
        return null;
    }

    default public void computeReferences(final Set<EditorRange> usages, IRfNamedElement namedElement, IProject project) {
        String searchedString = null;
        searchedString = namedElement.getName();
        NullProgressMonitor monitor = new NullProgressMonitor();
        final HashSet alreadyReportedMatches = new HashSet();
        HashMap searchedFiles = new HashMap();
        FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(RfReferencesUtils.getSearchedFiles(searchedFiles), (IProgressMonitor)monitor);
        IReportHitsListener<SearchHit> reportHitsListener = new IReportHitsListener<SearchHit>(){

            public void addMatch(SearchHit match) {
                if (alreadyReportedMatches.contains(match)) {
                    return;
                }
                IProject project = match.getProject();
                if (project == null) {
                    return;
                }
                ParserPath parserPath = match.getParserPath();
                if (parserPath == null) {
                    return;
                }
                DVTGUIFilterMatcher.GUIFilterResult isFiltered = DVTSearchGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.SEARCH, (String)parserPath.path, (String)match.getContents(), (IProject)project);
                if (isFiltered != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    return;
                }
                IFile file = DVTFileUtils.getInstance().findProjectFile(project, parserPath.path);
                if (file == null) {
                    return;
                }
                alreadyReportedMatches.add(match);
                usages.add(new EditorRange(file, match.getOffset(), match.getOffset() + match.getMatchLength()));
            }

            public Set<SearchHit> getMatches() {
                return null;
            }
        };
        RfSearchUtils.computeReferences((IReportHitsListener)reportHitsListener, (IProject)project, (IRfNamedElement)namedElement, null, (String)searchedString, (IProgressMonitor)monitor, searchedFiles, (FileSynchedAndAvailableManager)fileManager, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
    }

    default public void sortDependencySources(List<DependencySource> dependencySources) {
        dependencySources.sort((depSource1, depSource2) -> {
            int distance2;
            int distance1 = depSource1.getDistanceToCursor();
            if (distance1 != (distance2 = depSource2.getDistanceToCursor())) {
                return Integer.compare(distance1, distance2);
            }
            boolean isMacro1 = depSource1.isMacro();
            boolean isMacro2 = depSource2.isMacro();
            if (isMacro1 && isMacro2) {
                return depSource1.getMacroDefinition().getCode().compareTo(depSource2.getMacroDefinition().getCode());
            }
            if (isMacro1) {
                return 1;
            }
            if (isMacro2) {
                return -1;
            }
            IRfDefElement defElement1 = depSource1.getDefElement();
            IRfDefElement defElement2 = depSource2.getDefElement();
            if (defElement1 == null || defElement2 == null) {
                return 0;
            }
            String name1 = defElement1.getName();
            String name2 = defElement2.getName();
            if (name1 == null || name2 == null) {
                return 0;
            }
            return name1.compareTo(name2);
        });
    }

    default public boolean areDefElementsEqual(IRfDefElement defElement1, IRfDefElement defElement2) {
        IRfNamedElement namedElement1 = defElement1.getNamedElement();
        IRfNamedElement namedElement2 = defElement2.getNamedElement();
        return namedElement1 != null && namedElement1.equals(namedElement2);
    }
}

