/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.contributor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIExpansionUtils;
import ro.amiq.dvt.ai.AISnippetSolver;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.DependencySource;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.TreeElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefContainer;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTCompileOrderGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.parser.VhdlFileInstance;
import ro.amiq.vhdldt.ui.editor.lazy.outline.VhdlOutlineUtil;

public class VhdlAIContributor
implements IAILangContributor {
    @Override
    public IDVTElementWrapper getOutlineWrapper(IRfDefContainer rootDef) {
        RfTreeElementWrapper root = new RfTreeElementWrapper((Object)rootDef, true);
        if (!(rootDef instanceof IRfDefElement)) {
            return root;
        }
        this.addElements((IDVTElementWrapper)root, (IRfDefElement)rootDef);
        return root;
    }

    private void addElements(IDVTElementWrapper root, IRfDefElement iRootDef) {
        if (!(iRootDef instanceof RfDefElement)) {
            return;
        }
        RfDefElement rootDef = (RfDefElement)iRootDef;
        Collection childrenDef = rootDef.getChildren();
        if (childrenDef == null) {
            return;
        }
        for (RfDefElement elementDef : childrenDef) {
            if (elementDef.getChildren() == childrenDef || !VhdlOutlineUtil.INSTANCE.isOutlineElement((IRfDefElement)elementDef)) continue;
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper((Object)elementDef, true);
            root.addChild((IDVTElementWrapper)wrapper);
            if (!VhdlOutlineUtil.INSTANCE.isPossibleOutlineParent((IRfDefElement)elementDef)) continue;
            this.addElements((IDVTElementWrapper)wrapper, (IRfDefElement)elementDef);
        }
    }

    @Override
    public LanguageKind getLanguage() {
        return LanguageKind.VHDL;
    }

    @Override
    public List<IRfDefElement> getContainersInFile(String fullPath, IProject iProject, boolean allowExternFunctions) {
        if (iProject == null) {
            return null;
        }
        IRfSingleLangProject iRfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.VHDL.NATURE_ID, false);
        if (!(iRfProject instanceof RfProject)) {
            return null;
        }
        RfFileDef fileDef = ((RfProject)iRfProject).getFile(new ParserPath(fullPath));
        if (fileDef == null) {
            return null;
        }
        return new ArrayList<IRfDefElement>(fileDef.getChildren());
    }

    @Override
    public List<DependencySource> getContainerDependencySources(IRfDefElement container, EditorPosition cursorPosition, BooleanSupplier isCanceled) {
        RfPackage rfPackage;
        RfPackageBody rfPackageBody;
        List list;
        RfEntity rfEntity;
        IRfNamedElement namedElement = container.getNamedElement();
        if (!(namedElement instanceof RfNamedElement)) {
            return null;
        }
        RfNamedElement rfNamedElement = (RfNamedElement)namedElement;
        HashMap<IRfDefElement, Integer> dependencyToDistance = new HashMap<IRfDefElement, Integer>();
        List localMembers = rfNamedElement.getLocalMembers(true, IRfNamedElement.class);
        if (localMembers != null) {
            for (IRfNamedElement localMember : localMembers) {
                AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
                if (!(localMember instanceof IRfAssociatedType)) continue;
                AIUtils.getInstance().addAssociatedTypeAsDependency((IRfAssociatedTypeElement)((IRfAssociatedType)localMember), namedElement, dependencyToDistance, AIUtils.getInstance().getNamedElementDistanceToCursor(localMember, cursorPosition));
                if (!(localMember instanceof RfFunction)) continue;
                List arguments = ((RfFunction)localMember).getArguments();
                Iterator iterator = arguments.iterator();
                while (iterator.hasNext()) {
                    IRfFieldElement argument = (IRfFieldElement)iterator.next();
                    AIUtils.getInstance().addAssociatedTypeAsDependency((IRfAssociatedTypeElement)argument, namedElement, dependencyToDistance, AIUtils.getInstance().getNamedElementDistanceToCursor((IRfNamedElement)argument, cursorPosition));
                }
                List functionLocalMembers = ((RfFunction)localMember).getLocalMembers(false, IRfNamedElement.class);
                if (functionLocalMembers == null) continue;
                AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
                for (IRfNamedElement functionLocalMember : functionLocalMembers) {
                    if (!(functionLocalMember instanceof IRfAssociatedType)) continue;
                    AIUtils.getInstance().addAssociatedTypeAsDependency((IRfAssociatedTypeElement)((IRfAssociatedType)functionLocalMember), namedElement, dependencyToDistance, AIUtils.getInstance().getNamedElementDistanceToCursor(functionLocalMember, cursorPosition));
                }
            }
        }
        ArrayList<Object> otherDependencies = new ArrayList<Object>();
        if (namedElement instanceof RfArchitecture && (rfEntity = ((RfArchitecture)namedElement).getEntity()) != null) {
            otherDependencies.add(rfEntity);
        }
        if (namedElement instanceof RfEntity && (list = ((RfEntity)namedElement).getArchitectures()) != null) {
            otherDependencies.addAll(list);
        }
        if (namedElement instanceof RfPackage && (rfPackageBody = ((RfPackage)namedElement).getPackageBody()) != null) {
            otherDependencies.add(rfPackageBody);
        }
        if (namedElement instanceof RfPackageBody && (rfPackage = ((RfPackageBody)namedElement).getPackage()) != null) {
            otherDependencies.add(rfPackage);
        }
        for (IRfNamedElement iRfNamedElement : otherDependencies) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            IRfDefElement declaration = iRfNamedElement.getDeclaration();
            if (declaration == null) continue;
            int distance = AIUtils.getInstance().getNamedElementDistanceToCursor(iRfNamedElement, cursorPosition);
            int prevDistance = dependencyToDistance.getOrDefault(declaration, Integer.MAX_VALUE);
            int newDistance = Integer.min(distance, prevDistance);
            dependencyToDistance.put(declaration, newDistance);
        }
        ArrayList<DependencySource> arrayList = new ArrayList<DependencySource>();
        for (Map.Entry entry : dependencyToDistance.entrySet()) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            IRfDefElement defElement = (IRfDefElement)entry.getKey();
            arrayList.add(new DependencySource(false, false, null, defElement, (Integer)entry.getValue()));
        }
        this.sortDependencySources(arrayList);
        return arrayList;
    }

    @Override
    public List<CodeSnippet> getAdditionalExpansionsForDefElement(IRfDefElement defElement, DVTEditor editor, boolean formatCode) {
        IRfNamedElement namedElement = defElement.getNamedElement();
        if (!(namedElement instanceof RfArchitecture)) {
            return null;
        }
        RfEntity entity = ((RfArchitecture)namedElement).getEntity();
        if (entity == null) {
            return null;
        }
        CodeSnippet entityExpansion = AIExpansionUtils.INSTANCE.expandDefElement((IRfDefElement)entity.getDefElement(), editor, formatCode, false);
        return entityExpansion == null ? null : new ArrayList<CodeSnippet>(Arrays.asList(entityExpansion));
    }

    @Override
    public List<TreeElement> getAdditionalOutlinesForDefElement(IRfDefElement defElement) {
        IRfNamedElement namedElement = defElement.getNamedElement();
        if (!(namedElement instanceof RfArchitecture)) {
            return null;
        }
        RfEntity entity = ((RfArchitecture)namedElement).getEntity();
        if (entity == null) {
            return null;
        }
        IDVTElementWrapper elementWrapper = AISnippetSolver.getInstance().getOutlineDataForDefElement((IRfDefElement)entity.getDefElement());
        if (elementWrapper == null) {
            return null;
        }
        TreeElement root = AISnippetSolver.getInstance().convertToOutlineTreeElement(elementWrapper);
        return root == null ? null : new ArrayList<TreeElement>(Arrays.asList(root));
    }

    @Override
    public List<TreeElement> getCompiledFilesTree(IProject iProject) {
        if (iProject == null) {
            return null;
        }
        IRfSingleLangProject iRfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.VHDL.NATURE_ID, false);
        if (!(iRfProject instanceof RfProject)) {
            return null;
        }
        RfProject rfProject = (RfProject)iRfProject;
        List fileInstances = rfProject.getFiles();
        if (fileInstances == null || fileInstances.isEmpty()) {
            return null;
        }
        ArrayList<TreeElement> result = new ArrayList<TreeElement>();
        for (VhdlFileInstance fileInstance : fileInstances) {
            DVTGUIFilterMatcher.GUIFilterResult filterElement;
            ParserPath parserPath = fileInstance.getParserPath();
            if (parserPath == null || parserPath.path == null || (filterElement = DVTCompileOrderGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COMPILE_ORDER, (IProject)iProject, (IDVTFileInstance)fileInstance, null)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
            result.add(new TreeElement(parserPath.path, null));
        }
        return result;
    }

    @Override
    public IRfKind getDefElementKind(IRfDefElement element) {
        RfKind of = RfKind.of((IRfNamedElement)element.getNamedElement());
        if (of == null || of.equals((Object)RfKind.UNKNOWN)) {
            return null;
        }
        return of;
    }
}

