/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.contributor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIExpansionUtils;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.DependencySource;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.TreeElement;
import ro.amiq.dvt.ai.tools.GetFieldConstraintsAITool;
import ro.amiq.dvt.buildconfig.AutoConfigVlog;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefContainer;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.StringReplace;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTCompileOrderGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.model.reflection.IRfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroText;
import ro.amiq.vlogdt.ui.editor.lazy.outline.VlogOutlineUtil;
import ro.amiq.vlogdt.ui.macroexpansion.MacroScanner;
import ro.amiq.vlogdt.ui.search.constraints.ConstraintSearchHit;
import ro.amiq.vlogdt.ui.search.constraints.ConstraintsVisitor;

public class VlogAIContributor
implements IAILangContributor {
    private static final int FILTERED_ELEMENTS_DISTANCE_PENALTY = 0x3FFFFFFF;
    private static final String UVM_PKG_PREFIX = "uvm_pkg::";

    @Override
    public IDVTElementWrapper getOutlineWrapper(IRfDefContainer outlineDef) {
        RfTreeElementWrapper root = new RfTreeElementWrapper((Object)outlineDef, true);
        if (!(outlineDef instanceof IRfDefElement)) {
            return root;
        }
        this.addElements((IDVTElementWrapper)root, (IRfDefElement)outlineDef);
        return root;
    }

    private void addElements(IDVTElementWrapper root, IRfDefElement iRootDef) {
        if (!(iRootDef instanceof RfDefElement)) {
            return;
        }
        RfDefElement rootDef = (RfDefElement)iRootDef;
        Collection childrenDef = rootDef.getChildren();
        if (childrenDef == null) {
            return;
        }
        for (RfDefElement elementDef : childrenDef) {
            if (elementDef.getChildren() == childrenDef || !VlogOutlineUtil.INSTANCE.isOutlineElement((IRfDefElement)elementDef)) continue;
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper((Object)elementDef, true);
            root.addChild((IDVTElementWrapper)wrapper);
            if (!VlogOutlineUtil.INSTANCE.isPossibleOutlineParent((IRfDefElement)elementDef)) continue;
            this.addElements((IDVTElementWrapper)wrapper, (IRfDefElement)elementDef);
        }
    }

    @Override
    public LanguageKind getLanguage() {
        return LanguageKind.VLOG;
    }

    @Override
    public List<CodeSnippet> getAdditionalExpansionsForDefElement(IRfDefElement defElement, DVTEditor editor, boolean formatCode) {
        IRfNamedElement namedElement = defElement.getNamedElement();
        if (!(namedElement instanceof RfClass)) {
            return null;
        }
        Collection members = ((RfClass)namedElement).getMembers();
        if (members == null) {
            return null;
        }
        ArrayList<CodeSnippet> result = new ArrayList<CodeSnippet>();
        for (RfNamedElement member : members) {
            CodeSnippet implementationExpanded;
            RfDefElement implementation;
            if (!member.isExtern() || (implementation = member.getImplementation()) == null || (implementationExpanded = AIExpansionUtils.INSTANCE.expandDefElement((IRfDefElement)implementation, editor, formatCode, false)) == null) continue;
            result.add(implementationExpanded);
        }
        return result;
    }

    @Override
    public List<IRfDefElement> getContainersInFile(String fullPath, IProject iProject, boolean allowExternFunctions) {
        if (iProject == null) {
            return null;
        }
        IRfSingleLangProject iRfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.VLOG.NATURE_ID, false);
        if (!(iRfProject instanceof RfProject)) {
            return null;
        }
        RfFileDef fileDef = ((RfProject)iRfProject).getFile(new ParserPath(fullPath));
        if (fileDef == null) {
            return null;
        }
        Collection fileChildren = fileDef.getChildren();
        if (fileChildren == null || fileChildren.isEmpty()) {
            return null;
        }
        ArrayList<IRfDefElement> result = new ArrayList<IRfDefElement>();
        for (RfDefElement fileChild : fileChildren) {
            RfNamedElement namedElement = fileChild.getNamedElement();
            if (!allowExternFunctions && namedElement instanceof RfFunction && namedElement.isExtern()) continue;
            result.add((IRfDefElement)fileChild);
        }
        return result;
    }

    @Override
    public List<DependencySource> getContainerDependencySources(IRfDefElement container, EditorPosition cursorPosition, BooleanSupplier isCanceled) {
        IRfNamedElement namedElement = container.getNamedElement();
        if (!(namedElement instanceof RfNamedElement) || namedElement instanceof RfPackage) {
            return null;
        }
        RfNamedElement rfNamedElement = (RfNamedElement)namedElement;
        HashMap<IRfDefElement, Integer> dependencyToDistance = new HashMap<IRfDefElement, Integer>();
        List localMembers = rfNamedElement.getLocalMembers(true, IRfNamedElement.class);
        if (localMembers != null) {
            for (IRfNamedElement localMember : localMembers) {
                AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
                if (!(localMember instanceof IRfAssociatedType)) continue;
                AIUtils.getInstance().addAssociatedTypeAsDependency((IRfAssociatedTypeElement)((IRfAssociatedType)localMember), namedElement, dependencyToDistance, this.computeTypeDependencyDistance(localMember, cursorPosition));
                IRfNamedElement associatedType = ((IRfAssociatedType)localMember).getAssociatedType();
                if (associatedType instanceof RfSpecializedClass) {
                    this.addSpecializedClassParametersDependencies((RfSpecializedClass)associatedType, namedElement, dependencyToDistance, cursorPosition);
                }
                if (!(localMember instanceof RfFunction)) continue;
                List arguments = ((RfFunction)localMember).getArguments();
                for (IRfFieldElement argument : arguments) {
                    AIUtils.getInstance().addAssociatedTypeAsDependency((IRfAssociatedTypeElement)argument, namedElement, dependencyToDistance, this.computeTypeDependencyDistance((IRfNamedElement)argument, cursorPosition));
                }
                List functionLocalMembers = ((RfFunction)localMember).getLocalMembers(false, IRfNamedElement.class);
                if (functionLocalMembers == null) continue;
                for (IRfNamedElement functionLocalMember : functionLocalMembers) {
                    if (!(functionLocalMember instanceof IRfAssociatedType)) continue;
                    AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
                    AIUtils.getInstance().addAssociatedTypeAsDependency((IRfAssociatedTypeElement)((IRfAssociatedType)functionLocalMember), namedElement, dependencyToDistance, this.computeTypeDependencyDistance(functionLocalMember, cursorPosition));
                    IRfNamedElement localMemberAssociatedType = ((IRfAssociatedType)functionLocalMember).getAssociatedType();
                    if (!(localMemberAssociatedType instanceof RfSpecializedClass)) continue;
                    this.addSpecializedClassParametersDependencies((RfSpecializedClass)localMemberAssociatedType, namedElement, dependencyToDistance, cursorPosition);
                }
            }
        }
        if (namedElement instanceof RfClass) {
            RfClass parentClass = ((RfClass)namedElement).getParent();
            if (parentClass instanceof RfSpecializedClass) {
                this.addSpecializedClassParametersDependencies((RfSpecializedClass)parentClass, namedElement, dependencyToDistance, cursorPosition);
            }
            while (parentClass != null) {
                RfDefElement parentClassDeclaration = parentClass.getDeclaration();
                if (parentClassDeclaration != null) {
                    int distance = this.computeTypeDependencyDistance((IRfNamedElement)parentClass, cursorPosition);
                    int prevDistance = dependencyToDistance.getOrDefault(parentClassDeclaration, Integer.MAX_VALUE);
                    int newDistance = Integer.min(distance, prevDistance);
                    dependencyToDistance.put((IRfDefElement)parentClassDeclaration, newDistance);
                }
                parentClass = parentClass.getParent();
            }
        }
        ArrayList<DependencySource> results = new ArrayList<DependencySource>();
        for (Map.Entry entry : dependencyToDistance.entrySet()) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            IRfDefElement defElement = (IRfDefElement)entry.getKey();
            boolean isFiltered = false;
            IRfNamedElement correspondingNamedElement = defElement.getNamedElement();
            if (correspondingNamedElement != null) {
                isFiltered = this.isNamedElementFiltered(correspondingNamedElement);
            }
            results.add(new DependencySource(false, isFiltered, null, defElement, (Integer)entry.getValue()));
        }
        this.addMacroDependenciesForContainer(container, cursorPosition, rfNamedElement, results, isCanceled);
        this.sortDependencySources(results);
        return results;
    }

    private void addSpecializedClassParametersDependencies(RfSpecializedClass specializedClass, IRfNamedElement initialElement, Map<IRfDefElement, Integer> dependencyToDistance, EditorPosition cursorPosition) {
        List parameters = specializedClass.getLocalParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        for (RfField parameter : parameters) {
            AIUtils.getInstance().addAssociatedTypeAsDependency((IRfAssociatedTypeElement)parameter, initialElement, dependencyToDistance, this.computeTypeDependencyDistance((IRfNamedElement)parameter, cursorPosition));
        }
    }

    private void addMacroDependenciesForContainer(IRfDefElement container, EditorPosition cursorPosition, RfNamedElement rfNamedElement, List<DependencySource> dependencySources, BooleanSupplier isCanceled) {
        VlogMacroInfo macroInfo;
        IDocumentPartitioner documentPartitioner;
        ParserPath parserPath = container.getParserPath();
        if (parserPath == null || parserPath.path == null) {
            return;
        }
        RfProject rfProject = rfNamedElement.getRfProject();
        if (rfProject == null) {
            return;
        }
        IDocument document = AIUtils.getInstance().getDocumentFromPath(rfProject.getProject(), parserPath.path);
        if (document == null) {
            return;
        }
        String containerText = AIExpansionUtils.INSTANCE.getDefElementTextBasedOnOffsets(container);
        if (containerText.isEmpty()) {
            return;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
        MacroScanner scanner = new MacroScanner();
        String contentType = null;
        if (document instanceof IDocumentExtension3 && (documentPartitioner = ((IDocumentExtension3)document).getDocumentPartitioner("__vlog_partitioning")) != null) {
            contentType = documentPartitioner.getContentType(container.getStartOffset());
        }
        scanner.init(contentType);
        StringBuilder text = new StringBuilder(containerText).append('\n');
        List macroCallsInsideContainer = scanner.getMacroMatches((CharSequence)text, rfProject, container.getEndLine(), parserPath, null, false);
        if (macroCallsInsideContainer == null || macroCallsInsideContainer.isEmpty()) {
            return;
        }
        HashMap<VlogMacroInfo, Integer> macroToDistance = new HashMap<VlogMacroInfo, Integer>();
        for (MacroScanner.Match match : macroCallsInsideContainer) {
            ParserPath macroParserPath;
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            macroInfo = match.getMacro();
            if (macroInfo == null || (macroParserPath = macroInfo.getMacroParserPath()) == null || macroParserPath.path == null || AIProtectManager.INSTANCE.isFileProtected(macroParserPath.path, macroInfo.getProject())) continue;
            this.addMacroInfoDistance(macroInfo, match.start() + container.getStartOffset(), macroToDistance, cursorPosition);
        }
        for (Map.Entry entry : macroToDistance.entrySet()) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            macroInfo = (VlogMacroInfo)entry.getKey();
            CodeSnippet macroDefinition = this.expandMacro((IMacroInfo)macroInfo);
            if (macroDefinition == null) continue;
            dependencySources.add(new DependencySource(true, this.isXVMMacro(macroInfo), macroDefinition, null, (Integer)entry.getValue()));
        }
    }

    private void addMacroInfoDistance(VlogMacroInfo macroInfo, int macroCallStartOffsetInFile, Map<VlogMacroInfo, Integer> macroToDistance, EditorPosition cursorPosition) {
        int cursorOffset = cursorPosition.getOffset();
        int distance = Math.abs(cursorOffset - macroCallStartOffsetInFile);
        if (this.isXVMMacro(macroInfo)) {
            distance += 0x3FFFFFFF;
        }
        int prevDistance = macroToDistance.getOrDefault(macroInfo, Integer.MAX_VALUE);
        int newDistance = Integer.min(distance, prevDistance);
        macroToDistance.put(macroInfo, newDistance);
    }

    private int computeTypeDependencyDistance(IRfNamedElement namedElement, EditorPosition cursorPosition) {
        int distance = AIUtils.getInstance().getNamedElementDistanceToCursor(namedElement, cursorPosition);
        if (distance != Integer.MAX_VALUE && this.isNamedElementFiltered(namedElement)) {
            distance += 0x3FFFFFFF;
        }
        return distance;
    }

    private boolean isNamedElementFiltered(IRfNamedElement namedElement) {
        IRfNamedElement finalElement;
        if (namedElement instanceof IRfAssociatedTypeElement) {
            namedElement = ((IRfAssociatedTypeElement)namedElement).getAssociatedType();
        }
        if (namedElement instanceof IRfTypeAliasElement) {
            namedElement = ((IRfTypeAliasElement)namedElement).getTranslatedType();
        }
        if ((finalElement = namedElement) == null) {
            return false;
        }
        if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES, (IRfNamedElement)finalElement, () -> finalElement.toString()) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
            return true;
        }
        String signature = finalElement.getSignature();
        return signature != null && signature.contains(UVM_PKG_PREFIX);
    }

    private boolean isXVMMacro(VlogMacroInfo macroInfo) {
        String macroName = macroInfo.getName();
        if (macroName == null) {
            return false;
        }
        return AutoConfigVlog.UVM_MACROS.contains(macroName) || AutoConfigVlog.OVM_MACROS.contains(macroName);
    }

    @Override
    public CodeSnippet expandMacro(IMacroInfo macroInfo) {
        if (!(macroInfo instanceof VlogMacroInfo)) {
            return null;
        }
        VlogMacroInfo vlogMacroInfo = (VlogMacroInfo)macroInfo;
        String signature = macroInfo.getSignature(false, false);
        if (signature == null) {
            return null;
        }
        CodeSnippet result = new CodeSnippet("", null, -1, -1);
        StringBuilder resultCode = new StringBuilder("`define");
        resultCode.append(" ").append(signature);
        ParserPath macroParserPath = vlogMacroInfo.getMacroParserPath();
        if (macroParserPath != null) {
            result.setFilePath(AIPathUtils.INSTANCE.makePathRelativeToProject(macroParserPath.path, vlogMacroInfo.getProject()));
        }
        result.setStartLine(vlogMacroInfo.getLine());
        result.setEndLine(vlogMacroInfo.getLine());
        VlogMacroText macroText = vlogMacroInfo.getMacroText();
        if (macroText == null || macroText.getReplacement() == null || macroText.getReplacement().isEmpty()) {
            result.setCode(resultCode.toString().trim());
            return result;
        }
        resultCode.append(" ");
        for (StringReplace replacement : macroText.getReplacement()) {
            String s = replacement.getString();
            if (s == null) continue;
            resultCode.append(s);
        }
        result.setCode(resultCode.toString().trim());
        result.setEndLine(vlogMacroInfo.getEndLine());
        return result;
    }

    @Override
    public List<TreeElement> getCompiledFilesTree(IProject iProject) {
        if (iProject == null) {
            return null;
        }
        IRfSingleLangProject iRfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.VLOG.NATURE_ID, false);
        if (!(iRfProject instanceof RfProject)) {
            return null;
        }
        RfProject rfProject = (RfProject)iRfProject;
        VlogFileInstance topFileInstance = rfProject.getPreprocessingTable().getTopFileInstance();
        if (topFileInstance == null) {
            return null;
        }
        List includedInstances = topFileInstance.getIncludedInstances();
        if (includedInstances == null || includedInstances.isEmpty()) {
            return null;
        }
        ArrayList<VlogFileInstance> topInstances = new ArrayList<VlogFileInstance>();
        for (VlogFileInstance includedInstance : includedInstances) {
            String name = includedInstance.getShortFileName();
            if (name != null && name.startsWith("__vlog__") && name.endsWith(".libfile")) {
                List libraryChildInstances = includedInstance.getIncludedInstances();
                if (libraryChildInstances == null) continue;
                topInstances.addAll(libraryChildInstances);
                continue;
            }
            topInstances.add(includedInstance);
        }
        ArrayList<TreeElement> result = new ArrayList<TreeElement>();
        for (VlogFileInstance topInstance : topInstances) {
            TreeElement treeElement = this.convertFileInstanceToTreeElement(topInstance, iProject);
            if (treeElement == null) continue;
            result.add(treeElement);
        }
        return result;
    }

    @Override
    public List<GetFieldConstraintsAITool.ConstraintLocation> computeConstraints(IRfNamedElement namedElement) {
        RfField field = this.findFieldElement(namedElement);
        if (field == null) {
            return null;
        }
        final ArrayList<GetFieldConstraintsAITool.ConstraintLocation> result = new ArrayList<GetFieldConstraintsAITool.ConstraintLocation>();
        IReportHitsListener<ConstraintSearchHit> reportListener = new IReportHitsListener<ConstraintSearchHit>(){

            public void addMatch(ConstraintSearchHit match) {
                try {
                    result.add(new GetFieldConstraintsAITool.ConstraintLocation(match.getParserPath().path, match.getLine()));
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public Set<ConstraintSearchHit> getMatches() {
                return null;
            }
        };
        DocumentManager documentManager = new DocumentManager();
        try {
            documentManager.activate();
            RfProject rfProject = field.getRfProject();
            if (rfProject == null) {
                return null;
            }
            ConstraintsVisitor visitor = new ConstraintsVisitor(field, (IProgressMonitor)new NullProgressMonitor(), (IReportHitsListener)reportListener, documentManager);
            rfProject.visitHidObject(null, (IHidVisitor)visitor);
        }
        finally {
            documentManager.deactivate();
        }
        return result;
    }

    private RfField findFieldElement(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return null;
        }
        if (namedElement instanceof RfDefElement) {
            namedElement = ((RfDefElement)namedElement).getNamedElement();
        }
        if (!(namedElement instanceof RfField)) {
            return null;
        }
        return (RfField)namedElement;
    }

    private TreeElement convertFileInstanceToTreeElement(VlogFileInstance fileInstance, IProject iProject) {
        if (fileInstance == null) {
            return null;
        }
        DVTGUIFilterMatcher.GUIFilterResult filterElement = DVTCompileOrderGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COMPILE_ORDER, (IProject)iProject, (IDVTFileInstance)fileInstance, null);
        if (filterElement != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
            return null;
        }
        if (fileInstance.getIndex() <= 0) {
            return null;
        }
        String name = fileInstance.getShortFileName();
        if (name != null && name.startsWith("__vlog__") && name.endsWith(".libfile")) {
            return null;
        }
        ParserPath parserPath = fileInstance.getParserPath();
        if (parserPath == null || parserPath.path == null) {
            return null;
        }
        TreeElement result = new TreeElement();
        result.setElement(parserPath.path);
        List childInstances = fileInstance.getIncludedInstances();
        if (childInstances == null) {
            return result;
        }
        for (VlogFileInstance childInstance : childInstances) {
            TreeElement childTreeElement = this.convertFileInstanceToTreeElement(childInstance, iProject);
            if (childTreeElement == null) continue;
            result.addChild(childTreeElement);
        }
        return result;
    }

    @Override
    public IRfKind getDefElementKind(IRfDefElement element) {
        RfKind of = RfKind.of((IRfNamedElement)element.getNamedElement());
        if (of == null || of.equals((Object)RfKind.UNKNOWN)) {
            return null;
        }
        return of;
    }
}

