/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.eclipse;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import ro.amiq.dvt.ai.AIHostAPI;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.AIResourceChangeListener;
import ro.amiq.dvt.ai.mcp.McpEndpointManager;
import ro.amiq.dvt.ai.mcp.McpEndpointType;
import ro.amiq.dvt.ai.model.params.FindFilesParams;
import ro.amiq.dvt.ai.model.responses.FindFilesResponse;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum LifecycleManager {
    INSTANCE;

    private static final List<String> AIA_SPECIFIC_ENVARS;

    static {
        AIA_SPECIFIC_ENVARS = Collections.unmodifiableList(Arrays.asList("OPENAI_API_KEY", "AZURE_OPENAI_API_KEY", "ANTHROPIC_API_KEY", "GOOGLE_AI_API_KEY", "OLLAMA_HOST"));
    }

    public void start() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)AIResourceChangeListener.INSTANCE, 1);
        if (this.isAIAConfigured()) {
            AIManager.getInstance();
        }
        McpEndpointManager.getInstance().start(McpEndpointType.IDE);
    }

    private boolean isAIAConfigured() {
        for (String envar : AIA_SPECIFIC_ENVARS) {
            String envarValue = System.getenv(envar);
            if (envarValue == null || envarValue.isEmpty()) continue;
            return true;
        }
        FindFilesResponse filesResponse = AIHostAPI.INSTANCE.findFiles(null, new FindFilesParams(".dvt/ai/**/*", "projectDir", "file"));
        return filesResponse.files != null && !filesResponse.files.isEmpty();
    }

    public void stop() {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)AIResourceChangeListener.INSTANCE);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

