/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.incremental;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum AIIncrementalBuildManager {
    INSTANCE;

    private static final long POLLING_INTERVAL_MILLIS = 100L;
    private Set<String> incrementallyCompiledFiles = new HashSet<String>();
    private boolean listeningForIncrementals;

    /*
     * Unable to fully structure code
     */
    public boolean waitForIncremental(String filePath, int timeoutMillis) {
        try {
            start = System.currentTimeMillis();
            filePath = AIPathUtils.INSTANCE.normalizeAndMakePathAbsolute(filePath, AIUtils.getInstance().getSelectedProject());
            if (this.isFileCompiled(filePath)) ** GOTO lbl15
            return true;
lbl-1000:
            // 1 sources

            {
                if (this.wasFileIncrementallyCompiled(filePath)) {
                    return true;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    this.stopListening();
                    return false;
                }
lbl15:
                // 2 sources

                ** while (System.currentTimeMillis() < start + (long)timeoutMillis)
            }
lbl16:
            // 1 sources

            return false;
        }
        finally {
            this.stopListening();
        }
    }

    public void notifyIncrementalBuild(List<String> compiledFiles) {
        if (this.listeningForIncrementals) {
            this.incrementallyCompiledFiles.addAll(compiledFiles);
        }
    }

    public void startListening() {
        this.listeningForIncrementals = true;
        this.incrementallyCompiledFiles = new HashSet<String>();
    }

    private void stopListening() {
        this.listeningForIncrementals = false;
    }

    private boolean wasFileIncrementallyCompiled(String filePath) {
        IProject iProject = AIUtils.getInstance().getSelectedProject();
        for (String compiledFile : this.incrementallyCompiledFiles) {
            if (!AIPathUtils.INSTANCE.pathsAreEqual(compiledFile, iProject, filePath, iProject)) continue;
            return true;
        }
        return false;
    }

    private boolean isFileCompiled(String filePath) {
        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(AIUtils.getInstance().getSelectedProject(), false);
        if (rfMixedLangProject == null) {
            return false;
        }
        Collection singleLangProjects = rfMixedLangProject.getSingleLangProjects();
        for (IRfSingleLangProject singleLangProject : singleLangProjects) {
            Set compiledFiles = singleLangProject.getCompiledFilesSet();
            if (compiledFiles == null || !compiledFiles.contains(new ParserPath(filePath))) continue;
            return true;
        }
        return false;
    }
}

