/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.inlineCompletion;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import ro.amiq.dvt.ai.AIHostLS;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.ICompletionProcessorAndListener;
import ro.amiq.dvt.ai.ModelsManager;
import ro.amiq.dvt.ai.inlineCompletion.AICodeCompletionProposal;
import ro.amiq.dvt.ai.inlineCompletion.AINoCodeCompletionProposal;
import ro.amiq.dvt.ai.inlineCompletion.AIRedirectCompletionProposal;
import ro.amiq.dvt.ai.model.responses.InlineCompletionResponse;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum AICodeCompletionProcessorAndListener implements ICompletionProcessorAndListener
{
    INSTANCE;

    private static final int CODE_COMPLETION_WAIT_TIMEOUT_SEC = 20;
    private static final Pattern TRAILING_WHITESPACE_PATTERN;
    private CompletableFuture<InlineCompletionResponse> crtInlineCompletionFuture;

    static {
        TRAILING_WHITESPACE_PATTERN = Pattern.compile("\\s+$");
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (!ModelsManager.INSTANCE.isModelsAvailable() || !PrefConst.getAIAAccessProposalsInDefaultPage()) {
            return null;
        }
        return new ICompletionProposal[]{new AIRedirectCompletionProposal(viewer)};
    }

    public ICompletionProposal[] computeCompletionProposalsForAIAssistantPage(ITextViewer viewer, int offset) {
        if (!ModelsManager.INSTANCE.isModelsAvailable()) {
            return new ICompletionProposal[]{new AINoCodeCompletionProposal(AINoCodeCompletionProposal.NoCodeCompletionReason.LANGUAGE_MODEL_NOT_SET)};
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return null;
        }
        this.cancelCrtLLMRequest();
        try {
            List<String> LLMResponseProposals = this.getLLMResponseFuture(document, offset).get(20L, TimeUnit.SECONDS);
            if (LLMResponseProposals == null || LLMResponseProposals.isEmpty()) {
                return new ICompletionProposal[]{new AINoCodeCompletionProposal(AINoCodeCompletionProposal.NoCodeCompletionReason.EMPTY_RESPONSE)};
            }
            return (ICompletionProposal[])LLMResponseProposals.stream().map(p -> new AICodeCompletionProposal(offset, 0, (String)p)).toArray(AICodeCompletionProposal[]::new);
        }
        catch (InterruptedException | ExecutionException exception) {
            return new ICompletionProposal[]{new AINoCodeCompletionProposal(AINoCodeCompletionProposal.NoCodeCompletionReason.UNECPECTED_ERROR)};
        }
        catch (TimeoutException timeoutException) {
            return new ICompletionProposal[]{new AINoCodeCompletionProposal(AINoCodeCompletionProposal.NoCodeCompletionReason.REQUEST_TIMEOUT)};
        }
    }

    private void cancelCrtLLMRequest() {
        if (this.crtInlineCompletionFuture == null) {
            return;
        }
        this.crtInlineCompletionFuture.cancel(true);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private CompletableFuture<List<String>> getLLMResponseFuture(IDocument document, int offset) {
        CompletableFuture<List<String>> result = new CompletableFuture<List<String>>();
        AIManager.getInstance().thenAccept(aiManager -> {
            AIHostLS host = aiManager.getHost();
            this.crtInlineCompletionFuture = host.getCore().inlineCompletion();
            this.crtInlineCompletionFuture.thenAccept(resp -> {
                if (resp.proposals.isEmpty()) {
                    result.complete(null);
                }
                result.complete(this.postProcessProposal(resp.proposals, document, offset));
            });
        });
        return result;
    }

    private List<String> postProcessProposal(List<String> proposals, IDocument document, int offset) {
        ArrayList<String> result = new ArrayList<String>();
        for (String proposal : proposals) {
            proposal = TextUtils.isPrecededByWhitespaces((IDocument)document, (int)offset) ? proposal.trim() : DVTStringUtil.replaceAll((Pattern)TRAILING_WHITESPACE_PATTERN, (CharSequence)proposal, (String)"");
            result.add(proposal);
        }
        return result;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.cancelCrtLLMRequest();
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }
}

