/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.inlineCompletion;

import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;

public class AICodeCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension5 {
    private static final int displayStringMaxLen = 45;
    private final int selectionOffset;
    private final int selectionLength;
    private final StyledString displayString;
    private CompletableFuture<String> llmResponseFuture;
    private String resolvedText;

    public AICodeCompletionProposal(int offset, int length, String llmResponse) {
        this.selectionOffset = offset;
        this.selectionLength = length;
        String llmRespFirstLine = llmResponse.split(System.lineSeparator())[0];
        this.displayString = 45 < llmRespFirstLine.length() ? new StyledString(String.valueOf(llmRespFirstLine.substring(0, 45)) + " ...") : new StyledString(String.valueOf(llmRespFirstLine) + (llmRespFirstLine.length() < llmResponse.length() ? " ..." : ""));
        this.resolvedText = llmResponse;
    }

    public void apply(IDocument document) {
        try {
            String replacement = this.resolvedText != null ? this.resolvedText : "";
            document.replace(this.selectionOffset, this.selectionLength, replacement);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.selectionOffset + (this.resolvedText != null ? this.resolvedText.length() : 0), 0);
    }

    public String getAdditionalProposalInfo() {
        if (this.resolvedText == null) {
            return "Loading...";
        }
        return this.resolvedText;
    }

    public CompletableFuture<String> onLLMResponse() {
        return this.llmResponseFuture;
    }

    public String getDisplayString() {
        return this.displayString.getString();
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.TEMPLATE_OBJ);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        DVTTooltipContent dvtTooltipContent = new DVTTooltipContent();
        dvtTooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, this.getAdditionalProposalInfo().replace(System.lineSeparator(), "<br>"));
        return dvtTooltipContent;
    }
}

