/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.inlineCompletion;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;

public class AINoCodeCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension5 {
    private NoCodeCompletionReason reason;

    public AINoCodeCompletionProposal(NoCodeCompletionReason reason) {
        this.reason = reason;
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.reason.getAdditionalInfo();
    }

    public String getDisplayString() {
        return "[no proposals]";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DESC_ERROR_TASK);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        DVTTooltipContent dvtTooltipContent = new DVTTooltipContent();
        dvtTooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, "<b>" + this.getAdditionalProposalInfo() + "</b>");
        return dvtTooltipContent;
    }

    static enum NoCodeCompletionReason {
        LANGUAGE_MODEL_NOT_SET("Unable to compute a completion. A language model must be set before using the AI Assistant!"),
        EMPTY_RESPONSE("Unable to compute a completion. Either the language model didn`t return a valid completion, or an error occurred during postprocessing. Check the 'DVT AI' consoles for more information."),
        REQUEST_TIMEOUT("Unable to compute a completion. The completion request timed out. Check the 'DVT AI Messages' and the 'DVT AI' consoles for more information."),
        UNECPECTED_ERROR("Unable to compute a completion. An unexpected error occurred. Check the 'DVT AI Messages' and the 'DVT AI' consoles for more information.");

        String additionalInfo;

        private NoCodeCompletionReason(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        String getAdditionalInfo() {
            return this.additionalInfo;
        }
    }
}

