/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.mcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import ro.amiq.dvt.ai.mcp.IMcpConnector;
import ro.amiq.dvt.ai.mcp.McpEndpoint;
import ro.amiq.dvt.ai.mcp.McpEndpointLogger;
import ro.amiq.dvt.ai.mcp.McpEndpointType;
import ro.amiq.dvt.ai.mcp.McpRegistry;
import ro.amiq.dvt.ai.mcp.McpRegistryStatus;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public abstract class AbstractMcpEndpointManager {
    private static final String DISABLE_MCP = "DVT_MCP_SERVER_DISABLE";
    private static final String LOCAL_ENDPOINT = "DVT_MCP_SERVER_LOCAL_ENDPOINT";
    private static final String PORT_START_RANGE = "DVT_MCP_SERVER_PORT_START";
    private static final String PORT_END_RANGE = "DVT_MCP_SERVER_PORT_END";
    public static final int REWRITE_REGISTRY_STATUS_INTERVAL = 10;
    private static final int REWRITE_REGISTRY_INTERVAL = 1;
    private static final ThreadPoolExecutor CONNECTIONS_EXECUTOR = new ThreadPoolExecutor(4, 4, 4L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private static final int NOF_THREADS = 4;
    private static final long THREADS_TIMEOUT_MIN = 4L;
    private static final ScheduledExecutorService REGISTRY_WATCHER_SCHEDULER;
    private final AtomicBoolean isBusy = new AtomicBoolean(false);
    private volatile boolean isRunning;
    private String id;
    protected McpRegistry mcpRegistry;
    protected McpEndpointType mcpEndpointType;

    static {
        CONNECTIONS_EXECUTOR.allowCoreThreadTimeOut(true);
        REGISTRY_WATCHER_SCHEDULER = Executors.newScheduledThreadPool(1);
    }

    public void start(McpEndpointType type) {
        Thread mcpEndpointThread = new Thread(() -> {
            if (this.isRunning) {
                return;
            }
            if (Boolean.parseBoolean(System.getenv(DISABLE_MCP))) {
                return;
            }
            this.mcpEndpointType = type;
            this.isRunning = true;
            McpEndpointLogger.INSTANCE.cleanRegistries();
            McpEndpointLogger.INSTANCE.cleanLogs();
            String id = this.getId();
            McpEndpointLogger.INSTANCE.setup(id);
            InetAddress bindAddress = this.findBindAddress();
            if (bindAddress == null) {
                return;
            }
            int port = this.findPort(bindAddress);
            String[] pidAndHost = ManagementFactory.getRuntimeMXBean().getName().split("@");
            if (pidAndHost.length != 2) {
                McpEndpointLogger.INSTANCE.log("Failed to retrieve host and pid!");
                return;
            }
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (ServerSocket sSocket = new ServerSocket(port, 1, bindAddress);){
                    this.mcpRegistry = McpRegistry.builder().host(pidAndHost[1]).id(id).port(sSocket.getLocalPort()).hostPid(Integer.parseInt(pidAndHost[0])).hostPlatform(this.getHostPlatform()).projectPaths(this.getProjectsPaths()).version(this.getVersion()).build();
                    McpEndpointLogger.INSTANCE.writeRegistry(this.mcpRegistry);
                    this.registerProjectChangeListener();
                    this.watchRegistryAndStatus();
                    this.acceptConnections(sSocket);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                McpEndpointLogger.INSTANCE.log("Unexpected error while starting MCP Endpoint!", e);
            }
        }, "MCP Endpoint");
        mcpEndpointThread.setDaemon(true);
        mcpEndpointThread.start();
    }

    private void watchRegistryAndStatus() {
        REGISTRY_WATCHER_SCHEDULER.scheduleAtFixedRate(() -> McpEndpointLogger.INSTANCE.writeRegistryIfMissing(this.mcpRegistry), 0L, 1L, TimeUnit.SECONDS);
        REGISTRY_WATCHER_SCHEDULER.scheduleAtFixedRate(() -> {
            McpRegistryStatus registryStatus = new McpRegistryStatus(Instant.now().getEpochSecond(), this.isBusy.get());
            McpEndpointLogger.INSTANCE.writeRegistryStatus(registryStatus);
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private void acceptConnections(ServerSocket sSocket) throws IOException {
        while (this.isRunning && this.isPlatformRunnning()) {
            Socket socket = sSocket.accept();
            CONNECTIONS_EXECUTOR.submit(() -> this.handleConnection(socket));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleConnection(Socket socket) {
        try {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    InputStream in = socket.getInputStream();
                    try {
                        block31: {
                            OutputStream out = socket.getOutputStream();
                            try {
                                try (PrintStream printStream = new PrintStream(out);){
                                    if (McpEndpointType.IDE.equals((Object)this.mcpEndpointType) || this.isBusy.compareAndSet(false, true)) {
                                        printStream.println("ready");
                                        printStream.flush();
                                        Launcher launcher = new Launcher.Builder().setLocalService((Object)McpEndpoint.INSTANCE).setRemoteInterface(IMcpConnector.class).setInput(in).setOutput(out).validateMessages(false).create();
                                        launcher.startListening().get();
                                        this.isBusy.set(false);
                                    } else {
                                        printStream.println("busy");
                                        printStream.flush();
                                    }
                                }
                                if (out == null) break block31;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (out == null) throw throwable;
                                out.close();
                                throw throwable;
                            }
                            out.close();
                        }
                        if (in == null) return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                    return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (Exception e) {
                McpEndpointLogger.INSTANCE.log("Unexpected error while creating JsonRPC socket for MCP Endpoint!", e);
                try {
                    socket.close();
                    return;
                }
                catch (IOException e2) {
                    McpEndpointLogger.INSTANCE.log("Failed to close connection socket!", e2);
                    return;
                }
            }
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                McpEndpointLogger.INSTANCE.log("Failed to close connection socket!", e);
            }
        }
    }

    protected InetAddress findBindAddress() {
        boolean isEndpointLocal = Boolean.parseBoolean(System.getenv(LOCAL_ENDPOINT));
        InetAddress bindAddress = null;
        try {
            bindAddress = isEndpointLocal ? InetAddress.getLoopbackAddress() : InetAddress.getByAddress(new byte[4]);
        }
        catch (Exception e) {
            McpEndpointLogger.INSTANCE.log("Failed to find address to bind!", e);
        }
        return bindAddress;
    }

    protected int findPort(InetAddress bindAddress) {
        int portStartRange = 0;
        int portEndRange = 0;
        try {
            String portEndString;
            String portStartString = System.getenv(PORT_START_RANGE);
            if (portStartString != null && !portStartString.isEmpty()) {
                portStartRange = Integer.parseInt(portStartString);
            }
            if ((portEndString = System.getenv(PORT_END_RANGE)) != null && !portEndString.isEmpty()) {
                portEndRange = Integer.parseInt(portEndString);
            }
        }
        catch (Exception e) {
            McpEndpointLogger.INSTANCE.log("Failed to find valid port in range DVT_MCP_SERVER_PORT_START - DVT_MCP_SERVER_PORT_END !", e);
        }
        int port = 0;
        if (portStartRange != 0 && portEndRange != 0) {
            port = DVTUtilsCommon.INSTANCE.getFirstAvailablePortInRange(portStartRange, portEndRange, bindAddress);
        }
        return port;
    }

    protected String getId() {
        if (this.id == null) {
            this.id = String.valueOf(LocalDateTime.now().format(McpEndpointLogger.DATE_FORMATER)) + ".mcp.ide";
        }
        return this.id;
    }

    protected abstract boolean isPlatformRunnning();

    protected abstract Set<String> getProjectsPaths();

    protected abstract String getHostPlatform();

    protected abstract String getVersion();

    protected abstract void registerProjectChangeListener();
}

