/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.mcp;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import ro.amiq.dvt.ai.AIHostAPI;
import ro.amiq.dvt.ai.mcp.IMcpEndpoint;
import ro.amiq.dvt.ai.mcp.McpEndpointLogger;
import ro.amiq.dvt.ai.model.params.InvokeToolParams;
import ro.amiq.dvt.ai.model.responses.InvokeToolResponse;

public enum McpEndpoint implements IMcpEndpoint
{
    INSTANCE;

    private static final ThreadPoolExecutor EXECUTOR;
    private static final int NOF_THREADS = 1;
    private static final long THREADS_TIMEOUT_MIN = 4L;

    static {
        EXECUTOR = new ThreadPoolExecutor(1, 1, 4L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
        EXECUTOR.allowCoreThreadTimeOut(true);
    }

    @Override
    public CompletableFuture<InvokeToolResponse> invokeTool(InvokeToolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return AIHostAPI.INSTANCE.invokeTool(null, params);
            }
            catch (Exception e) {
                McpEndpointLogger.INSTANCE.log("Error calling " + params.getToolName() + " tool!", e);
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.RequestFailed, e.getMessage(), null));
            }
        }, EXECUTOR);
    }
}

