/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.mcp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import ro.amiq.dvt.ai.mcp.McpRegistry;
import ro.amiq.dvt.ai.mcp.McpRegistryStatus;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public enum McpEndpointLogger {
    INSTANCE;

    private File logFile;
    private File registryFile;
    private File registryStatusFile;
    public static final DateTimeFormatter DATE_FORMATER;
    private static final Gson GSON;
    private static final File LOGS_DIR;
    private static final File REGISTRY_DIR;
    private static final long LOG_EXPIRY_DAYS = 7L;

    static {
        DATE_FORMATER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss-SSSSSSSSS");
        GSON = new GsonBuilder().setPrettyPrinting().create();
        String userDir = System.getenv("DVT_USER_DIR");
        if (userDir == null) {
            userDir = String.valueOf(System.getProperty("user.home")) + File.separatorChar + ".dvt";
        }
        LOGS_DIR = new File(String.valueOf(userDir) + File.separatorChar + "mcp" + File.separatorChar + "logs");
        REGISTRY_DIR = new File(String.valueOf(userDir) + File.separatorChar + "mcp" + File.separatorChar + "registry");
    }

    private void createLogsDir() {
        if (LOGS_DIR.exists()) {
            return;
        }
        LOGS_DIR.mkdirs();
        if (LOGS_DIR.exists()) {
            return;
        }
    }

    private void createRegistryDir() {
        if (REGISTRY_DIR.exists()) {
            return;
        }
        REGISTRY_DIR.mkdirs();
        if (REGISTRY_DIR.exists()) {
            return;
        }
    }

    public void setup(String id) {
        try {
            this.createLogsDir();
            this.createRegistryDir();
            this.logFile = new File(String.valueOf(LOGS_DIR.getAbsolutePath()) + File.separator + id + ".endpoint");
            this.registryFile = new File(String.valueOf(REGISTRY_DIR.getAbsolutePath()) + File.separator + id);
            this.registryFile.deleteOnExit();
            this.registryStatusFile = new File(String.valueOf(REGISTRY_DIR.getAbsolutePath()) + File.separator + id + ".status");
            this.registryStatusFile.deleteOnExit();
        }
        catch (Exception exception) {}
    }

    public synchronized void writeRegistry(McpRegistry registry) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter registryWriter = new BufferedWriter(new FileWriter(this.registryFile));){
                registryWriter.write(GSON.toJson((Object)registry));
                registryWriter.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    public void writeRegistryIfMissing(McpRegistry registry) {
        if (this.registryFile.exists()) {
            return;
        }
        this.writeRegistry(registry);
    }

    public McpRegistry readRegistry(File registryFile) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader reader = new FileReader(registryFile);){
            McpRegistry registry = (McpRegistry)GSON.fromJson((Reader)reader, McpRegistry.class);
            return registry;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public synchronized void writeRegistryStatus(McpRegistryStatus registryStatus) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter registryStatusWriter = new BufferedWriter(new FileWriter(this.registryStatusFile));){
                registryStatusWriter.write(GSON.toJson((Object)registryStatus));
                registryStatusWriter.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    public McpRegistryStatus readRegistryStatus(File registryStatusFile) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader reader = new FileReader(registryStatusFile);){
            McpRegistryStatus registryStatus = (McpRegistryStatus)GSON.fromJson((Reader)reader, McpRegistryStatus.class);
            return registryStatus;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void log(String message, Throwable e) {
        this.log(String.valueOf(message) + "\n" + DVTUtilsCommon.INSTANCE.getStackTrace(e) + "\n");
    }

    public synchronized void log(String message) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter logFileWriter = new BufferedWriter(new FileWriter(this.logFile, true));){
                logFileWriter.write(message);
                logFileWriter.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    public File getRegistryDir() {
        return REGISTRY_DIR;
    }

    public File getLogsDir() {
        return LOGS_DIR;
    }

    public void cleanRegistries() {
        File[] registryFiles;
        if (REGISTRY_DIR == null) {
            return;
        }
        try {
            registryFiles = REGISTRY_DIR.listFiles();
        }
        catch (Exception exception) {
            return;
        }
        if (registryFiles == null) {
            return;
        }
        File[] fileArray = registryFiles;
        int n = registryFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File registryFile = fileArray[n2];
            try {
                String registryName = registryFile.getName();
                if (!(registryName == null || registryName.isEmpty() || registryName.endsWith(".status") || this.isEndpointAlive(registryName))) {
                    Files.deleteIfExists(registryFile.toPath());
                    Files.deleteIfExists(new File(String.valueOf(registryFile.getAbsolutePath()) + ".status").toPath());
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    public void cleanLogs() {
        File[] logFiles;
        if (LOGS_DIR == null) {
            return;
        }
        try {
            logFiles = LOGS_DIR.listFiles();
        }
        catch (Exception exception) {
            return;
        }
        if (logFiles == null) {
            return;
        }
        File[] fileArray = logFiles;
        int n = logFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File logFile = fileArray[n2];
            try {
                String logName = logFile.getName();
                String logTimestamp = logName.split("\\.")[0];
                LocalDateTime logDateTime = LocalDateTime.parse(logTimestamp, DATE_FORMATER);
                Instant logInstant = logDateTime.atZone(ZoneId.systemDefault()).toInstant();
                Instant nowInstant = Instant.now();
                long daysOld = ChronoUnit.DAYS.between(logInstant, nowInstant);
                if (daysOld >= 7L) {
                    if (logName.endsWith(".connector")) {
                        try {
                            Files.deleteIfExists(logFile.toPath());
                        }
                        catch (Exception exception) {}
                    } else if (!this.isEndpointAlive(logTimestamp)) {
                        Files.deleteIfExists(logFile.toPath());
                    }
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    private boolean isEndpointAlive(String id) {
        McpRegistryStatus registryStatus = this.getRegistryStatus(id);
        if (registryStatus == null) {
            return false;
        }
        long currentTimestamp = Instant.now().getEpochSecond();
        return currentTimestamp - registryStatus.getTimestamp() <= 20L;
    }

    private McpRegistryStatus getRegistryStatus(String id) {
        try {
            return this.readRegistryStatus(new File(this.getRegistryDir(), String.valueOf(id) + ".status"));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

