/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.mcp;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ai.mcp.AbstractMcpEndpointManager;
import ro.amiq.dvt.ai.mcp.McpEndpointLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class McpEndpointManager
extends AbstractMcpEndpointManager {
    private static volatile McpEndpointManager instance;

    private McpEndpointManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static McpEndpointManager getInstance() {
        if (instance != null) return instance;
        Class<McpEndpointManager> clazz = McpEndpointManager.class;
        synchronized (McpEndpointManager.class) {
            if (instance != null) return instance;
            instance = new McpEndpointManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected void registerProjectChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(event -> {
            try {
                IResourceDelta resourceDelta = event.getDelta();
                if (resourceDelta == null) {
                    return;
                }
                resourceDelta.accept(delta -> {
                    boolean isRootResource;
                    IResource resource = delta.getResource();
                    boolean bl = isRootResource = (resource.getType() & 8) != 0;
                    if (isRootResource) {
                        return true;
                    }
                    if (DVTFileUtils.getInstance().isProjectAdded(delta, resource) || DVTFileUtils.getInstance().isProjectChanged(delta, resource) || DVTFileUtils.getInstance().isProjectRemoved(delta, resource)) {
                        Set<String> newProjectPaths = this.getProjectsPaths();
                        if (this.mcpRegistry.getProjectPaths().equals(newProjectPaths)) {
                            return false;
                        }
                        this.mcpRegistry.setProjectPaths(newProjectPaths);
                        McpEndpointLogger.INSTANCE.writeRegistry(this.mcpRegistry);
                    }
                    return false;
                });
            }
            catch (CoreException coreException) {}
        });
    }

    @Override
    protected String getHostPlatform() {
        return "eclipse";
    }

    @Override
    protected String getVersion() {
        return DVTPlugin.getDefault().getVersion();
    }

    @Override
    protected boolean isPlatformRunnning() {
        return Platform.isRunning();
    }

    @Override
    protected Set<String> getProjectsPaths() {
        List<IProject> projects = List.of(DVTUtilsCommon.getProjects());
        return new HashSet<String>(projects.stream().map(p -> p.getLocation().toOSString()).toList());
    }
}

