/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.mcp;

import com.google.gson.annotations.SerializedName;
import java.util.Set;

public class McpRegistry {
    @SerializedName(value="id")
    private final String id;
    @SerializedName(value="host")
    private final String host;
    @SerializedName(value="port")
    private final Integer port;
    @SerializedName(value="version")
    private final String version;
    @SerializedName(value="hostPid")
    private final Integer hostPid;
    @SerializedName(value="hostPlatform")
    private final String hostPlatform;
    @SerializedName(value="projectPaths")
    private Set<String> projectPaths;

    public McpRegistry(String id, String host, Integer port, String version, Integer hostPid, String hostPlatform, Set<String> projectPaths) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.version = version;
        this.hostPid = hostPid;
        this.hostPlatform = hostPlatform;
        this.projectPaths = projectPaths;
    }

    private McpRegistry(Builder builder) {
        this.id = builder.id;
        this.host = builder.host;
        this.port = builder.port;
        this.version = builder.version;
        this.hostPid = builder.hostPid;
        this.hostPlatform = builder.hostPlatform;
        this.projectPaths = builder.projectPaths;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getProductPid() {
        return this.hostPid;
    }

    public String getProductType() {
        return this.hostPlatform;
    }

    public Set<String> getProjectPaths() {
        return this.projectPaths;
    }

    public void setProjectPaths(Set<String> projectPaths) {
        this.projectPaths = projectPaths;
    }

    public static class Builder {
        private String id;
        private String host;
        private Integer port;
        private String version;
        private Integer hostPid;
        private String hostPlatform;
        private Set<String> projectPaths;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder hostPid(Integer hostPid) {
            this.hostPid = hostPid;
            return this;
        }

        public Builder hostPlatform(String hostPlatform) {
            this.hostPlatform = hostPlatform;
            return this;
        }

        public Builder projectPaths(Set<String> projectPaths) {
            this.projectPaths = projectPaths;
            return this;
        }

        public McpRegistry build() {
            return new McpRegistry(this);
        }
    }
}

