/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.model;

import com.google.gson.annotations.SerializedName;
import java.util.Comparator;
import java.util.Objects;

public class CodeSnippet {
    @SerializedName(value="code")
    private String code;
    @SerializedName(value="filePath")
    private String filePath;
    @SerializedName(value="startLine")
    private int startLine;
    @SerializedName(value="endLine")
    private int endLine;
    public static final Comparator<CodeSnippet> DEFAULT_CODE_SNIPPETS_COMPARATOR = (codeSnippet1, codeSnippet2) -> {
        if (codeSnippet1.filePath != null && codeSnippet2.filePath != null && !codeSnippet1.filePath.equals(codeSnippet2.filePath)) {
            return codeSnippet1.filePath.compareTo(codeSnippet2.filePath);
        }
        if (codeSnippet1.filePath != null && codeSnippet1.filePath.equals(codeSnippet2.filePath)) {
            return Integer.compare(codeSnippet1.startLine, codeSnippet2.startLine);
        }
        return codeSnippet1.code.compareTo(codeSnippet2.code);
    };

    public CodeSnippet() {
    }

    public CodeSnippet(String code, String filePath, int startLine, int endLine) {
        this.code = this.removeCRCharsFromCode(code);
        this.filePath = filePath;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public int hashCode() {
        return Objects.hash(this.code, this.endLine, this.filePath, this.startLine);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeSnippet other = (CodeSnippet)obj;
        return Objects.equals(this.code, other.code) && this.endLine == other.endLine && Objects.equals(this.filePath, other.filePath) && this.startLine == other.startLine;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = this.removeCRCharsFromCode(code);
    }

    public void setCodeNoCRRemoval(String code) {
        this.code = code;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    private String removeCRCharsFromCode(String code) {
        if (code == null) {
            return null;
        }
        return code.replace("\r", "");
    }

    public String toString() {
        if (this.filePath == null) {
            return this.code;
        }
        return "* File `" + this.filePath + "`" + (this.startLine > 0 && this.endLine >= this.startLine ? (this.startLine == this.endLine ? ", line `" + this.startLine + "`" : ", lines `" + this.startLine + "-" + this.endLine + "`") : "") + ":\n```\n" + this.code + "\n```";
    }

    public String getLocationString() {
        if (this.filePath == null) {
            return null;
        }
        return "* File `" + this.filePath + "`" + (this.startLine > 0 && this.endLine >= this.startLine ? (this.startLine == this.endLine ? ", line `" + this.startLine + "`" : ", lines `" + this.startLine + "-" + this.endLine + "`") : "");
    }
}

