/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.model;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Objects;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.OutlineResult;
import ro.amiq.dvt.ai.model.TreeElement;

public class Dependency {
    @SerializedName(value="isOutline")
    private boolean isOutline;
    @SerializedName(value="outlineResult")
    private OutlineResult outlineResult;
    @SerializedName(value="codeSnippet")
    private CodeSnippet codeSnippet;

    public Dependency(boolean isOutline, OutlineResult outlineResult, CodeSnippet codeSnippet) {
        this.isOutline = isOutline;
        this.outlineResult = outlineResult;
        this.codeSnippet = codeSnippet;
    }

    public boolean isOutline() {
        return this.isOutline;
    }

    public OutlineResult getOutlineResult() {
        return this.outlineResult;
    }

    public CodeSnippet getCodeSnippet() {
        return this.codeSnippet;
    }

    public int hashCode() {
        return Objects.hash(this.codeSnippet, this.isOutline, this.outlineResult);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        return Objects.equals(this.codeSnippet, other.codeSnippet) && this.isOutline == other.isOutline && Objects.equals(this.outlineResult, other.outlineResult);
    }

    public int getCharCount() {
        if (!this.isOutline) {
            return this.codeSnippet == null || this.codeSnippet.getCode() == null ? 0 : this.codeSnippet.getCode().length();
        }
        if (this.outlineResult == null || this.outlineResult.getOutline() == null) {
            return 0;
        }
        List<TreeElement> roots = this.outlineResult.getOutline().getRoots();
        if (roots == null || roots.isEmpty()) {
            return 0;
        }
        return roots.stream().map(AIUtils.getInstance()::getCharCountOfTree).reduce(0, Integer::sum);
    }

    public String toString() {
        return this.isOutline ? this.outlineResult.toString() : this.codeSnippet.toString();
    }
}

