/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class EditorRange {
    @SerializedName(value="file")
    private IFile file;
    @SerializedName(value="startOffset")
    private int startOffset;
    @SerializedName(value="endOffset")
    private int endOffset;

    public EditorRange(IFile file, int startOffset, int endOffset) {
        this.file = file;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public IFile getFile() {
        return this.file;
    }

    public String getFullPath() {
        if (this.file == null) {
            return null;
        }
        IPath fullPath = this.file.getLocation();
        if (fullPath == null) {
            return null;
        }
        return fullPath.toOSString();
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int hashCode() {
        return Objects.hash(this.endOffset, this.getFullPath(), this.startOffset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditorRange other = (EditorRange)obj;
        return this.endOffset == other.endOffset && Objects.equals(this.getFullPath(), other.getFullPath()) && this.startOffset == other.startOffset;
    }
}

