/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.model;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Objects;
import ro.amiq.dvt.ai.model.TreeElement;

public class MultiRootTree {
    @SerializedName(value="roots")
    private List<TreeElement> roots;

    public MultiRootTree() {
    }

    public MultiRootTree(List<TreeElement> roots) {
        this.roots = roots;
    }

    public List<TreeElement> getRoots() {
        return this.roots;
    }

    public void setRoots(List<TreeElement> roots) {
        this.roots = roots;
    }

    public int hashCode() {
        return Objects.hash(this.roots);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiRootTree other = (MultiRootTree)obj;
        return Objects.equals(this.roots, other.roots);
    }

    public String toString() {
        if (this.roots == null || this.roots.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (TreeElement root : this.roots) {
            StringBuilder rootExpansion = new StringBuilder();
            this.expandTreeElementRecursive(root, 0, rootExpansion);
            result.append((CharSequence)rootExpansion);
        }
        return result.toString().trim();
    }

    private void expandTreeElementRecursive(TreeElement element, int indentLevel, StringBuilder result) {
        if (element == null) {
            return;
        }
        int i = 1;
        while (i <= indentLevel) {
            result.append("    ");
            ++i;
        }
        result.append(element.getElement()).append('\n');
        List<TreeElement> children = element.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (TreeElement child : children) {
            StringBuilder childExpansion = new StringBuilder();
            this.expandTreeElementRecursive(child, indentLevel + 1, childExpansion);
            result.append((CharSequence)childExpansion);
        }
    }
}

