/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.search.constraints;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.ai.tools.GetFieldConstraintsAITool;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.views.ConstraintsWalker;
import ro.amiq.edt.base.model.reflection.views.RfConstraintKind;
import ro.amiq.edt.base.ui.search.constraints.BaseEConstraintsSearchQuery;
import ro.amiq.edt.base.ui.search.constraints.ConstraintLineElement;
import ro.amiq.etools.eparser.EAST;

public class ConstraintsSearchQuery
extends BaseEConstraintsSearchQuery {
    private final List<GetFieldConstraintsAITool.ConstraintLocation> constraintsMatches = new ArrayList<GetFieldConstraintsAITool.ConstraintLocation>();

    public ConstraintsSearchQuery(RfNamedElement element) {
        super(element);
    }

    public List<GetFieldConstraintsAITool.ConstraintLocation> run() {
        this.setMonitor((IProgressMonitor)new NullProgressMonitor());
        this.computeMatches();
        return this.constraintsMatches;
    }

    protected void addMatch(ConstraintsWalker walker, EAST ast, RfConstraintKind kind) {
        ParserPath parserPath = walker.getParserPath();
        RfNamedElement field = (RfNamedElement)this.getField();
        if (field == null) {
            return;
        }
        RfProject rfProject = field.getRfProject();
        if (rfProject == null) {
            return;
        }
        IFile file = DVTFileUtils.getInstance().findProjectFile(this.getProject(), parserPath.path);
        LineInfo lineInfo = walker.getMacroSafeLine((AST)ast);
        int realOffset = lineInfo.realOffset;
        boolean isHitInMacroAndCall = false;
        boolean isHitInMacro = false;
        if (ast.getReparseStack() != null) {
            isHitInMacro = true;
            String call = this.getMacroCall(parserPath, lineInfo);
            if (call.isEmpty()) {
                isHitInMacro = false;
            } else {
                int index = call.indexOf(field.getName());
                while (index != -1) {
                    boolean charAfterIsOK;
                    boolean charBeforeIsOk = index == 0 || !Character.isJavaIdentifierPart(call.charAt(index - 1));
                    boolean bl = charAfterIsOK = index + field.getName().length() == call.length() || !Character.isJavaIdentifierPart(call.charAt(index + field.getName().length()));
                    if (charBeforeIsOk && charAfterIsOK) {
                        realOffset += index;
                        isHitInMacroAndCall = true;
                        break;
                    }
                    index = call.indexOf(field.getName(), index + 1);
                }
            }
        }
        int line = DVTFileUtils.getInstance().getLineFromOffset(file, realOffset);
        String lineContents = "";
        if (!isHitInMacroAndCall && isHitInMacro) {
            lineContents = DVTFileUtils.getInstance().getLineFromFile(file, lineInfo.line);
            line = lineInfo.line;
        } else {
            lineContents = DVTFileUtils.getInstance().getLineFromFile(file, line);
        }
        String scopeInfo = RfSearchUtils.getScopeInfo((IProject)this.getProject(), (ParserPath)parserPath, (int)lineInfo.line, (int)lineInfo.realOffset, (boolean)false);
        ConstraintLineElement lineEntry = new ConstraintLineElement((IResource)file, line, realOffset, lineContents, scopeInfo, kind);
        int lineOffset = DVTFileUtils.getInstance().getLineOffset(file, line - 1);
        int counter = this.countStartWS(lineContents);
        lineContents = lineContents.trim();
        String matchString = ast.getText();
        if (!isHitInMacroAndCall && isHitInMacro && ast.getReparseStack() != null) {
            matchString = lineContents;
        }
        lineEntry.setSearchedElement(matchString, realOffset - lineOffset - counter, false);
        this.constraintsMatches.add(new GetFieldConstraintsAITool.ConstraintLocation(parserPath.path, lineEntry.getLine()));
    }
}

