/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import com.networknt.schema.Error;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIToolErrorException;
import ro.amiq.dvt.ai.model.params.PrepareInvokeToolResponse;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.SchemaUtils;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;

public abstract class AITool {
    public static final String PROJECT_PATH_PARAM = "project_path";
    private static final String BUILD_IN_PROGRESS_RESPONSE_MESSAGE = "DVT is currently building the '%s' project. Please try again later.";
    private static final String BUILD_REQUIRED_RESPONSE_MESSAGE = "Project '%s' requires a full build. Please try again later.";

    protected abstract String invoke(BooleanSupplier var1, JsonObject var2);

    public String validateInputAndInvoke(BooleanSupplier isCanceled, JsonObject input) {
        try {
            long toolCallStartTime = System.currentTimeMillis();
            this.validateInput(input);
            IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
            if (iProject != null && AIToolUtils.INSTANCE.isFullBuildInProgress(iProject)) {
                return String.format(BUILD_IN_PROGRESS_RESPONSE_MESSAGE, iProject.getLocation().toOSString());
            }
            if (iProject != null && AIToolUtils.INSTANCE.isFullBuildRequired(iProject)) {
                return String.format(BUILD_REQUIRED_RESPONSE_MESSAGE, iProject.getLocation().toOSString());
            }
            String result = this.invoke(isCanceled, input);
            long toolCallDuration = System.currentTimeMillis() - toolCallStartTime;
            AIUtils.getInstance().writeDebugToAIToolsConsole(String.valueOf(this.getName()) + " tool was called with the following parameters: " + input + " [ " + toolCallDuration + "ms ]");
            return result;
        }
        catch (Exception e) {
            AIUtils.getInstance().writeErrorToAIToolsConsole(String.valueOf(this.getName()) + " tool call failed with the following error: ", e);
            throw e;
        }
    }

    private void validateInput(JsonObject input) {
        input.remove(null);
        input.remove("");
        JsonObject inputToValidate = input.deepCopy();
        inputToValidate.remove(PROJECT_PATH_PARAM);
        List<Error> validationErrors = SchemaUtils.INSTANCE.computeValidationErrors(this.getInputSchema(), inputToValidate);
        if (!validationErrors.isEmpty()) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, "Invalid Tool Arguments: " + System.lineSeparator() + validationErrors.stream().map(ve -> ve.getMessage()).collect(Collectors.joining(System.lineSeparator())), 0));
        }
    }

    private <A extends Annotation, T> Optional<T> getAnnotationValue(Class<A> annotationClass, Function<A, T> mapper) {
        Class<?> clazz = this.getClass();
        if (!clazz.isAnnotationPresent(annotationClass)) {
            return Optional.empty();
        }
        A annotation = clazz.getAnnotation(annotationClass);
        if (annotation == null) {
            return Optional.empty();
        }
        try {
            Method valueMethod = annotationClass.getMethod("value", new Class[0]);
            Object result = valueMethod.invoke(annotation, new Object[0]);
            return Optional.ofNullable(result);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return Optional.empty();
        }
    }

    public String getInputSchema() {
        return this.getAnnotationValue(ToolInputSchema.class, ToolInputSchema::value).orElse(null);
    }

    public String getName() {
        return this.getAnnotationValue(ToolName.class, ToolName::value).orElse(null);
    }

    public String getDisplayName() {
        return this.getAnnotationValue(ToolDisplayName.class, ToolDisplayName::value).orElse(null);
    }

    public String getDescription() {
        return this.getAnnotationValue(ToolDescription.class, ToolDescription::value).orElse(null);
    }

    public String getConfirmationMessage() {
        return this.getAnnotationValue(ToolConfirmationMessage.class, ToolConfirmationMessage::value).orElse(null);
    }

    public boolean getNeedsConfirmation() {
        return this.getAnnotationValue(ToolNeedsConfirmation.class, ToolNeedsConfirmation::value).orElse(false);
    }

    public PrepareInvokeToolResponse prepareInvoke(BooleanSupplier isCanceled, JsonObject input) {
        this.validateInput(input);
        return new PrepareInvokeToolResponse(this.getPreInvokeDisplayName(isCanceled, input), this.getPreInvokeConfirmationMessage(isCanceled, input));
    }

    public abstract String getPreInvokeConfirmationMessage(BooleanSupplier var1, JsonObject var2);

    public abstract String getPreInvokeDisplayName(BooleanSupplier var1, JsonObject var2);
}

