/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.tools.IAIToolUtils;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;

public enum AIToolUtils implements IAIToolUtils
{
    INSTANCE;


    @Override
    public IProject getToolCallProject(JsonObject input) {
        IProject inputProject = this.getIProject(input);
        if (inputProject == null) {
            return AIUtils.getInstance().getSelectedProject();
        }
        return inputProject;
    }

    private IProject getIProject(JsonObject input) {
        IContainer container;
        block7: {
            String projectPath;
            block6: {
                if (input == null) {
                    return null;
                }
                JsonElement projectPathElement = input.get("project_path");
                if (projectPathElement == null) {
                    return null;
                }
                try {
                    projectPath = projectPathElement.getAsString();
                    if (projectPath != null && !projectPath.isEmpty()) break block6;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path path = new Path(projectPath);
            container = root.getContainerForLocation((IPath)path);
            if (container instanceof IProject) break block7;
            return null;
        }
        return (IProject)container;
    }

    @Override
    public boolean isFullBuildInProgress(IProject iProject) {
        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(iProject, false);
        if (rfMixedLangProject == null) {
            return false;
        }
        if (rfMixedLangProject.isState(new RfProjectState[]{RfProjectState.NEW}) || rfMixedLangProject.isState(new RfProjectState[]{RfProjectState.NOT_RESTORED}) || rfMixedLangProject.isState(new RfProjectState[]{RfProjectState.BC_FAILED})) {
            return false;
        }
        return !rfMixedLangProject.isBuildDone() && !rfMixedLangProject.isState(new RfProjectState[]{RfProjectState.RESTORED});
    }

    @Override
    public boolean isFullBuildRequired(IProject iProject) {
        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(iProject, false);
        if (rfMixedLangProject == null) {
            return false;
        }
        return rfMixedLangProject.isState(new RfProjectState[]{RfProjectState.NEW}) || rfMixedLangProject.isState(new RfProjectState[]{RfProjectState.NOT_RESTORED}) || rfMixedLangProject.isState(new RfProjectState[]{RfProjectState.BC_FAILED});
    }
}

