/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum AIToolsIndexerUtils {
    INSTANCE;


    public int getTaggedElemOffsetInDocument(IDocument document, String surroundingCode, String startTag, String endTag) {
        String fileContent = document.get();
        String[] fileLines = fileContent.split("\n");
        String[] surroundingCodeLines = surroundingCode.split("\n");
        int taggedElemOffsetInLine = 0;
        int taggedElemLineInSurroundingCode = 0;
        int surroundingCodeStartLineInFile = -1;
        String[] stringArray = surroundingCodeLines;
        int n = surroundingCodeLines.length;
        int n2 = 0;
        while (n2 < n) {
            String surroundingCodeLine = stringArray[n2];
            if (surroundingCodeLine.contains(startTag) && surroundingCodeLine.contains(endTag)) {
                taggedElemOffsetInLine = surroundingCodeLine.trim().indexOf(startTag);
                break;
            }
            ++taggedElemLineInSurroundingCode;
            ++n2;
        }
        surroundingCodeLines[taggedElemLineInSurroundingCode] = surroundingCodeLines[taggedElemLineInSurroundingCode].replace(startTag, "").replace(endTag, "");
        int i = 0;
        while (i < fileLines.length - surroundingCodeLines.length) {
            boolean foundMatch = true;
            int j = 0;
            while (j < surroundingCodeLines.length) {
                if (!fileLines[i + j].trim().equals(surroundingCodeLines[j].trim())) {
                    foundMatch = false;
                    break;
                }
                ++j;
            }
            if (foundMatch) {
                surroundingCodeStartLineInFile = i;
                break;
            }
            ++i;
        }
        if (surroundingCodeStartLineInFile < 0) {
            return surroundingCodeStartLineInFile;
        }
        int taggedElemLineInFile = surroundingCodeStartLineInFile + taggedElemLineInSurroundingCode;
        try {
            String lineContent = document.get(document.getLineOffset(taggedElemLineInFile), document.getLineLength(taggedElemLineInFile));
            return document.getLineOffset(taggedElemLineInFile) + DVTStringUtil.countLeadingWhitespaces((String)lineContent) + taggedElemOffsetInLine;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }
}

