/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import java.util.Arrays;
import java.util.List;
import ro.amiq.dvt.ai.model.Tool;
import ro.amiq.dvt.ai.tools.AITool;
import ro.amiq.dvt.ai.tools.AIToolsRegistry;
import ro.amiq.dvt.ai.tools.GetCompiledFilesAITool;
import ro.amiq.dvt.ai.tools.GetDesignSubinstancesAITool;
import ro.amiq.dvt.ai.tools.GetDesignTopAITool;
import ro.amiq.dvt.ai.tools.GetFieldConstraintsAITool;
import ro.amiq.dvt.ai.tools.GetFileIdentifiersAITool;
import ro.amiq.dvt.ai.tools.GetIdentifierReferencesAITool;
import ro.amiq.dvt.ai.tools.GetProblemsAITool;
import ro.amiq.dvt.ai.tools.GetSymbolDefinitionsAITool;
import ro.amiq.dvt.ai.tools.GetSymbolDependenciesAITool;
import ro.amiq.dvt.ai.tools.GetSymbolLocationsAITool;
import ro.amiq.dvt.ai.tools.GetSymbolReferencesAITool;
import ro.amiq.dvt.ai.tools.GetVerificationSubcomponentsAITool;
import ro.amiq.dvt.ai.tools.GetVerificationTopAITool;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.SchemaUtils;

public class AIToolsRegistryCommon {
    protected static final List<AITool> AI_TOOLS = Arrays.asList(new GetSymbolDefinitionsAITool(), new GetSymbolLocationsAITool(), new GetSymbolReferencesAITool(), new GetIdentifierReferencesAITool(), new GetSymbolDependenciesAITool(), new GetCompiledFilesAITool(), new GetDesignTopAITool(), new GetDesignSubinstancesAITool(), new GetVerificationTopAITool(), new GetVerificationSubcomponentsAITool(), new GetFileIdentifiersAITool(), new GetProblemsAITool(), new GetFieldConstraintsAITool());

    public static void invalidateToolsCache() {
        AIToolsRegistry.getTools(true).forEach(t -> {
            if (t instanceof PaginatedAITool) {
                ((PaginatedAITool)t).invalidateCache();
            }
        });
    }

    public static Tool convertTool(AITool tool) {
        return new Tool(tool.getName(), tool.getDisplayName(), tool.getDescription(), tool.getNeedsConfirmation(), tool.getConfirmationMessage(), SchemaUtils.INSTANCE.convertSchema(tool.getInputSchema()));
    }
}

