/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.contributor.AILangContributorManager;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.MultiRootTree;
import ro.amiq.dvt.ai.model.TreeElement;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.ai.tools.pagination.utils.FlattenedTreeElement;
import ro.amiq.dvt.ai.tools.pagination.utils.MultiRootTreeFlattener;
import ro.amiq.dvt.utils.DVTFileUtils;

@ToolName(value="dvt_get_compiled_files")
@ToolDisplayName(value="Get Compiled Files (DVT)")
@ToolDescription(value="Returns the **absolute paths** of all files that DVT has compiled, arranged in a list.\n\nIn mixed-language projects the output is separated by language headings (SystemVerilog, VHDL, \u2026).\n\n**When to use**\n\n- When you need an accurate, ready-to-parse view of the compiled files for analysis, documentation, or automated refactoring.\n- When you need to extract the compiled files that match a specific criteria: compiled files under a certain directory, compiled files related to a specific protocol.\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Output format - examples**\n\n* SystemVerilog project (3 compiled files)\n```\n- /absolute/path/of/file1.sv\n- /absolute/path/of/file2.sv\n- /absolute/path/of/file3.sv\n```\n\n* Mixed project (SystemVerilog + VHDL, 5 compiled files)\n```\n# SystemVerilog\n- /absolute/path/of/file1.sv\n- /absolute/path/of/file2.sv\n- /absolute/path/of/file5.sv\n# VHDL\n- /absolute/path/of/file3.vhdl\n- /absolute/path/of/file4.vhdl\n```\n")
@ToolConfirmationMessage(value="This tool will retrieve the list of compiled files.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n\t\"filter\": {\n      \"type\": \"string\",\n      \"nullable\": true,\n      \"description\": \"Glob pattern to include only compiled files whose paths match it (e.g., '**/apb/**' for compiled files under the 'apb' directory, '**/*.svh' for compiled files with the '.svh' extension).\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"additionalProperties\": false\n}\n")
public class GetCompiledFilesAITool
extends PaginatedAITool {
    static final String CONFIRMATION_MESSAGE = "This tool will retrieve the list of compiled files.\nDo you want to continue?\n";
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 40;

    @Override
    protected String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeCompiledFilesTreeFlatten);
        if (result.getTotalElements() == 0) {
            return "No DVT compiled files were found for the given input!";
        }
        return result.toString("Compiled Files");
    }

    private MultiRootTree computeCompiledFilesTree(BooleanSupplier isCanceled, JsonObject input) {
        EnumMap<LanguageKind, List<TreeElement>> languageToRoots = new EnumMap<LanguageKind, List<TreeElement>>(LanguageKind.class);
        for (IAILangContributor aiContributor : AILangContributorManager.INSTANCE.getContributors()) {
            List<TreeElement> languageRoots = aiContributor.getCompiledFilesTree(AIToolUtils.INSTANCE.getToolCallProject(input));
            if (languageRoots == null || languageRoots.isEmpty()) continue;
            languageToRoots.put(aiContributor.getLanguage(), languageRoots);
        }
        if (languageToRoots.isEmpty()) {
            return null;
        }
        if (languageToRoots.size() == 1) {
            return new MultiRootTree((List)new ArrayList(languageToRoots.values()).get(0));
        }
        ArrayList<TreeElement> roots = new ArrayList<TreeElement>();
        for (Map.Entry entry : languageToRoots.entrySet()) {
            roots.add(new TreeElement(((LanguageKind)entry.getKey()).getViewName(), (List)entry.getValue()));
        }
        return new MultiRootTree(roots);
    }

    public List<String> computeCompiledFilesTreeFlatten(BooleanSupplier isCanceled, JsonObject input) {
        MultiRootTree compiledFilesTree = this.computeCompiledFilesTree(isCanceled, input);
        List<FlattenedTreeElement> compiledFiles = MultiRootTreeFlattener.flatten(compiledFilesTree);
        String filter = this.getFilter(input);
        if (filter == null) {
            return compiledFiles.stream().map(cf -> {
                if (cf.getLabel().contains(LanguageKind.VLOG.VIEW_NAME) || cf.getLabel().contains(LanguageKind.VHDL.VIEW_NAME) || cf.getLabel().contains(LanguageKind.E.VIEW_NAME)) {
                    return String.format("# %s%n", cf.getLabel());
                }
                return String.format("- %s%n", cf.getLabel());
            }).distinct().collect(Collectors.toList());
        }
        if (DVTFileUtils.getInstance().pathStartsWithADriveLetter(filter)) {
            filter = filter.replace("\\", "\\\\");
        }
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + filter);
        return compiledFiles.stream().filter(cf -> {
            if (cf.getLabel().contains(LanguageKind.VLOG.VIEW_NAME) || cf.getLabel().contains(LanguageKind.VHDL.VIEW_NAME) || cf.getLabel().contains(LanguageKind.E.VIEW_NAME)) {
                return true;
            }
            return pathMatcher.matches(Paths.get(cf.getLabel(), new String[0]));
        }).map(cf -> {
            if (cf.getLabel().contains(LanguageKind.VLOG.VIEW_NAME) || cf.getLabel().contains(LanguageKind.VHDL.VIEW_NAME) || cf.getLabel().contains(LanguageKind.E.VIEW_NAME)) {
                return String.format("# %s%n", cf.getLabel());
            }
            return String.format("- %s%n", cf.getLabel());
        }).distinct().collect(Collectors.toList());
    }

    private String getFilter(JsonObject input) {
        String filterString;
        block5: {
            JsonElement filterElement;
            block4: {
                try {
                    filterElement = input.get("filter");
                    if (filterElement != null) break block4;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            filterString = filterElement.getAsString();
            if (!filterString.isBlank()) break block5;
            return null;
        }
        return filterString;
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return CONFIRMATION_MESSAGE;
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        return "Get Compiled Files";
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 40;
    }
}

