/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIInternalErrorException;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;

@ToolName(value="dvt_get_design_subinstances")
@ToolDisplayName(value="Get Design Subinstances (DVT)")
@ToolDescription(value="Retrieves all sub-instances of a specified design element, i.e., all the other design blocks that are instantiated inside the given element.\n\n**Usage**\n\nProvide the target element with the `design_element_path` argument. Examples:\n- To list the direct sub-instances of the top module `top_m`, use `top_m`.\n- To list the sub-instances inside a particular instance, e.g., instance `i_subm` of `top_m`, use `top_m.i_subm`.\n\n**When to use**\n\nCombine this tool with the *dvt_get_design_top* call to navigate and understand the full RTL hierarchy of the working project.\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Output format**\n\nThe result is a plain-text list, one line per sub-instance, formatted as:\n\n```\n<instance_name> : <module_name>\n```\n\nFor example, if the queried element contains an instance `i_mod1` of module `mod1` and an instance `i_mod2` of module `mod2`, the output will be:\n\n```\ni_mod1 : mod1\ni_mod2 : mod2\n```\n")
@ToolConfirmationMessage(value="This tool will retrieve all the direct design subinstances of the given element.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n    \"design_element_path\": {\n      \"type\": \"string\",\n      \"description\": \"The hierarchical path of the design element whose subinstances should be retrieved. This path is composed of subinstance names separated by dots, starting from the design top element, e.g., 'top.i_socv.i_dma'.\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"required\": [\"design_element_path\"],\n  \"additionalProperties\": false\n}\n")
public class GetDesignSubinstancesAITool
extends PaginatedAITool {
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 10;
    private static final String SUBINSTANCES_SEPARATOR = System.lineSeparator();

    @Override
    protected String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeSubInstances);
        if (result.getTotalElements() == 0) {
            return "No subinstances found for the given `design_element_path`!";
        }
        return result.toString("Design Subinstances");
    }

    private List<String> computeSubInstances(BooleanSupplier isCanceled, JsonObject input) {
        String designElementPath = input.get("design_element_path").getAsString();
        IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
        if (iProject == null) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to determine the current working project!", 0));
        }
        String[] pathSegments = designElementPath.split("\\.");
        List childInstances = DHBreadcrumbUtils.getChildInstances((ElementPath)ElementPath.create(Arrays.asList(pathSegments)), (IProject)iProject, (int)Integer.MAX_VALUE);
        if (childInstances == null || childInstances.isEmpty()) {
            return List.of();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ELInstance childInstance : childInstances) {
            String instanceName;
            ElementPath hierarchyPath;
            String bindingName;
            IRfNamedElement binding = childInstance.getBinding(false);
            if (binding == null || (bindingName = binding.getFullNameLabel()) == null || bindingName.isEmpty() || (hierarchyPath = childInstance.getHierarchyPath()) == null || (instanceName = hierarchyPath.lastSegment()) == null || instanceName.isEmpty()) continue;
            result.add(String.valueOf(instanceName) + " : " + bindingName + SUBINSTANCES_SEPARATOR);
        }
        return result;
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        String designElementPath = input.get("design_element_path").getAsString();
        return "This tool will retrieve all the direct design subinstances of the design element identified by path '%s'.\nDo you want to continue?\n".formatted(designElementPath);
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        String designElementPath = input.get("design_element_path").getAsString();
        return "Get Design Subinstances - '%s'".formatted(designElementPath);
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 10;
    }
}

