/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIInternalErrorException;
import ro.amiq.dvt.ai.tools.AITool;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;

@ToolName(value="dvt_get_design_top")
@ToolDisplayName(value="Get Design Top (DVT)")
@ToolDescription(value="Retrieves the name(s) of the highest-level design element(s) in the project: the top module that directly or indirectly instantiates every other RTL block.\n\n**When to use**\n\nKnowing the design top is the first step to navigating the hierarchy; combine this call with *dvt_get_design_subinstances* to map the full RTL structure of the running project.\n\n**Output format**\n\nThe tool returns the design-top element name. If the project has multiple tops, each name is emitted on its own line.\n")
@ToolConfirmationMessage(value="This tool will retrieve the design hierarchy top.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {},\n  \"additionalProperties\": false\n}\n")
public class GetDesignTopAITool
extends AITool {
    static final String CONFIRMATION_MESSAGE = "This tool will retrieve the design hierarchy top.\nDo you want to continue?\n";
    private static final Set<String> designLanguageNatures = new HashSet<String>(Arrays.asList("ro.amiq.vlogdt.VlogNature", "ro.amiq.vhdldt.VhdlNature"));
    private static final String DESIGN_TOPS_SEPARATOR = "\n";

    @Override
    protected String invoke(BooleanSupplier isCanceled, JsonObject input) {
        IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
        if (iProject == null) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to determine the current working project!", 0));
        }
        HashSet topElements = new HashSet();
        for (String nature : designLanguageNatures) {
            List topDesignsForLanguage;
            ELManager elManager;
            IRfSingleLangProject singleLangProject;
            if (!DVTNature.hasNature((IProject)iProject, (String)nature) || (singleLangProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, nature, false)) == null || (elManager = singleLangProject.getELManager()) == null || (topDesignsForLanguage = elManager.getTopDesigns()) == null) continue;
            topElements.addAll(topDesignsForLanguage);
        }
        if (topElements.isEmpty()) {
            return "Project does not have a design top set!";
        }
        StringJoiner joiner = new StringJoiner(DESIGN_TOPS_SEPARATOR);
        for (IRfDesignElement topElement : topElements) {
            String topElementName = topElement.getFullNameLabel();
            if (topElement instanceof IRfEntityComplement) {
                topElementName = ((IRfEntityComplement)topElement).getEntityName();
            }
            joiner.add(topElementName);
        }
        return joiner.toString();
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return CONFIRMATION_MESSAGE;
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        return "Get Design Top";
    }
}

