/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.contributor.AILangContributorManager;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIInternalErrorException;
import ro.amiq.dvt.ai.model.exceptions.AIToolErrorException;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.AIToolsIndexerUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.utils.DVTFileUtils;

@ToolName(value="dvt_get_field_constraints")
@ToolDisplayName(value="Get Field Constraints (DVT)")
@ToolDescription(value="Constraints are crucial for RTL verification. Their purpose is to put restrictions over randomized input data feed to the DUT.\nThis tool fetches all of the constraints associated with a field. For each constraint, the location and 1-line context around the constraint are provided.\n\n**When to use**\n* Understand field behavior - Quickly see what valid values a randomized field can take without manually reading through constraint blocks.\n* Debug constraint violations - When a randomization fails, identify all constraints that may conflict or overconstrain the field.\n* Verify constraint completeness - Ensure all necessary constraints exist for a field (e.g. alignment, range, cross-field dependencies).\n\n**Tool input**\n\n* `file_name_or_path` - the file name, absolute path or relative (to project root directory) path of the file that contains the field definition. **Prefer using absolute or relative paths, when possible.**\n* `field_surrounding_code` - the exact line (including leading / trailing whitespace) where the field appears, with the field wrapped in <FIELD> **and** </FIELD> tags. If that line occurs multiple times in the file, include additional surrounding lines to make the match unique. **Use entire lines only, leading / trailing whitespace included!**\n\nExample: suppose you have the following code, in file '/path/to/file.sv':\n\n```\n  virtual function void build();\n    char_len = uvm_reg_field::type_id::create(\"char_len\");\n\t...\n  endfunction : build\n```\n\nTo find all constraints for the `char_len` field, call the tool with:\n\n* `file_name_or_path`: \"path/to/file.sv\"\n* `field_surrounding_code`: \"  <FIELD>char_len</FIELD> = uvm_reg_field::type_id::create(\"char_len\");\"\n\n**IMPORTANT: Use the <FIELD> and </FIELD> tags around the field you want to search constraints for in the string passed as field_surrounding_code argument. Otherwise, the field will not be recognized.**\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n```\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n    \"file_name_or_path\": {\n\t  \"type\": \"string\",\n\t  \"description\": \"The file name, absolute path or relative (to project root directory) path of the file where the field is located.\"\n    },\n    \"field_surrounding_code\": {\n\t  \"type\": \"string\",\n\t  \"description\": \"One or more lines that can be uniquely located in the file and contain the field to search constraints for, with the field marked by <FIELD> and </FIELD> tags.\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"required\": [\"file_name_or_path\", \"field_surrounding_code\"],\n  \"additionalProperties\": false\n}\n")
public class GetFieldConstraintsAITool
extends PaginatedAITool {
    static final String CONFIRMATION_MESSAGE = "This tool will retrieve the list of constraints assoiciated to the provided field.\nDo you want to continue?\n";
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 60;
    private static final String FIELD_START_TAG = "<FIELD>";
    private static final String FIELD_END_TAG = "</FIELD>";

    @Override
    protected String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeFieldConstraints);
        if (result.getTotalElements() == 0) {
            return "No constraints found!";
        }
        return result.toString("Field Constraints");
    }

    private List<String> computeFieldConstraints(BooleanSupplier isCanceled, JsonObject input) {
        IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
        String fullPath = AIPathUtils.INSTANCE.getAbsolutePathFromFileNameOrPath(input.get("file_name_or_path").getAsString(), iProject, isCanceled);
        if (!new File(fullPath).exists()) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("File %s does not exist!", fullPath), 0));
        }
        if (AIProtectManager.INSTANCE.isFileProtected(fullPath, iProject)) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("Failed to read file '%s'. Access to this file is restricted by the user. NEVER try to read or write this file!", fullPath), 0));
        }
        IDocument document = AIUtils.getInstance().getDocumentFromPath(iProject, fullPath);
        IFile iFile = DVTFileUtils.getInstance().findProjectFile(iProject, fullPath);
        if (document == null || iFile == null) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("Failed to read file %s!", fullPath), 0));
        }
        String fieldSurroundingCode = input.get("field_surrounding_code").getAsString();
        if (!fieldSurroundingCode.contains(FIELD_START_TAG) || !fieldSurroundingCode.contains(FIELD_END_TAG)) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, String.format("Argument field_surrounding_code does not contain %s and %s tags to mark the identifier!", FIELD_START_TAG, FIELD_END_TAG), 0));
        }
        int fieldOffsetInDocument = AIToolsIndexerUtils.INSTANCE.getTaggedElemOffsetInDocument(document, fieldSurroundingCode, FIELD_START_TAG, FIELD_END_TAG);
        if (fieldOffsetInDocument < 0) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Field could not be located!", 0));
        }
        IRfNamedElementAndScope namedElementAndScope = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(new EditorPosition(iFile, fieldOffsetInDocument));
        if (namedElementAndScope == null || namedElementAndScope.getIRfNamedElement() == null) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Identifier could not be located!", 0));
        }
        LanguageKind languageKind = namedElementAndScope.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Could not find language contributor", 0));
        }
        List<ConstraintLocation> constraints = aiContributor.computeConstraints(namedElementAndScope.getIRfNamedElement());
        return constraints.stream().map(c -> this.convertLocationToResultString(iProject, (ConstraintLocation)c)).collect(Collectors.toList());
    }

    private String convertLocationToResultString(IProject project, ConstraintLocation location) {
        IFile file = DVTFileUtils.getInstance().findProjectFile(project, location.getFilePath());
        String linesFromFile = DVTFileUtils.getInstance().getLinesFromFile(file, Math.max(location.getLine() - 1, 1), location.getLine() + 1, null);
        return "* " + location.toString() + "Surrounding code:\n```\n" + linesFromFile + "```\n";
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return CONFIRMATION_MESSAGE;
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        return "Get Field Constraints";
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 60;
    }

    public static class ConstraintLocation {
        private String filePath;
        private int line;

        public ConstraintLocation(String filePath, int line) {
            this.filePath = filePath;
            this.line = line;
        }

        public String toString() {
            return "Constraint location: file `" + this.filePath + "`, line `" + this.line + "`" + System.lineSeparator();
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }
    }
}

