/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIInternalErrorException;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.macroexpansion.MacroScanner;

@ToolName(value="dvt_get_file_identifiers")
@ToolDisplayName(value="Get File Identifiers (DVT)")
@ToolDescription(value="Gets all identifiers that appear in a given source file, grouped by the line on which each identifier is found.\nIdentifiers include variable names, type names, macros and any other symbols defined by the user; built-in types and language keywords are omitted.\n\n**Usage**\n\nPass the file name, absolute path or relative (to project root directory) path of the file as the `file_name_or_path` argument. Example: `dvt_get_file_identifiers(file_name_or_path=\"path/to/file.sv\")`\n**Prefer using absolute or relative paths, when possible.**\n\n**When to use**\n\n- To separate language keywords from the actual identifiers used in a file.\n- For static analysis, refactoring impact checks, or documentation generation that requires a line-by-line view of user symbols.\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Output format**\n\nThe tool returns a list where each line shows the line number followed by a colon and a comma-separated list of identifiers found on that line, e.g.:\n\n* Line 1: clk, reset_n, enable\n* Line 2: data_in, data_out\n* Line 5: CONFIG_VALUE, THRESHOLD\n* ...\n")
@ToolConfirmationMessage(value="This tool will retrieve all identifiers that appear in a given source file.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n    \"file_name_or_path\": {\n      \"type\": \"string\",\n      \"description\": \"The file name, absolute path or relative (to project root directory) path of the file to extract identifiers for.\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"required\": [\"file_name_or_path\"],\n  \"additionalProperties\": false\n}\n")
public class GetFileIdentifiersAITool
extends PaginatedAITool {
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 15;
    private static final String INCLUDE_STATEMENT_START = "`include";
    private static final Set<String> IGNORED_IDENTIFIERS = new HashSet<String>(Arrays.asList("this", "super", "true", "false", "ps", "ns", "us", "ms", "std_logic_vector", "byte_array"));

    public List<String> computeFileIdentifiers(BooleanSupplier isCanceled, JsonObject input) {
        IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
        if (iProject == null) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to determine the current working project!", 0));
        }
        String fullPath = AIPathUtils.INSTANCE.getAbsolutePathFromFileNameOrPath(input.get("file_name_or_path").getAsString(), iProject, isCanceled);
        if (!new File(fullPath).exists()) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("File %s does not exist!", fullPath), 0));
        }
        if (AIProtectManager.INSTANCE.isFileProtected(fullPath, iProject)) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("Failed to read file '%s'. Access to this file is restricted by the user. NEVER try to read or write this file!", fullPath), 0));
        }
        HashMap<Integer, Set<String>> lineNumberToIdentifiers = new HashMap<Integer, Set<String>>();
        if (RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.E.NATURE_ID, false) != null) {
            this.collectIdentifiersELang(fullPath, lineNumberToIdentifiers, iProject);
        } else {
            List<IRfDefElement> fileContainers = AIUtils.getInstance().getContainersInFile(fullPath, iProject, true);
            if (fileContainers == null || fileContainers.isEmpty()) {
                return Collections.emptyList();
            }
            for (IRfDefElement container : fileContainers) {
                IRfNamedElement namedElement = container.getNamedElement();
                if (namedElement == null) continue;
                this.collectIdentifiersFromNamedElement(namedElement, lineNumberToIdentifiers);
            }
            this.collectMacroNames(fullPath, lineNumberToIdentifiers, iProject);
        }
        List<String> response = this.formatIdentifiers(lineNumberToIdentifiers, fullPath, RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.VHDL.NATURE_ID, false) != null, iProject);
        if (response == null) {
            return Collections.emptyList();
        }
        return response;
    }

    @Override
    protected String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeFileIdentifiers);
        if (result.getTotalElements() == 0) {
            return "Did not find any identifiers in the given file!";
        }
        return result.toString("File Identifiers");
    }

    private void collectIdentifiersFromNamedElement(IRfNamedElement namedElement, final Map<Integer, Set<String>> lineNumberToIdentifiers) {
        namedElement.visitHidObject(namedElement.getRfProject(), (IHidVisitor)new IHidVisitor<IHidObject>(){

            public boolean visit(IHidObject hidObject) {
                if (hidObject instanceof IHidOperator) {
                    IHidOperator hidOperator = (IHidOperator)hidObject;
                    IHidObject lhValue = hidOperator.getLHValue();
                    if (lhValue instanceof Hid) {
                        Hid hid = (Hid)lhValue;
                        GetFileIdentifiersAITool.this.addIdentifierToLineMapping(hid.getName(), hid.getLine(), lineNumberToIdentifiers);
                        return true;
                    }
                    if (lhValue instanceof IHidImplicit) {
                        IHidImplicit hidImplicit = (IHidImplicit)lhValue;
                        if (!hidImplicit.isID()) {
                            return true;
                        }
                        GetFileIdentifiersAITool.this.addIdentifierToLineMapping(hidImplicit.getName(), hidOperator.getLine(), lineNumberToIdentifiers);
                        return true;
                    }
                    return true;
                }
                if (hidObject instanceof Hid) {
                    Hid hid = (Hid)hidObject;
                    GetFileIdentifiersAITool.this.addIdentifierToLineMapping(hid.getName(), hid.getLine(), lineNumberToIdentifiers);
                    return true;
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
        this.visitLocalMembers(namedElement, lineNumberToIdentifiers);
    }

    private void collectMacroNames(String filePath, Map<Integer, Set<String>> lineNumberToIdentifiers, IProject iProject) {
        IDocumentPartitioner documentPartitioner;
        IDocument document = AIUtils.getInstance().getDocumentFromPath(iProject, filePath);
        if (document == null) {
            return;
        }
        if (iProject == null) {
            return;
        }
        IRfSingleLangProject iRfSingleLangProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.VLOG.NATURE_ID, false);
        if (!(iRfSingleLangProject instanceof ro.amiq.vlogdt.model.reflection.RfProject)) {
            return;
        }
        MacroScanner scanner = new MacroScanner();
        String contentType = null;
        if (document instanceof IDocumentExtension3 && (documentPartitioner = ((IDocumentExtension3)document).getDocumentPartitioner("__vlog_partitioning")) != null) {
            contentType = documentPartitioner.getContentType(0);
        }
        scanner.init(contentType);
        List macroMatches = scanner.getMacroMatches((CharSequence)document.get(), (ro.amiq.vlogdt.model.reflection.RfProject)iRfSingleLangProject, document.getNumberOfLines(), new ParserPath(filePath), null, false);
        if (macroMatches == null) {
            return;
        }
        for (MacroScanner.Match macroMatch : macroMatches) {
            this.addIdentifierToLineMapping(macroMatch.getName(), macroMatch.getRelativeLine() + 1, lineNumberToIdentifiers);
        }
    }

    private void visitLocalMembers(IRfNamedElement namedElement, Map<Integer, Set<String>> lineNumberToIdentifiers) {
        List localMembers;
        List arguments;
        RfNamedElement rfNamedElement;
        Collection declarations = namedElement.getDeclarations();
        if (declarations != null) {
            for (IRfDefElement declaration : declarations) {
                this.addIdentifierToLineMapping(AIUtils.getInstance().getElementName(namedElement), declaration.getStartLine(), lineNumberToIdentifiers);
                if (!(namedElement instanceof IRfAssociatedTypeElement)) continue;
                this.addAssociatedTypeIdentifier((IRfAssociatedTypeElement)namedElement, declaration.getStartLine(), lineNumberToIdentifiers);
            }
        }
        if (namedElement instanceof RfNamedElement) {
            RfClass parent;
            rfNamedElement = (RfNamedElement)namedElement;
            if (rfNamedElement instanceof RfClass && (parent = ((RfClass)rfNamedElement).getParent()) != null) {
                this.addIdentifierToLineMapping(AIUtils.getInstance().getElementName(parent), namedElement.getLine(), lineNumberToIdentifiers);
            }
            if (rfNamedElement instanceof RfFunction && (arguments = ((RfFunction)rfNamedElement).getArguments()) != null) {
                for (IRfFieldElement arg : arguments) {
                    this.visitLocalMembers((IRfNamedElement)arg, lineNumberToIdentifiers);
                }
            }
            if ((localMembers = rfNamedElement.getLocalMembers(false, IRfNamedElement.class)) != null) {
                for (IRfNamedElement localMember : localMembers) {
                    this.visitLocalMembers(localMember, lineNumberToIdentifiers);
                }
            }
        }
        if (namedElement instanceof ro.amiq.vhdldt.model.reflection.RfNamedElement) {
            rfNamedElement = (ro.amiq.vhdldt.model.reflection.RfNamedElement)namedElement;
            if (rfNamedElement instanceof IRfEntityComplement) {
                this.addIdentifierToLineMapping(((IRfEntityComplement)rfNamedElement).getEntityName(), namedElement.getLine(), lineNumberToIdentifiers);
            }
            if (rfNamedElement instanceof ro.amiq.vhdldt.model.reflection.RfFunction) {
                arguments = rfNamedElement.getArguments();
                for (IRfFieldElement arg : arguments) {
                    this.visitLocalMembers((IRfNamedElement)arg, lineNumberToIdentifiers);
                }
            }
            if ((localMembers = rfNamedElement.getLocalMembers(true, IRfNamedElement.class)) != null) {
                for (IRfNamedElement localMember : localMembers) {
                    this.visitLocalMembers(localMember, lineNumberToIdentifiers);
                }
            }
        }
    }

    private void addAssociatedTypeIdentifier(IRfAssociatedTypeElement associatedTypeElement, int line, Map<Integer, Set<String>> lineNumberToIdentifiers) {
        IRfNamedElement associatedType = associatedTypeElement.getAssociatedType();
        if (associatedType instanceof IRfTypeAliasElement) {
            associatedType = ((IRfTypeAliasElement)associatedType).getTranslatedType();
        }
        if (associatedType == null || associatedType.isPredefined()) {
            return;
        }
        if (associatedType instanceof IRfListType) {
            this.addAssociatedTypeIdentifier((IRfAssociatedTypeElement)((IRfListType)associatedType), line, lineNumberToIdentifiers);
            return;
        }
        this.addIdentifierToLineMapping(AIUtils.getInstance().getElementName(associatedType), line, lineNumberToIdentifiers);
    }

    private void collectIdentifiersELang(String filePath, Map<Integer, Set<String>> lineNumberToIdentifiers, IProject iProject) {
        IDocument document = AIUtils.getInstance().getDocumentFromPath(iProject, filePath);
        if (document == null) {
            return;
        }
        if (iProject == null) {
            return;
        }
        IFile iFile = DVTFileUtils.getInstance().findProjectFile(iProject, filePath);
        if (iFile == null) {
            return;
        }
        IRfSingleLangProject iRfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.E.NATURE_ID, false);
        if (!(iRfProject instanceof RfProject)) {
            return;
        }
        RfWNamedElementAndScope elementAndScope = RfUtils.getNamedElementAndScope((RfProject)((RfProject)iRfProject), (IFile)iFile, (IDocument)document, (int)0);
        if (elementAndScope == null) {
            return;
        }
        IRfScope fileScope = elementAndScope.getScope();
        if (!(fileScope instanceof RfModule)) {
            return;
        }
        List allIdentifiers = ((RfModule)fileScope).getAllIdentifiers();
        for (RfModule.IdentifierPosition identifier : allIdentifiers) {
            if (identifier.isDeleted()) continue;
            this.addIdentifierToLineMapping(identifier.getText(), identifier.getIdAst().getLine(), lineNumberToIdentifiers);
        }
    }

    private void addIdentifierToLineMapping(String identifierName, int line, Map<Integer, Set<String>> lineNumberToIdentifiers) {
        if (identifierName == null || line <= 0 || IGNORED_IDENTIFIERS.contains(identifierName.toLowerCase())) {
            return;
        }
        Set<String> identifiersForLine = lineNumberToIdentifiers.get(line);
        if (identifiersForLine == null) {
            lineNumberToIdentifiers.put(line, new LinkedHashSet<String>(Arrays.asList(identifierName)));
        } else {
            identifiersForLine.add(identifierName);
        }
    }

    private List<String> formatIdentifiers(Map<Integer, Set<String>> lineNumberToIdentifiers, String filePath, boolean isVHDL, IProject iProject) {
        if (lineNumberToIdentifiers.isEmpty()) {
            return null;
        }
        IDocument document = AIUtils.getInstance().getDocumentFromPath(iProject, filePath);
        if (document == null) {
            return null;
        }
        String fileContent = document.get();
        if (fileContent == null) {
            return null;
        }
        String[] fileLines = fileContent.split("\n");
        ArrayList<String> result = new ArrayList<String>();
        List lineNumbersSorted = new ArrayList<Integer>(lineNumberToIdentifiers.keySet()).stream().sorted().toList();
        for (Integer lineNumber : lineNumbersSorted) {
            List<String> identifiersOnLine;
            if (lineNumber >= fileLines.length) break;
            StringBuilder sb = new StringBuilder();
            String fileLine = fileLines[lineNumber - 1];
            if (fileLine.contains(INCLUDE_STATEMENT_START) || (identifiersOnLine = lineNumberToIdentifiers.get(lineNumber).stream().filter(identifier -> !isVHDL && fileLine.contains((CharSequence)identifier) || isVHDL && fileLine.toLowerCase().contains(identifier.toLowerCase())).toList()).isEmpty()) continue;
            sb.append("* Line ").append(lineNumber).append(": ");
            StringJoiner joiner = new StringJoiner(", ");
            identifiersOnLine.stream().forEach(joiner::add);
            sb.append(joiner.toString()).append(System.lineSeparator());
            result.add(sb.toString());
        }
        return result;
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return "This tool will retrieve all identifiers that appear in '%s'.\nDo you want to continue?\n".formatted(input.get("file_name_or_path").getAsString());
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
        String fullPath = AIPathUtils.INSTANCE.getAbsolutePathFromFileNameOrPath(input.get("file_name_or_path").getAsString(), iProject, isCanceled);
        File file = new File(fullPath);
        if (!file.exists()) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("File %s does not exist!", fullPath), 0));
        }
        return "Get File Identifiers - '%s'".formatted(file.getName());
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 15;
    }
}

