/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AISnippetSolver;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.EditorRange;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIInternalErrorException;
import ro.amiq.dvt.ai.model.exceptions.AIToolErrorException;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.AIToolsIndexerUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.utils.DVTFileUtils;

@ToolName(value="dvt_get_identifier_references")
@ToolDisplayName(value="Get Identifier References (DVT)")
@ToolDescription(value="Finds all usages of a specified identifier within the project and returns each usage with the file name, line range, and a 10-line context around the reference.\n\n**When to use**\n\nUse this tool for code comprehension, impact analysis before a refactor, or to trace data flow.\n**It is more precise than a simple text search because it uses a code indexer, so choose this tool over simple text search / grep tools.**\n\nTypical scenarios:\n\n* Find where a field of a class is used.\n* Find where a local variable of a function is used.\n* Find where a function argument is referenced.\n* Find where a struct member is used.\n\n**Tool input**\n\n* `file_name_or_path` - the file name, absolute path or relative (to project root directory) path of the file that contains the identifier definition. **Prefer using absolute or relative paths, when possible.**\n* `identifier_surrounding_code` - the exact line (including leading / trailing whitespace) where the identifier appears, with the identifier wrapped in <IDENTIFIER> **and** </IDENTIFIER> tags. If that line occurs multiple times in the file, include additional surrounding lines to make the match unique. **Use entire lines only, leading / trailing whitespace included!**\n\nExample: suppose you have the following code, in file '/path/to/file.sv':\n\n```\n  function new(string name, uvm_component parent);\n    ...\n  endfunction : new\n```\n\nTo find all references for the `name` argument of the `new` function, call the tool with:\n\n* `file_name_or_path: \"path/to/file.sv\"`\n* `identifier_surrounding_code: \"  function new(string <IDENTIFIER>name</IDENTIFIER>, uvm_component parent);\"`\n\n**IMPORTANT: Use the <IDENTIFIER> and </IDENTIFIER> tags around the identifier you want to search references for in the string passed as identifier_surrounding_code argument. Otherwise, the identifier will not be recognized.**\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Output format**\n\nFor each reference the tool returns a block similar to the following:\n\n* File `the/path/to/file/with/identifier/references/`, lines `100-110`:\n\n```\ncontext line 1 before the reference\n...\ncontext line 5 before the reference\nTHE LINE CONTAINING THE REFERENCE TO xyz\ncontext line 1 after the reference\n...\ncontext line 5 after the reference\n```\n\nEach block lists the file location, the range of lines displayed, and up to ten lines of surrounding code (five before and five after the reference).\n")
@ToolConfirmationMessage(value="This tool will retrieve all usages of the specified identifier within the project.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n    \"file_name_or_path\": {\n\t  \"type\": \"string\",\n\t  \"description\": \"The file name, absolute path or relative (to project root directory) path of the file where the identifier is located.\"\n    },\n    \"identifier_surrounding_code\": {\n\t  \"type\": \"string\",\n\t  \"description\": \"One or more lines that can be uniquely located in the file and contain the identifier to search references for, with the identifier marked by <IDENTIFIER> and </IDENTIFIER> tags.\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"required\": [\"file_name_or_path\", \"identifier_surrounding_code\"],\n  \"additionalProperties\": false\n}\n")
public class GetIdentifierReferencesAITool
extends PaginatedAITool {
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 150;
    private static final int NUMBER_OF_SURROUNDING_LINES_FOR_REFERENCES = 5;
    private static final String IDENTIFIER_START_TAG = "<IDENTIFIER>";
    private static final String IDENTIFIER_END_TAG = "</IDENTIFIER>";

    private List<CodeSnippet> computeIdentifierReferencesCodeSnippets(BooleanSupplier isCanceled, JsonObject input) {
        IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
        String fullPath = AIPathUtils.INSTANCE.getAbsolutePathFromFileNameOrPath(input.get("file_name_or_path").getAsString(), iProject, isCanceled);
        if (!new File(fullPath).exists()) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("File %s does not exist!", fullPath), 0));
        }
        if (AIProtectManager.INSTANCE.isFileProtected(fullPath, iProject)) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("Failed to read file '%s'. Access to this file is restricted by the user. NEVER try to read or write this file!", fullPath), 0));
        }
        IDocument document = AIUtils.getInstance().getDocumentFromPath(iProject, fullPath);
        IFile iFile = DVTFileUtils.getInstance().findProjectFile(iProject, fullPath);
        if (document == null || iFile == null) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("Failed to read file %s!", fullPath), 0));
        }
        String identifierSurroundingCode = input.get("identifier_surrounding_code").getAsString();
        if (!identifierSurroundingCode.contains(IDENTIFIER_START_TAG) || !identifierSurroundingCode.contains(IDENTIFIER_END_TAG)) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, String.format("Argument identifier_surrounding_code does not contain %s and %s tags to mark the identifier!", IDENTIFIER_START_TAG, IDENTIFIER_END_TAG), 0));
        }
        int identifierOffset = AIToolsIndexerUtils.INSTANCE.getTaggedElemOffsetInDocument(document, identifierSurroundingCode, IDENTIFIER_START_TAG, IDENTIFIER_END_TAG);
        if (identifierOffset < 0) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Identifier could not be located!", 0));
        }
        IRfNamedElementAndScope namedElementAndScope = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(new EditorPosition(iFile, identifierOffset));
        if (namedElementAndScope == null || namedElementAndScope.getIRfNamedElement() == null) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Identifier could not be located!", 0));
        }
        List<EditorRange> usagesRanges = AISnippetSolver.getInstance().getUsagesForNamedElements(new ArrayList<IRfNamedElement>(Arrays.asList(namedElementAndScope.getIRfNamedElement())), isCanceled);
        if (usagesRanges == null || usagesRanges.isEmpty()) {
            return Collections.emptyList();
        }
        return AISnippetSolver.getInstance().getUsagesWithSurroundingLinesFromRanges(usagesRanges, 5, Integer.MAX_VALUE, isCanceled);
    }

    public List<String> computeIdentifierReferences(BooleanSupplier isCanceled, JsonObject input) {
        List<CodeSnippet> identifierReferencesCS = this.computeIdentifierReferencesCodeSnippets(isCanceled, input);
        if (identifierReferencesCS == null || identifierReferencesCS.isEmpty()) {
            return Collections.emptyList();
        }
        return identifierReferencesCS.stream().sorted(CodeSnippet.DEFAULT_CODE_SNIPPETS_COMPARATOR).map(ir -> String.valueOf(ir.toString()) + System.lineSeparator().repeat(2)).collect(Collectors.toList());
    }

    @Override
    public String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeIdentifierReferences);
        if (result.getTotalElements() == 0) {
            return "No identifier reference found!";
        }
        return result.toString("Identifier References");
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
        String fullPath = AIPathUtils.INSTANCE.getAbsolutePathFromFileNameOrPath(input.get("file_name_or_path").getAsString(), iProject, isCanceled);
        File file = new File(fullPath);
        if (!file.exists()) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("File %s does not exist!", fullPath), 0));
        }
        String identifierSurroundingCode = input.get("identifier_surrounding_code").getAsString();
        if (!identifierSurroundingCode.contains(IDENTIFIER_START_TAG) || !identifierSurroundingCode.contains(IDENTIFIER_END_TAG)) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, String.format("Argument identifier_surrounding_code does not contain %s and %s tags to mark the identifier!", IDENTIFIER_START_TAG, IDENTIFIER_END_TAG), 0));
        }
        String regex = "%s(.*?)%s".formatted(IDENTIFIER_START_TAG, IDENTIFIER_END_TAG);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(identifierSurroundingCode);
        String identifier = "";
        if (matcher.find()) {
            identifier = matcher.group(1);
        }
        return "This tool will retrieve all usages of the identifier given below within the project.\nIdentifier: %s\nIdentifier Location: %s\nDo you want to continue?\n".formatted(identifier, file.getPath());
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
        String fullPath = AIPathUtils.INSTANCE.getAbsolutePathFromFileNameOrPath(input.get("file_name_or_path").getAsString(), iProject, isCanceled);
        File file = new File(fullPath);
        if (!file.exists()) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("File %s does not exist!", fullPath), 0));
        }
        String identifierSurroundingCode = input.get("identifier_surrounding_code").getAsString();
        if (!identifierSurroundingCode.contains(IDENTIFIER_START_TAG) || !identifierSurroundingCode.contains(IDENTIFIER_END_TAG)) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, String.format("Argument identifier_surrounding_code does not contain %s and %s tags to mark the identifier!", IDENTIFIER_START_TAG, IDENTIFIER_END_TAG), 0));
        }
        String regex = "%s(.*?)%s".formatted(IDENTIFIER_START_TAG, IDENTIFIER_END_TAG);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(identifierSurroundingCode);
        String identifier = "";
        if (matcher.find()) {
            identifier = matcher.group(1);
        }
        return "Get Identifier References - %s:%s".formatted(file.getName(), identifier);
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 150;
    }
}

