/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.Problem;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIInternalErrorException;
import ro.amiq.dvt.ai.model.exceptions.AIToolErrorException;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.SchemaUtils;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;

@ToolName(value="dvt_get_problems")
@ToolDisplayName(value="Get Problems (DVT)")
@ToolDescription(value="Gets compilation problems for a specific list of files. For each problem, the problem message, the line where it occurs and a 6-line context around the problem are provided.\n\n**When to use**\n\nUse this tool to identify source code compilation issues (errors, warnings).\n\nTypical scenarios:\n\n* Check that a file does not contain any errors after editing or creating it.\n* Check that the source code still compiles after deleting a piece of code.\n\n**Tool input**\n\n* `file_names_or_paths` - the file names, absolute paths or relative (to project root directory) paths of the files to get problems for. **Prefer using absolute or relative paths, when possible.**\n* `include_warnings` - a flag that controls whether warnings are included in the output of the tool. If set to false, only errors are included.\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Output format**\n\nSuppose you use this tool to find problems in file `path/to/file.sv`, which contains only 1 UNDECLARED_IDENTIFIER error, on line 25. The output will be similar to this:\n\n* UNDECLARED_IDENTIFIER: Identifier 'abc' is not declared\nProblem location: file `path/to/file.sv`, line `25`\nProblem type: error\nSurrounding code:\n```\ncontext line 1 before line with problem\ncontext line 2 before line with problem\ncontext line 3 before line with problem\nTHE LINE CONTAINING THE PROBLEM\ncontext line 1 after line with problem\ncontext line 2 after line with problem\ncontext line 3 after line with problem\n```\n")
@ToolConfirmationMessage(value="This tool will retrieve all the compilation problems reported within the specified files.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n    \"file_names_or_paths\": {\n      \"type\": \"array\",\n      \"items\": {\n\t    \"type\": \"string\"\n      },\n\t  \"description\": \"The file names, absolute paths or relative (to project root directory) paths of the files to get problems for. Prefer using absolute or relative paths, when possible.\"\n    },\n    \"include_warnings\": {\n\t  \"type\": \"boolean\",\n\t  \"nullable\": true,\n\t  \"description\": \"When set to true, both errors and warnings are included in the response. When set to false, only errors are included. Use 'false' unless instructed otherwise.\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"required\": [\"file_names_or_paths\"],\n  \"additionalProperties\": false\n}\n")
public class GetProblemsAITool
extends PaginatedAITool {
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 150;
    private static final Comparator<Problem> PROBLEM_COMPARATOR = (p1, p2) -> {
        if (!p1.getSeverity().equals(p2.getSeverity())) {
            return p1.getSeverity().equals("error") ? -1 : 1;
        }
        if (!p1.getFilePath().equals(p2.getFilePath())) {
            return p1.getFilePath().compareTo(p2.getFilePath());
        }
        return Integer.compare(p1.getLine(), p2.getLine());
    };

    public List<Problem> computeProblemsInternal(BooleanSupplier isCanceled, JsonObject input) {
        IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
        JsonArray fileNamesOrPaths = input.get("file_names_or_paths").getAsJsonArray();
        boolean includeWarnings = SchemaUtils.INSTANCE.getOptionalBooleanMember(input, "include_warnings", false);
        if (fileNamesOrPaths.size() == 0) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, "No files to retrieve problems from provided!", 0));
        }
        ArrayList<String> fullPaths = new ArrayList<String>();
        for (JsonElement element : fileNamesOrPaths) {
            String fileNameOrPath = element.getAsString();
            String fullPath = AIPathUtils.INSTANCE.getAbsolutePathFromFileNameOrPath(fileNameOrPath, iProject, isCanceled);
            File file = new File(fullPath);
            if (!file.exists()) {
                throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, String.format("File %s does not exist!", fullPath), 0));
            }
            fullPaths.add(fullPath);
        }
        ArrayList<Problem> result = new ArrayList<Problem>();
        for (String fullPath : fullPaths) {
            if (AIProtectManager.INSTANCE.isFileProtected(fullPath, iProject)) {
                throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, String.format("Failed to read file '%s'. Access to this file is restricted by the user. NEVER try to read or write this file!", fullPath), 0));
            }
            List<Problem> fileProblems = AIUtils.getInstance().getProblemsForFile(fullPath, iProject, includeWarnings);
            if (fileProblems == null) continue;
            result.addAll(fileProblems);
        }
        return result;
    }

    public List<String> computeProblems(BooleanSupplier isCanceled, JsonObject input) {
        List<Problem> problems = this.computeProblemsInternal(isCanceled, input);
        if (problems == null || problems.isEmpty()) {
            return Collections.emptyList();
        }
        return problems.stream().sorted(PROBLEM_COMPARATOR).map(p -> String.valueOf(p.toString()) + System.lineSeparator().repeat(2)).collect(Collectors.toList());
    }

    @Override
    public String invoke(BooleanSupplier isCanceled, JsonObject input) {
        JsonArray fileNamesOrPaths = input.get("file_names_or_paths").getAsJsonArray();
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeProblems);
        if (result.getTotalElements() == 0) {
            return "No problems found in " + (fileNamesOrPaths.size() == 1 ? "file" : "files") + "!";
        }
        return result.toString("Compilation Problems");
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        JsonArray fileNamesOrPaths = input.get("file_names_or_paths").getAsJsonArray();
        return "This tool will retrieve all the compilation problems reported within " + fileNamesOrPaths.size() + (fileNamesOrPaths.size() == 1 ? " file" : "files") + ".\nDo you want to continue?";
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        IProject iProject = AIToolUtils.INSTANCE.getToolCallProject(input);
        JsonArray fileNamesOrPaths = input.get("file_names_or_paths").getAsJsonArray();
        if (fileNamesOrPaths.size() == 0) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, "No files to retrieve problems from provided!", 0));
        }
        ArrayList<String> fullPaths = new ArrayList<String>();
        for (JsonElement element : fileNamesOrPaths) {
            String fileNameOrPath = element.getAsString();
            String fullPath = AIPathUtils.INSTANCE.getAbsolutePathFromFileNameOrPath(fileNameOrPath, iProject, isCanceled);
            File file = new File(fullPath);
            if (!file.exists()) {
                throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, String.format("File %s does not exist!", fullPath), 0));
            }
            fullPaths.add(fullPath);
        }
        if (fullPaths.size() == 1) {
            return "Get Problems in '%s'".formatted(new File((String)fullPaths.get(0)).getName());
        }
        return "Get Problems in " + fullPaths.size() + " files";
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 150;
    }
}

