/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import ro.amiq.dvt.ai.AISymbolSolver;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIToolErrorException;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;

@ToolName(value="dvt_get_symbol_definitions")
@ToolDisplayName(value="Get Symbol Definitions (DVT)")
@ToolDescription(value="Finds the full source-code definitions of one or more symbols that match a given query, returning the file path, line range, and the complete code block for each definition.\n\n**Supported symbol types**\n* class\n* module\n* interface\n* macro\n* file\n* typedef\n* enum\n* struct\n* union\n* package\n* package_body\n* generate\n* covergroup\n* primitive\n* checker\n* configuration\n* program\n* entity\n* type\n* type_body\n* architecture\n* scalar_type\n* sequence\n* unit\n\nIf you want to reference a VHDL symbol follow these rules:\n- If you want to refer to an entity, use 'entity:<entity_name>' as symbol_name parameter.\n- If you want to refer to an architecture and you know both the name of the architecture and the name of the associated entity, use \u2018<entity_name> [architecture_name]\u2019 as symbol_name parameter.\n- If you want to refer to all the architectures of an entity, use '<entity_name>*' as symbol_name parameter.\n- If you want to refer to an architecture without knowing the entity name, use '*[<architecture_name>]' as symbol_name parameter.\n\n**When to use**\n- To obtain the exact declarations of one or more symbols for quick code comprehension.\n- For impact analysis before a refactor, letting you see every place a type, macro, or other construct is defined.\n- To trace data-flow or control-flow by locating the source of structures, interfaces, modules, etc.\n- **Prefer this over raw text-search tools; the underlying code indexer provides exact, type-aware results, avoiding false positives from comments or similar strings.**\n\n**Usage examples**\n- **Exact name lookup** - Retrieve the definition of `xyz` by passing `xyz` as `symbol_name_query`.\n- **Wildcard lookup** - Find all definitions whose names start with `xyz` by passing `xyz*` as `symbol_name_query`.\n- **Typed query** - Locate the definition of a specific kind of symbol, e.g., `module:xyz`, `class:abc`.\n- **File contents** - Retrieve the full contents of files, e.g., `file:/projects/src/component/*.sv` to get every SystemVerilog file in that directory.\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Output format**\n\nA request for the definition of `xyz` yields a response similar to:\n\n* File `the/path/to/xyz/definition/`, lines `100-150`:\n  ```\n  first line of xyz\n  ...\n  last line of xyz\n  ```\n\nEach entry follows the same pattern: file path, inclusive line range, and the quoted source-code block that constitutes the symbol's definition.\n")
@ToolConfirmationMessage(value="This tool will retrieve all source-code definitions of the symbol(s) that match a given query.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n    \"symbol_name_query\": {\n      \"type\": \"string\",\n      \"description\": \"Exact name or wildcard query of the searched symbols.\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"required\": [\"symbol_name_query\"],\n  \"additionalProperties\": false\n}\n")
public class GetSymbolDefinitionsAITool
extends PaginatedAITool {
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 500;

    public List<String> computeSymbolDefinitions(BooleanSupplier isCanceled, JsonObject input) {
        String symbolQuery = input.get("symbol_name_query").getAsString();
        List<CodeSnippet> codeSnippets = AISymbolSolver.INSTANCE.solveSymbol(symbolQuery, Integer.MAX_VALUE, AIToolUtils.INSTANCE.getToolCallProject(input), isCanceled);
        if (codeSnippets == null || codeSnippets.isEmpty()) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, String.format("Failed to retrieve symbol definition for '%s' query! No symbol that matches this query was found.", symbolQuery), 0));
        }
        return codeSnippets.stream().map(cs -> cs.toString()).collect(Collectors.toList());
    }

    @Override
    public String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeSymbolDefinitions);
        if (result.getTotalElements() == 0) {
            return "Failed to retrieve symbols definition!";
        }
        return result.toString("Symbols Definition");
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return "This tool will retrieve all source-code definitions of the symbol(s) that match the '%s' query.\nDo you want to continue?\n".formatted(input.get("symbol_name_query").getAsString());
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        return "Get Symbol Definitions - '%s'".formatted(input.get("symbol_name_query").getAsString());
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 500;
    }
}

