/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ai.AISnippetSolver;
import ro.amiq.dvt.ai.AISymbolSolver;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.DependenciesExpansionStrategy;
import ro.amiq.dvt.ai.model.Dependency;
import ro.amiq.dvt.ai.model.DependencySource;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIToolErrorException;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;

@ToolName(value="dvt_get_symbol_dependencies")
@ToolDisplayName(value="Get Symbol Dependencies (DVT)")
@ToolDescription(value="Finds all symbols that a given symbol relies on and returns, for each dependency, the file path, line range, and the complete source-code definition.\n\n**What the tool returns**\n\nA *symbol dependency* is any other symbol that appears in the definition of the target symbol, e.g., field types, parent class types, macros, parameter types, etc.\n\n**Supported symbol types**\n* class\n* module\n* interface\n* macro\n* file\n* typedef\n* enum\n* struct\n* union\n* package\n* package_body\n* generate\n* covergroup\n* primitive\n* checker\n* configuration\n* program\n* entity\n* type\n* type_body\n* architecture\n* scalar_type\n* sequence\n* unit\n\nIf you want to reference a VHDL symbol follow these rules:\n- If you want to refer to an entity, use 'entity:<entity_name>' as symbol_name parameter.\n- If you want to refer to an architecture and you know both the name of the architecture and the name of the associated entity, use \u2018<entity_name> [architecture_name]\u2019 as symbol_name parameter.\n- If you want to refer to all the architectures of an entity, use '<entity_name>*' as symbol_name parameter.\n- If you want to refer to an architecture without knowing the entity name, use '*[<architecture_name>]' as symbol_name parameter.\n\n**When to use**\n- To grasp how a piece of code is constructed, facilitating quick code comprehension.\n- For impact analysis before undertaking a refactor; identify everything that would be affected by a change.\n- To locate the exact definitions of types, macros, or other symbols referenced inside a given symbol.\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Usage examples**\n- To retrieve the definitions of custom-type fields used in the class `xyz`, call the tool with `symbol_name = \"xyz\"`.\n- To discover which macros a module `abcd` relies on, call the tool with `symbol_name = \"abcd\"`.\n- To see the definitions of custom-type parameters inside a function that belongs to class `xyz`, call the tool with `symbol_name = \"xyz\"`.\n\n**Output format**\nRequesting the dependencies of a symbol `xyz` that depends on symbols `abc` and `def` yields a response such as:\n\n* File `the/path/to/abc/definition`, lines `100-150`:\n  ```\n  first line of abc\n  ...\n  last line of abc\n  ```\n* File `the/path/to/def/definition`, lines `40-80`:\n  ```\n  first line of def\n  ...\n  last line of def\n  ```\n")
@ToolConfirmationMessage(value="This tool will retrieve all dependencies of the given symbol.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n    \"symbol_name\": {\n      \"type\": \"string\",\n      \"description\": \"Exact name of the symbol (e.g., class, module, ...) to return dependencies for.\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"required\": [\"symbol_name\"],\n  \"additionalProperties\": false\n}\n")
public class GetSymbolDependenciesAITool
extends PaginatedAITool {
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 500;
    private static final int DEPENDENCIES_WRAPPING_CHAR_COUNT = 150;
    private static final int DEPENDENCIES_CHAR_COUNT_LIMIT = 200000;

    private List<Dependency> computeSymbolDependenciesInternal(BooleanSupplier isCanceled, JsonObject input) {
        IProject iProject;
        String symbolName = input.get("symbol_name").getAsString();
        List<IRfNamedElement> namedElements = AISymbolSolver.INSTANCE.getNamedElementsByName(symbolName, iProject = AIToolUtils.INSTANCE.getToolCallProject(input), isCanceled);
        if (namedElements == null || namedElements.isEmpty()) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, String.format("Failed to retrieve dependencies for symbol '%s'. No symbol with this name was found.", symbolName), 0));
        }
        LinkedHashSet<DependencySource> dependencySources = new LinkedHashSet<DependencySource>();
        for (IRfNamedElement namedElement : namedElements) {
            List<DependencySource> namedElementDependencySources;
            if (namedElement instanceof IMacroInfo) continue;
            if (namedElement instanceof IRfTypeAliasElement) {
                namedElement = ((IRfTypeAliasElement)namedElement).getTranslatedType();
            }
            if ((namedElementDependencySources = AISnippetSolver.getInstance().getDependencySourcesForContainer(namedElement.getDeclaration(), AIUtils.getInstance().getEditorPositionFromDefElement(namedElement.getDeclaration()), namedElement.getLanguageKind(), isCanceled)) == null) continue;
            dependencySources.addAll(namedElementDependencySources);
        }
        return AISnippetSolver.getInstance().getDependenciesFromSources(new ArrayList<DependencySource>(dependencySources), DependenciesExpansionStrategy.ADAPTIVE, 150, "\n\n".length(), 200000, isCanceled);
    }

    public List<String> computeSymbolDependencies(BooleanSupplier isCanceled, JsonObject input) {
        List<Dependency> symbolDependencies = this.computeSymbolDependenciesInternal(isCanceled, input);
        if (symbolDependencies == null || symbolDependencies.isEmpty()) {
            return Collections.emptyList();
        }
        return symbolDependencies.stream().map(sd -> String.valueOf(sd.toString()) + System.lineSeparator().repeat(2)).collect(Collectors.toList());
    }

    @Override
    protected String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeSymbolDependencies);
        if (result.getTotalElements() == 0) {
            return "No dependencies found for the given symbol!";
        }
        return result.toString("Symbol Dependencies");
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return "This tool will retrieve all dependencies of '%s'.\nDo you want to continue?\n".formatted(input.get("symbol_name").getAsString());
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        return "Get Symbol Dependencies - %s".formatted(input.get("symbol_name").getAsString());
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 500;
    }
}

