/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import ro.amiq.dvt.ai.AISymbolSolver;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIToolErrorException;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;

@ToolName(value="dvt_get_symbol_locations")
@ToolDisplayName(value="Get Symbol Locations (DVT)")
@ToolDescription(value="Finds where one or more symbols appear in the project for a given query and returns the file path together with the line range for each match.\n\n**Supported symbol types**\n* class\n* module\n* interface\n* macro\n* typedef\n* enum\n* struct\n* union\n* package\n* package_body\n* generate\n* covergroup\n* primitive\n* checker\n* configuration\n* program\n* entity\n* type\n* type_body\n* architecture\n* scalar_type\n* sequence\n* unit\n\nIf you want to reference a VHDL symbol follow these rules:\n- If you want to refer to an entity, use 'entity:<entity_name>' as symbol_name parameter.\n- If you want to refer to an architecture and you know both the name of the architecture and the name of the associated entity, use \u2018<entity_name> [architecture_name]\u2019 as symbol_name parameter.\n- If you want to refer to all the architectures of an entity, use '<entity_name>*' as symbol_name parameter.\n- If you want to refer to an architecture without knowing the entity name, use '*[<architecture_name>]' as symbol_name parameter.\n\n**When to use**\n- Quickly locate the definition of a symbol for code-understanding or impact analysis before a refactor.\n- Follow the flow of data or control by pinpointing where a symbol is declared.\n- When you simply need the definition point, not the entire code of a symbol.\n- **Prefer this over raw text-search tools; the underlying code indexer provides exact, type-aware results, avoiding false positives from comments or similar strings.**\n\n**Usage examples**\n- **Exact name lookup** - to get the location of the symbol `xyz`, pass `xyz` as the `symbol_name_query`.\n- **Wildcard search** - to retrieve every symbol that starts with `xyz`, use `xyz*` as the `symbol_name_query`.\n- **Typed query** - to find a module named `xyz`, use `module:xyz` as `symbol_name_query` (or any other supported symbol type, e.g., `class:abc`).\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Output format**\n\nA request for the location of `xyz` produces a response such as:\n\n* File `the/path/to/file/with/symbol/definition/`, lines `100-150`\n\nEach entry follows the same pattern: the file path, then the inclusive line range where the symbol is defined.\n")
@ToolConfirmationMessage(value="This tool will retrieve all places where one or more symbols appear in the project for the given query.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n    \"symbol_name_query\": {\n      \"type\": \"string\",\n      \"description\": \"Exact name or wildcard query of the searched symbols.\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"required\": [\"symbol_name_query\"],\n  \"additionalProperties\": false\n}\n")
public class GetSymbolLocationsAITool
extends PaginatedAITool {
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 40;

    private List<CodeSnippet> computeSymbolLocationsInternal(BooleanSupplier isCanceled, JsonObject input) {
        String symbolQuery = input.get("symbol_name_query").getAsString();
        List<CodeSnippet> codeSnippets = AISymbolSolver.INSTANCE.solveSymbol(symbolQuery, Integer.MAX_VALUE, AIToolUtils.INSTANCE.getToolCallProject(input), isCanceled);
        if (codeSnippets == null || codeSnippets.isEmpty()) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, String.format("Failed to retrieve symbol location for '%s' query! No symbol that matches this query was found.", symbolQuery), 0));
        }
        return codeSnippets;
    }

    public List<String> computeSymbolLocations(BooleanSupplier isCanceled, JsonObject input) {
        List<CodeSnippet> symbolLocations = this.computeSymbolLocationsInternal(isCanceled, input);
        return symbolLocations.stream().map(cs -> {
            String locationString = cs.getLocationString();
            if (locationString == null) {
                return "";
            }
            return String.valueOf(locationString) + System.lineSeparator();
        }).collect(Collectors.toList());
    }

    @Override
    public String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeSymbolLocations);
        if (result.getTotalElements() == 0) {
            return "Failed to retrieve symbols location!";
        }
        return result.toString("Symbols Location");
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return "This tool will retrieve all places where one or more symbols appear in the project for the '%s' query.\nDo you want to continue?\n".formatted(input.get("symbol_name_query").getAsString());
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        return "Get Symbol Locations - '%s'".formatted(input.get("symbol_name_query").getAsString());
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 40;
    }
}

