/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ai.AISnippetSolver;
import ro.amiq.dvt.ai.AISymbolSolver;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.EditorRange;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIToolErrorException;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.model.reflection.IRfNamedElement;

@ToolName(value="dvt_get_symbol_references")
@ToolDisplayName(value="Get Symbol References (DVT)")
@ToolDescription(value="Finds every usage of a given symbol across the project and returns each occurrence together with the file name, line range, and a 10-line excerpt that shows the reference in context.\n\n**Supported symbol types**\n* class\n* module\n* interface\n* macro\n* typedef\n* enum\n* struct\n* union\n* package\n* package_body\n* generate\n* covergroup\n* primitive\n* checker\n* configuration\n* program\n* entity\n* type\n* type_body\n* architecture\n* scalar_type\n* sequence\n* unit\n\nDo **NOT** use this tool for code entities that are not in the list above (e.g., class members, struct members, function parameters, function local variables, module instances, module ports, etc.).\nUse the *dvt_get_identifier_references* tool for such scenarios.\n\nIf you want to reference a VHDL symbol follow these rules:\n- If you want to refer to an entity, use 'entity:<entity_name>' as symbol_name parameter.\n- If you want to refer to an architecture and you know both the name of the architecture and the name of the associated entity, use \u2018<entity_name> [architecture_name]\u2019 as symbol_name parameter.\n- If you want to refer to all the architectures of an entity, use '<entity_name>*' as symbol_name parameter.\n- If you want to refer to an architecture without knowing the entity name, use '*[<architecture_name>]' as symbol_name parameter.\n\n**When to use**\n- Quickly locate every place a symbol is referenced for code-understanding or impact analysis before a refactor.\n- Follow data or control flow by seeing where classes, modules, macros, files, etc., are instantiated, typed, included, or otherwise used.\n- **Prefer this over raw text-search tools; the underlying code indexer provides exact, type-aware results, avoiding false positives from comments or similar strings.**\n\n**Usage examples**\n- To find where any kind of symbol is used.\n- To find where a `sub_component` module is instantiated, use this tool and pass `sub_component` as `symbol_name` argument.\n- To find where a `protocol_env` class is used as type for a member, variable or parameter, use this tool and pass `protocol_env` as `symbol_name` argument.\n- To find where a `file.sv` is included, use this tool and pass `file.sv` as `symbol_name` argument.\n- To find where a `PORT_WIDTH` macro is used, use this tool and pass `PORT_WIDTH` as `symbol_name` argument.\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Output format**\n\nA request for the references of `xyz` that yields one match would be returned as follows:\n\n* File `the/path/to/file/with/symbol/reference/`, lines `100-110`:\n  ```\n  context line 1 before the reference\n  ...\n  context line 5 before the reference\n  THE LINE CONTAINING THE REFERENCE TO xyz\n  context line 1 after the reference\n  ...\n  context line 5 after the reference\n  ```\n\nEach entry includes the file path, the inclusive line range covering the 10-line window, and the quoted snippet that provides surrounding context for the reference.\n")
@ToolConfirmationMessage(value="This tool will retrieve all usages of the given symbol across the project.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n    \"symbol_name\": {\n      \"type\": \"string\",\n      \"description\": \"Exact name of the symbol (e.g., class, module, ...) to search the references for.\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"required\": [\"symbol_name\"],\n  \"additionalProperties\": false\n}\n")
public class GetSymbolReferencesAITool
extends PaginatedAITool {
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 150;
    private static final int NUMBER_OF_SURROUNDING_LINES_FOR_REFERENCES = 5;

    private List<CodeSnippet> computeSymbolReferencesInternal(BooleanSupplier isCanceled, JsonObject input) {
        IProject project = AIToolUtils.INSTANCE.getToolCallProject(input);
        String symbolName = input.get("symbol_name").getAsString();
        List<IRfNamedElement> namedElements = AISymbolSolver.INSTANCE.getNamedElementsByName(symbolName, project, isCanceled);
        if (namedElements == null || namedElements.isEmpty()) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, String.format("Failed to retrieve references for '%s' symbol! No symbol with this name was found.", symbolName), 0));
        }
        List<EditorRange> usagesRanges = AISnippetSolver.getInstance().getUsagesForNamedElements(namedElements, isCanceled);
        if (usagesRanges == null || usagesRanges.isEmpty()) {
            return Collections.emptyList();
        }
        return AISnippetSolver.getInstance().getUsagesWithSurroundingLinesFromRanges(usagesRanges, 5, Integer.MAX_VALUE, isCanceled);
    }

    protected List<String> computeSymbolReferences(BooleanSupplier isCanceled, JsonObject input) {
        List<CodeSnippet> symbolReferences = this.computeSymbolReferencesInternal(isCanceled, input);
        if (symbolReferences == null || symbolReferences.isEmpty()) {
            return Collections.emptyList();
        }
        return symbolReferences.stream().sorted(CodeSnippet.DEFAULT_CODE_SNIPPETS_COMPARATOR).map(cs -> String.valueOf(cs.toString()) + System.lineSeparator().repeat(2)).collect(Collectors.toList());
    }

    @Override
    public String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeSymbolReferences);
        if (result.getTotalElements() == 0) {
            return "No symbol reference found!";
        }
        return result.toString("Symbol References");
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return "This tool will retrieve all usages of '%s' across the project.\nDo you want to continue?\n".formatted(input.get("symbol_name").getAsString());
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        return "Get Symbol References - '%s'".formatted(input.get("symbol_name").getAsString());
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 150;
    }
}

