/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIInternalErrorException;
import ro.amiq.dvt.ai.model.exceptions.AIToolErrorException;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.views.EVHTopUnitContributor;
import ro.amiq.edt.base.model.reflection.views.VHHistoryItem;
import ro.amiq.edt.model.reflection.views.EVHViewContributor;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;

@ToolName(value="dvt_get_verification_subcomponents")
@ToolDisplayName(value="Get Verification Subcomponents (DVT)")
@ToolDescription(value="Retrieves all subcomponents of a specified UVM verification component.\n\nVerification subcomponents are UVM elements (e.g., drivers, monitors, etc.) that are instantiated inside the specified verification component.\n\n**When to use**\n\nUse this tool, along with the *dvt_get_verification_top* tool, to explore and understand the architecture of the UVM verification code of the working project.\n\n**Usage examples**\n\n* To list the subcomponents of the top component `test_top`, pass `test_top` as the `verification_component_path` argument.\n* To list the subcomponents of an instance `i_subc` inside `test_top`, pass `test_top.i_subc` as the `verification_component_path` argument.\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Output format**\n\nThe tool returns a plain-text list where each line shows an instance name, a colon, and the class name of the instantiated component. Example:\n\n```\ni_class1 : class1\ni_class2 : class2\n```\n")
@ToolConfirmationMessage(value="This tool will retrieve all subcomponents of the given UVM verification component.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n    \"verification_component_path\": {\n      \"type\": \"string\",\n      \"description\": \"The hierarchical path of the verification component (starting from the verification top) whose subcomponents should be retrieved. This path is composed of subcomponents names separated by dots, starting from the verification top element, e.g., 'apb_gpio_simple_test.ve.apb_ss_cfg'.\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"required\": [\"verification_component_path\"],\n  \"additionalProperties\": false\n}\n")
public class GetVerificationSubcomponentsAITool
extends PaginatedAITool {
    private static final int ESTIMATED_RESULT_TOKENS_ON_SINGLE_ENTRY = 10;
    private static final String SUBCOMPONENTS_SEPARATOR = "\n";
    private static final String PACKAGE_SEPARATOR = "::";

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return "This tool will retrieve all subcomponents of '%s'.\nDo you want to continue?\n".formatted(input.get("verification_component_path").getAsString());
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        return "Get Verification Subcomponents - '%s'".formatted(input.get("verification_component_path").getAsString());
    }

    protected List<String> computeVerificationSubcomponents(BooleanSupplier isCanceled, JsonObject input) {
        List<String> eLangResult;
        List<String> svResult;
        String verificationComponentPath = input.get("verification_component_path").getAsString();
        HistoryItem topHistoryItem = AIUtils.getInstance().getVHTop(AIToolUtils.INSTANCE.getToolCallProject(input));
        List<String> result = new ArrayList<String>();
        if (topHistoryItem instanceof ro.amiq.vlogdt.model.reflection.views.VHHistoryItem && (svResult = this.getSubcomponentsSV((ro.amiq.vlogdt.model.reflection.views.VHHistoryItem)topHistoryItem, verificationComponentPath)) != null) {
            result = svResult;
        }
        if (topHistoryItem instanceof VHHistoryItem && (eLangResult = this.getSubcomponentsElang((VHHistoryItem)topHistoryItem, verificationComponentPath)) != null) {
            result = eLangResult;
        }
        return result;
    }

    @Override
    protected String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeVerificationSubcomponents);
        if (result.getTotalElements() == 0) {
            return "Verification component does not have any subcomponents!";
        }
        return result.toString("Verification Subcomponents");
    }

    private List<String> getSubcomponentsSV(ro.amiq.vlogdt.model.reflection.views.VHHistoryItem topHistoryItem, String verificationComponentPath) {
        List<IRfBreadcrumbElement> segments;
        IRfNamedElement topElement = topHistoryItem.getNamedElement();
        if (!(topElement instanceof RfClass)) {
            return null;
        }
        String[] pathSegments = verificationComponentPath.split("\\.");
        IProject project = topHistoryItem.getProject();
        RfClass topClass = (RfClass)topElement;
        List<IRfBreadcrumbElement> list = segments = XXVMBuilder.INSTANCE.isComputed() ? this.internalSearchInterpInstance(pathSegments) : this.internalSearchStaticInstance(topClass, pathSegments, project);
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (IRfBreadcrumbElement xvmBase : segments) {
            String instanceName;
            String className;
            String string = xvmBase instanceof RfXvmObjectInstance ? ((RfXvmObjectInstance)xvmBase).getObject().getName() : (className = xvmBase instanceof IXXVMObject ? ((IXXVMComponent)xvmBase).getSanitizedType(LanguageKind.VLOG, false) : xvmBase.getName());
            if (className == null || (instanceName = xvmBase.getName()) == null) continue;
            result.add(String.valueOf(instanceName) + " : " + className + SUBCOMPONENTS_SEPARATOR);
        }
        return result;
    }

    private List<String> getSubcomponentsElang(VHHistoryItem topHistoryItem, String verificationComponentPath) {
        IProject iProject = topHistoryItem.getProject();
        if (iProject == null) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to determine the current working project!", 0));
        }
        EVHViewContributor contributor = this.getEContributor();
        if (contributor == null) {
            return null;
        }
        IRfSingleLangProject singleLangProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, LanguageKind.E.NATURE_ID, false);
        if (!(singleLangProject instanceof RfProject)) {
            return null;
        }
        List tops = EVHTopUnitContributor.INSTANCE.getAllTops((RfProject)singleLangProject);
        if (tops == null || tops.isEmpty()) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, "Verification top is not set!", 0));
        }
        String[] tokens = verificationComponentPath.split("\\.");
        String topElementName = null;
        String remainingPath = null;
        if (tokens[0].contains(PACKAGE_SEPARATOR)) {
            topElementName = tokens[1];
            if (tokens.length > 2) {
                remainingPath = verificationComponentPath.substring(tokens[0].length() + tokens[1].length() + 2);
            }
        } else {
            topElementName = tokens[0];
            if (tokens.length > 1) {
                remainingPath = verificationComponentPath.substring(tokens[0].length() + 1);
            }
        }
        Object topStruct = null;
        for (RfStruct top : tops) {
            if (!topElementName.equals(top.getName())) continue;
            topStruct = top;
            break;
        }
        if (topStruct == null) {
            throw new AIToolErrorException(new AIExceptionData(AIExceptionKind.TOOL_CALL_ERROR.KIND, "Verification top is not set!", 0));
        }
        Object lastElementInPath = remainingPath == null ? topStruct : this.getLastElementInPathELang((RfStruct)topStruct, remainingPath, iProject, contributor);
        return this.getAllChildrenFormattedELang(lastElementInPath, iProject, contributor);
    }

    private List<IRfBreadcrumbElement> internalSearchInterpInstance(String[] pathSegments) {
        LinkedList<IRfBreadcrumbElement> segments;
        block6: {
            IXXVMComponent xvmRootComponent = XXVMBuilder.INSTANCE.getXVMRootComponent();
            if (xvmRootComponent == null) {
                return Collections.emptyList();
            }
            IXXVMComponent topComponent = xvmRootComponent;
            if (DVTXRunBuildPhaseUtils.XVM_ROOT.contains(xvmRootComponent.getName()) || DVTXRunBuildPhaseUtils.XVM_ROOT.contains(xvmRootComponent.getRfClass().getName())) {
                List children = xvmRootComponent.getChildren();
                for (IXXVMComponent component : children) {
                    if (!pathSegments[0].equals(component.getName())) continue;
                    topComponent = component;
                    break;
                }
            }
            segments = new LinkedList<IRfBreadcrumbElement>();
            try {
                if (this.internalSearchInterpInstanceRecursively(topComponent, pathSegments, 1, segments)) break block6;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return segments;
    }

    private boolean internalSearchInterpInstanceRecursively(IXXVMComponent parentComponent, String[] pathSegments, int segmentIdx, List<IRfBreadcrumbElement> result) {
        if (segmentIdx >= pathSegments.length) {
            result.addAll(parentComponent.getChildren());
            return true;
        }
        List children = parentComponent.getChildren();
        if (children == null || children.isEmpty()) {
            return false;
        }
        for (IXXVMComponent component : children) {
            if (!pathSegments[segmentIdx].equals(component.getName())) continue;
            return this.internalSearchInterpInstanceRecursively(component, pathSegments, segmentIdx + 1, result);
        }
        return false;
    }

    private List<IRfBreadcrumbElement> internalSearchStaticInstance(RfClass vhTop, String[] pathSegments, IProject project) {
        LinkedList<IRfBreadcrumbElement> segments;
        block3: {
            RfXvmFactory xvmFactory = RfVHUtils.getXvmFactory((IProject)project);
            RfXvmObject topSegment = xvmFactory.getRegisteredObject(vhTop);
            segments = new LinkedList<IRfBreadcrumbElement>();
            try {
                if (this.internalSearchStaticInstanceRecursively(xvmFactory, topSegment, pathSegments, 1, segments)) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return segments;
    }

    private boolean internalSearchStaticInstanceRecursively(RfXvmFactory xvmFactory, RfXvmObject parentSegment, String[] pathSegments, int segmentIdx, List<IRfBreadcrumbElement> result) {
        if (segmentIdx >= pathSegments.length) {
            List childInstances = RfXvmFactory.getChildInstances((RfXvmObject)parentSegment);
            result.addAll(childInstances);
            return true;
        }
        RfClass parentClass = parentSegment.getRfClass();
        RfXvmObject registeredObject = xvmFactory.getRegisteredObject(parentClass);
        List childInstances = RfXvmFactory.getChildInstances((RfXvmObject)registeredObject);
        for (RfXvmObjectInstance child : childInstances) {
            if (!pathSegments[segmentIdx].equals(child.getName())) continue;
            RfXvmObject object = child.getObject();
            return this.internalSearchStaticInstanceRecursively(xvmFactory, object, pathSegments, segmentIdx + 1, result);
        }
        return false;
    }

    private List<String> getAllChildrenFormattedELang(Object parentElement, IProject iProject, EVHViewContributor contributor) {
        if (parentElement == null) {
            return null;
        }
        List children = contributor.getChildrenForElement(parentElement, null, false, false, false, iProject, (IProgressMonitor)new NullProgressMonitor());
        if (children == null || children.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object child : children) {
            String childString = child.toString();
            if (child instanceof RfStructMember var9_9) {
                childString = structMember.getName();
                associatedTypeName = structMember.getSignatureTypeName();
                if (associatedTypeName != null) {
                    childString = String.valueOf(childString) + " : " + (String)associatedTypeName;
                }
            } else {
                 instanceOfPatternExpressionValue = child;
                if ( instanceOfPatternExpressionValue instanceof RfStructLayer && (associatedTypeName = (RfStructLayer) instanceOfPatternExpressionValue) == (RfStructLayer) instanceOfPatternExpressionValue) {
                    childString = structLayer.getName();
                    RfStruct struct = structLayer.getStruct();
                    if (struct != null && struct.getName() != null) {
                        childString = String.valueOf(childString) + " : " + struct.getName();
                    }
                }
            }
            result.add(String.valueOf(childString) + SUBCOMPONENTS_SEPARATOR);
        }
        return result;
    }

    private Object getLastElementInPathELang(RfStruct topElement, String remainingPath, IProject iProject, EVHViewContributor contributor) {
        String[] pathComponents = remainingPath.split("\\.");
        RfStruct currentElement = topElement;
        String[] stringArray = pathComponents;
        int n = pathComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String pathComponent = stringArray[n2];
            List children = contributor.getChildrenForElement((Object)currentElement, null, false, false, false, iProject, (IProgressMonitor)new NullProgressMonitor());
            if (children == null) {
                return null;
            }
            currentElement = null;
            for (Object child : children) {
                if (child instanceof RfStructLayer var14_14 && pathComponent.equals(structLayer.getName())) {
                    currentElement = structLayer;
                    break;
                }
                 instanceOfPatternExpressionValue = child;
                if (!( instanceOfPatternExpressionValue instanceof IRfNamedElement) || (var16_16 = (IRfNamedElement) instanceOfPatternExpressionValue) != (IRfNamedElement) instanceOfPatternExpressionValue || !pathComponent.equals(namedElement.getName())) continue;
                currentElement = namedElement;
                break;
            }
            if (currentElement == null) break;
            ++n2;
        }
        return currentElement;
    }

    private EVHViewContributor getEContributor() {
        List contributors = DVTViewContributors.getInstance().getAllInstanceOf(IVHViewContributor.class);
        if (contributors == null) {
            return null;
        }
        EVHViewContributor result = null;
        for (IVHViewContributor contributor : contributors) {
            if (!(contributor instanceof EVHViewContributor var5_5)) continue;
            result = eContributor;
            break;
        }
        return result;
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 10;
    }
}

